<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section animated fadeIn" id="ecs-intro-active">
        <nav>
            <ul class="ecs-menu ecs-clearfix">
                <li class="ecs-menu-about animated fadeIn"><a href="#ecs-aboutus-active" class="ecs-scroll-trigger"><?php echo (!empty($template_settings[ 'template_12' ][ 'about_menu_label' ])) ? esc_attr($template_settings[ 'template_12' ][ 'about_menu_label' ]) : __('About Us', 'everest-gallery'); ?></a></li>
                <li class="ecs-menu-contact animated fadeIn"><a href="#ecs-contact-active" class="ecs-scroll-trigger"><?php echo (!empty($template_settings[ 'template_12' ][ 'contact_menu_label' ])) ? esc_attr($template_settings[ 'template_12' ][ 'contact_menu_label' ]) : __('Contact', 'everest-gallery'); ?></a></li>
                <li class="ecs-menu-location animated fadeIn"><a href="#ecs-location-active" class="ecs-scroll-trigger"><?php echo (!empty($template_settings[ 'template_12' ][ 'location_menu_label' ])) ? esc_attr($template_settings[ 'template_12' ][ 'location_menu_label' ]) : __('Location', 'everest-gallery'); ?></a></li>
            </ul>
        </nav>
        <div class="ecs-intro-content-wrap">
            <div class="ecs-container">
                <div class="ecs-logo-wrapper animated fadeIn" >
                    <?php if ( !empty($component_settings[ 'logo' ]) ) { ?>
                        <a href="<?php echo site_url(); ?>">
                            <img src="<?php echo esc_url($component_settings[ 'logo' ]); ?>">
                        </a>
                    <?php } ?>
                </div>
                <div class="ecs-intro-content-title animated fadeIn" >
                    <?php if ( $header_text != '' ) { ?>
                        <h2><?php echo $header_text; ?></h2>
                    <?php }
                    ?>
                </div>
                <div class="ecs-countdown-wrap animated fadeIn" >
                    <?php
                    include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-aboutus-section" id="ecs-aboutus-active">
        <div class="ecs-container">
            <?php if ( $about_us_title != '' ) { ?>
                <h3 class="ecs-section-content-title"><?php echo $about_us_title; ?></h3>
            <?php }
            ?>
            <?php if ( $about_us_description != '' ) { ?>
                <div class="ecs-content-description">
                    <?php echo $about_us_description; ?>
                </div>
            <?php } ?>
            <div class="ecs-subscription-form-wrap">
                <form id="ecs-subscription-form" class="ecs-clearfix" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                    <div class="ecs-input-wrap">
                        <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                    </div>
                    <button type="submit" class="ecs-button"><?php echo $subscribe_button_label; ?></button>
                    <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                    <div class="ecs-subscription-message"></div>
                </form>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section" id="ecs-contact-active">
        <div class="ecs-contact-content">
            <div class="ecs-contact-top-wrap">
                <div class="ecs-container">
                    <?php if ( $contact_us_title != '' ) { ?>
                        <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                        <?php
                    }

                    if ( $contact_us_description != '' ) {
                        ?>
                        <div class="ecs-content-description">
                            <?php echo $contact_us_description; ?>
                        </div>
                    <?php } ?>
                    <div class="ecs-contact-info-outer-wrap ecs-clearfix">
                        <?php if ( $phone_value != '' ) { ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <span class="ecs-contact-icon">
                                        <i class="fa fa-phone"></i>
                                    </span>
                                    <div class="ecs-contact-details">
                                        <?php
                                        $phone_value_array = explode(',', $phone_value);
                                        foreach ( $phone_value_array as $phone_value ) {
                                            ?>
                                            <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if ( $address_value != '' ) { ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <span class="ecs-contact-icon">
                                        <i class="fa fa-map-marker"></i>
                                    </span>
                                    <div class="ecs-contact-details">
                                        <?php echo str_replace(',', ',<br/>', $address_value); ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if ( $email_value != '' ) { ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <span class="ecs-contact-icon">
                                        <i class="fa fa-envelope"></i>
                                    </span>
                                    <div class="ecs-contact-details">
                                        <?php
                                        $email_value_array = explode(',', $email_value);
                                        foreach ( $email_value_array as $email_value ) {
                                            ?>
                                            <p><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></p>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="ecs-contact-bottom-wrap">
                <div class="ecs-container ecs-clearfix">
                    <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                        <div class="ecs-input-top-wrap ecs-clearfix">
                            <div class="ecs-input-left-wrapper">
                                <div class="ecs-input-wrap">
                                    <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                                    <div class="ecs-contact-error ecs-name-error"></div>
                                </div>
                                <div class="ecs-input-wrap">
                                    <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                                    <div class="ecs-contact-error ecs-email-error"></div>
                                </div>
                            </div>
                            <div class="ecs-input-wrap ecs-input-right-wrapper">
                                <textarea placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                                <div class="ecs-contact-error ecs-message-error"></div>
                            </div>
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $submit_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                        <div class="ecs-email-message"></div>
                    </form>
                    <?php if ( !empty($social_networks) ) { ?>
                        <div class="ecs-social-share-wrap">
                            <?php
                            foreach ( $social_networks as $social_network => $url ) {
                                if ( $url != '' ) {
                                    ?>
                                    <a href="<?php echo $url; ?>" class="ecs-social-icon ecs-<?php echo $social_network; ?>">
                                        <i class="fa fa-<?php echo $social_network; ?>"></i>
                                    </a>
                                    <?php
                                }
                            }
                            ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-location-section" id="ecs-location-active">
        <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
    </div>

</div>