<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section">
        <div class="ecs-intro-left-section animated slideInLeft">
            <div class="ecs-intro-inner-container">
                <div class="ecs-countdown-wrap animated slideInDown">
                    <div class="ecs-timer-wrap" data-timer-day-color="#dd486a" data-timer-hour-color="#fc812c" data-timer-minute-color="#1099e0" data-timer-second-color="#9fc335" data-timer-bgcolor="#222">
                        <?php include(ECS_PATH . 'inc/views/frontend/components/circle-timer.php'); ?>
                    </div>
                </div>
                <div class="ecs-intro-content-title animated slideInLeft">
                    <h2><?php echo $header_text; ?></h2>
                </div>
                <?php if ( $loader_percentage != '' ) { ?>
                    <div class="ecs-progress-bar animated slideInLeft">
                        <div class="ecs-progress-bar-length" style="width:<?php echo $loader_percentage; ?>%">
                            <span class="ecs-progress-count"><?php echo $loader_label; ?></span>
                        </div>
                    </div>
                <?php } ?>
                <div class="ecs-section-link-wrap ecs-clearfix">
                    <a href="#ecs-subscription-active" class="ecs-subscription-link ecs-section-trigger ecs-id-link animated slideInLeft"><?php echo (!empty($template_settings[ 'template_11' ][ 'notify_me_label' ]) ? esc_attr($template_settings[ 'template_11' ][ 'notify_me_label' ]) : __('Notify Me', 'everest-coming-soon')); ?></a>
                    <a href="#ecs-contact-active" class="ecs-contact-link ecs-section-trigger ecs-id-link animated slideInRight"><?php echo (!empty($template_settings[ 'template_11' ][ 'contact_us_label' ]) ? esc_attr($template_settings[ 'template_11' ][ 'contact_us_label' ]) : __('Contact Us', 'everest-coming-soon')); ?></a>
                </div>
            </div>
        </div>
        <div class="ecs-intro-right-section animated slideInDown">
            <div class="ecs-intro-inner-container">

                <?php if ( !empty($component_settings[ 'logo' ]) ) { ?>
                    <div class="ecs-logo-wrapper animated flipInX"s">
                         <a href="<?php echo site_url(); ?>">
                            <img src="<?php echo esc_url($component_settings[ 'logo' ]); ?>">
                        </a>
                    </div>
                <?php } ?>
                <div class="ecs-aboutus-section">
                    <?php if ( $about_us_title != '' ) { ?>
                        <h3 class="ecs-section-content-title animated fadeIn"><?php echo $about_us_title; ?></h3>
                        <?php
                    }
                    if ( $about_us_description != '' ) {
                        ?>
                        <div class="ecs-content-description animated fadeIn">
                            <?php echo $about_us_description; ?>
                        </div>
                    <?php } ?>
                </div>
                <?php
                if ( !empty($social_networks) ) {
                    ?>
                    <div class="ecs-social-share-wrap animated fadeInUp">
                        <?php
                        foreach ( $social_networks as $social_network => $url ) {
                            if ( $url != '' ) {
                                ?>
                                <a href="<?php echo $url; ?>" class="ecs-social-icon ecs-<?php echo $social_network; ?>">
                                    <i class="fa fa-<?php echo $social_network; ?>"></i>
                                </a>
                                <?php
                            }
                        }
                        ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-subscription-section ecs-inactive-section" id="ecs-subscription-active">
        <div class="ecs-section-inner-container">
            <span class="ecs-close">
                <i class="fa fa-close"></i>
            </span>
            <div class="ecs-subscription-content">
                <h3 class="ecs-section-content-title"><?php echo $subscription_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $subscription_description; ?>
                </div>
                <div class="ecs-subscription-form-wrap">
                    <form id="ecs-subscription-form" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                        </div>
                        <button type="submit" class="ecs-button"><i class="fa fa-paper-plane"></i> <?php echo $subscribe_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                        <div class="ecs-subscription-message"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section ecs-inactive-section" id="ecs-contact-active">
        <div class="ecs-section-inner-container">
            <span class="ecs-close">
                <i class="fa fa-close"></i>
            </span>
            <div class="ecs-contact-content">
                <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $contact_us_description; ?>
                </div>
                <div class="ecs-contact-form-wrap">
                    <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                            <div class="ecs-contact-error ecs-name-error"></div>
                        </div>
                        <div class="ecs-input-wrap">
                            <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                            <div class="ecs-contact-error ecs-email-error"></div>
                        </div>
                        <div class="ecs-input-wrap">
                            <textarea  placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                            <div class="ecs-contact-error ecs-message-error"></div>
                        </div>
                        <button type="submit" class="ecs-button"><i class="fa fa-paper-plane"></i> <?php echo $submit_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                        <div class="ecs-email-message"></div>
                    </form>
                </div>
                <div class="ecs-contact-info-wrap ecs-clearfix">
                    <?php if ( $phone_value != '' ) { ?>
                        <div class="ecs-contact-info ecs-phone-details">
                            <div class="ecs-contact-icon">
                                <i class="fa fa-phone"></i>
                                <span><?php echo $phone_label; ?></span>
                            </div>
                            <?php
                            $phone_value_array = explode(',', $phone_value);
                            foreach ( $phone_value_array as $phone_value ) {
                                ?>
                                <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                <?php
                            }
                            ?>
                        </div>
                    <?php } ?>
                    <?php if ( $address_value != '' ) { ?>
                        <div class="ecs-contact-info ecs-address-details">
                            <div class="ecs-contact-icon">
                                <i class="fa fa-map-marker"></i>
                                <span><?php echo $address_label; ?></span>
                            </div>
                            <p><?php echo $address_value; ?></p>
                        </div>
                    <?php } ?>
                    <?php if ( $email_value != '' ) { ?>
                        <div class="ecs-contact-info ecs-mailing-details">
                            <div class="ecs-contact-icon">
                                <i class="fa fa-envelope"></i>
                                <span><?php echo $email_label; ?></span>
                            </div>
                            <?php
                            $email_value_array = explode(',', $email_value);
                            foreach ( $email_value_array as $email_value ) {
                                ?>
                                <p><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></p>
                                <?php
                            }
                            ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="ecs-section ecs-location-section">
                <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
            </div>
        </div>
    </div>
</div>