<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section">
        <div class="ecs-intro-content-wrap">
            <div class="ecs-container">
                <?php if ( !empty($component_settings[ 'logo' ]) ) { ?>
                    <div class="ecs-logo-wrapper animated slideInDown">
                        <a href="<?php echo site_url(); ?>">
                            <img src="<?php echo esc_url($component_settings[ 'logo' ]); ?>">
                        </a>
                    </div>
                <?php } ?>
                <div class="ecs-intro-content-title animated fadeIn">
                    <?php if ( $header_text != '' ) { ?><h2><?php echo $header_text; ?></h2><?php } ?>
                </div>
                <?php if ( $site_short_description != '' ) { ?>
                    <div class="ecs-intro-description animated fadeIn">
                        <?php echo $site_short_description; ?>
                    </div>
                <?php } ?>
                <div class="ecs-countdown-wrap ecs-clearfix animated fadeInUp">
                    <?php
                    include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                    ?>
                </div>
                <div class="ecs-readmore-bttn-wrap animated zoomIn">
                    <div class="ecs-readmore-button">
                        <a class="ecs-id-link" href="#ecs-more-details"><?php echo (!empty($template_settings[ 'template_10' ][ 'read_more_label' ])) ? esc_attr($template_settings[ 'template_10' ][ 'read_more_label' ]) : __('Read More', 'everest-coming-soon'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-more-details-section ecs-container" id="ecs-more-details">
        <div class="ecs-more-details-inner-wrap">
            <div class="ecs-section ecs-aboutus-section">
                <div class="ecs-inner-container">
                    <?php if ( $about_us_title != '' ) { ?>
                        <h3 class="ecs-section-content-title"><?php echo $about_us_title; ?></h3>
                        <?php
                    }
                    if ( $about_us_description != '' ) {
                        ?>
                        <div class="ecs-content-description">
                            <?php echo $about_us_description; ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="ecs-section ecs-subscription-section">
                <div class="ecs-inner-container">
                    <div class="ecs-subscription-content">
                        <?php if ( $subscription_title != '' ) { ?>
                            <h3 class="ecs-section-content-title"><?php echo $subscription_title; ?></h3>
                            <?php
                        }
                        if ( $subscription_description != '' ) {
                            ?>
                            <div class="ecs-content-description">
                                <?php echo $subscription_description; ?>
                            </div>
                        <?php } ?>
                        <div class="ecs-subscription-form-wrap">
                            <form id="ecs-subscription-form" class="ecs-clearfix" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                                <div class="ecs-input-wrap">
                                    <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label ?>" />
                                </div>
                                <button type="submit" class="ecs-button"><i class="fa fa-location-arrow"></i></button>
                                <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                                <div class="ecs-subscription-message"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ecs-section ecs-contact-section">
                <div class="ecs-inner-container">
                    <div class="ecs-contact-content">
                        <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                        <div class="ecs-content-description">
                            <?php echo $contact_us_description; ?>
                        </div>
                        <div class="ecs-contact-bottom-wrap ecs-clearfix">
                            <div class="ecs-left-contact-wrap">
                                <?php if ( $address_value != '' ) { ?>
                                    <div class="ecs-contact-info ecs-address-details">
                                        <div class="ecs-contact-info-title"><?php echo $address_label; ?></div>
                                        <p>
                                            <?php echo str_replace(',', ',<br/>', $address_value); ?>
                                        </p>
                                    </div>
                                    <?php
                                }
                                if ( $email_value != '' ) {
                                    ?>
                                    <div class="ecs-contact-info ecs-mailing-details">
                                        <div class="ecs-contact-info-title"><?php echo $email_label; ?></div>
                                        <?php
                                        $email_value_array = explode(',', $email_value);
                                        foreach ( $email_value_array as $email_value ) {
                                            ?>
                                            <p><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></p>
                                            <?php
                                        }
                                        ?>

                                    </div>
                                    <?php
                                }
                                if ( $phone_value != '' ) {
                                    ?>
                                    <div class="ecs-contact-info ecs-phone-details">
                                        <div class="ecs-contact-info-title"><?php echo $phone_label; ?></div>
                                        <?php
                                        $phone_value_array = explode(',', $phone_value);
                                        foreach ( $phone_value_array as $phone_value ) {
                                            ?>
                                            <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="ecs-right-contact-wrap">
                                <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                                    <div class="ecs-input-wrap">
                                        <label for="name"><?php echo $name_field_label; ?></label>
                                        <input type="text" name="contact_name" />
                                        <div class="ecs-contact-error ecs-name-error"></div>
                                    </div>
                                    <div class="ecs-input-wrap">
                                        <label for="email"><?php echo $email_field_label; ?></label>
                                        <input type="email" name="contact_email"/>
                                        <div class="ecs-contact-error ecs-email-error"></div>
                                    </div>
                                    <div class="ecs-input-wrap">
                                        <label for="message"><?php echo $message_field_label; ?></label>
                                        <textarea name="contact_message"></textarea>
                                        <div class="ecs-contact-error ecs-message-error"></div>
                                    </div>
                                    <button type="submit" class="ecs-button">send</button>
                                    <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                                    <div class="ecs-email-message"></div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ecs-section ecs-location-section">
                <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
            </div>
            <?php
            if ( !empty($social_networks) ) {
                ?>
                <div class="ecs-social-share-wrap">
                    <?php
                    foreach ( $social_networks as $social_network => $url ) {
                        if ( $url != '' ) {
                            ?>
                            <a href="<?php echo $url; ?>" class="ecs-social-icon ecs-<?php echo $social_network; ?>">
                                <i class="fa fa-<?php echo $social_network; ?>"></i>
                            </a>
                            <?php
                        }
                    }
                    ?>
                </div>
            <?php } ?>
        </div>
    </div>
    <div class="ecs-temp10-close" data-close-id="#ecs-more-details">
        <span class="ecs-close-icon"></span>
    </div>
</div>