<?php
defined('ABSPATH') or die('No script kiddies please!!');
include(ECS_PATH . '/inc/views/frontend/variables.php');
?>
<!DOCTYPE html>
<html>
    <head>
        <title><?php echo $site_title; ?></title>
        <?php
        /**
         * Disable search engine crawling
         */
        if ( isset($general_settings[ 'hide_search' ]) && $general_settings[ 'hide_search' ] == '1' ) {
            ?>
            <meta name='robots' content='noindex,nofollow' />
        <?php } ?>
        <?php if ( !empty($general_settings[ 'meta_tag_name' ]) ) { ?>
            <meta name="<?php echo esc_attr($general_settings[ 'meta_tag_name' ]); ?>" content="<?php echo (!empty($general_settings[ 'meta_tag_content' ])) ? esc_attr($general_settings[ 'meta_tag_content' ]) : ''; ?>" />
        <?php } ?>
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Styles-->
        <link href="<?php echo ECS_CSS_DIR . 'font-awesome.min.css?ver=' . ECS_VERSION; ?>" rel="stylesheet" />
        <link href="//fonts.googleapis.com/css?family=Open+Sans|Lato|Roboto|Roboto+Slab|Montserrat|Poppins|Oxygen|Roboto+Condensed|Ubuntu|Playfair+Display|Rubik|Titillium+Web:300,400,500,600,700,900|serif|Khand:300,400,500,700,900" rel="stylesheet">
        <link href="<?php echo ECS_CSS_DIR . 'TimeCircles.css?ver=' . ECS_VERSION; ?>" rel="stylesheet" />
        <?php if ( $template == 4 || $template == 7 ) { ?>
            <link href="<?php echo ECS_CSS_DIR . 'jquery.multiscroll.css?ver=' . ECS_VERSION; ?>" rel="stylesheet" id="multiscroll-css"/>
        <?php } ?>
        <link href="<?php echo ECS_CSS_DIR . 'TimeCircles-new.css?ver=' . ECS_VERSION; ?>" rel="stylesheet" />
        <link href="<?php echo ECS_CSS_DIR . 'animate.css?ver=' . ECS_VERSION; ?>" rel="stylesheet" />
        <link href="<?php echo ECS_CSS_DIR . 'ecs-frontend-style.css?ver=' . ECS_VERSION; ?>" rel="stylesheet" />
        <?php if ( !empty($general_settings[ 'favicon' ]) ) { ?>
            <link rel="shortcut icon" href="<?php echo esc_url($general_settings [ 'favicon' ]); ?>" type="images/x-icon" />
        <?php } ?>
        <!-- Styles-->
        <script>
            var ajax_url = '<?php echo admin_url('admin-ajax.php'); ?>';
            var ajax_nonce = '<?php echo wp_create_nonce('ecs_ajax_nonce'); ?>';
        </script>
        <!-- Scripts-->
        <script type="text/javascript" src="<?php echo ECS_JS_DIR . 'jquery-3.2.1.min.js?ver=' . ECS_VERSION; ?>"></script>
        <script type="text/javascript" src="<?php echo ECS_JS_DIR . 'jquery.easing.1.3.js?ver=' . ECS_VERSION; ?>"></script>
        <script type="text/javascript" src="<?php echo ECS_JS_DIR . 'jquery.multiscroll.js?ver=' . ECS_VERSION; ?>"></script>
        <script type="text/javascript" src="<?php echo ECS_JS_DIR . 'TimeCircles.js?ver=' . ECS_VERSION ?>"></script>
        <script type="text/javascript" src="<?php echo ECS_JS_DIR . 'jquery.downCount.js?ver=' . ECS_VERSION ?>"></script>
        <script type="text/javascript" src="<?php echo ECS_JS_DIR . 'jquery.scrollify.js?ver=' . ECS_VERSION ?>"></script>
        <script type="text/javascript" src="<?php echo ECS_JS_DIR . 'ecs-frontend-script.js?ver=' . ECS_VERSION; ?>"></script>
        <script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo ($component_settings[ 'google_map_api_key' ] != '') ? esc_attr($component_settings[ 'google_map_api_key' ]) : ''; ?>"></script>

        <!-- Scripts-->

        <?php if ( !empty($ecs_settings[ 'custom' ][ 'custom_css' ]) ) {
            ?>
            <style><?php echo $ecs_settings[ 'custom' ][ 'custom_css' ]; ?></style>
            <?php
        }
        ?>
        <!-- Custom CSS -->
        <!-- Custom CSS -->

        <?php
        /**
         * Google analytics code
         */
        if ( !empty($general_settings[ 'google_analytics' ]) ) {
            ?>
            <script>
    <?php echo $general_settings[ 'google_analytics' ]; ?>
            </script>
            <?php
        }
        /**
         * Action to append any other section in head
         *
         * @since 1.0.0
         */
        do_action('ecs_head', $ecs_settings);


        $template_class = 'ecs-template-' . $template;
        ?>

    </head>
    <body class="ecs-wrap <?php echo $template_class; ?> ">

        <?php
        include(ECS_PATH . '/inc/views/frontend/templates/template-' . $template . '.php');
        include(ECS_PATH . '/inc/views/frontend/dynamic-styles/style-template-' . $template . '.php');
        ?>
    </body>
</html>
