<div class="ecs-sub-settings-wrap" id="ecs-general-section">
    <div class="ecs-field-wrap">
        <label><?php _e('Maintenance Mode', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <input type="checkbox" name="settings[general][maintenance_mode]" value="1" class="ecs-settings-field" <?php echo (isset($ecs_settings[ 'general' ][ 'maintenance_mode' ])) ? 'checked="checked"' : ''; ?>/>
            <p class="description"><?php _e('Please check if you want to enable the maintenance mode', 'everest-coming-soon'); ?></p>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Site Title', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <input type="text" name="settings[general][site_title]" class="ecs-settings-field" value="<?php echo (isset($ecs_settings[ 'general' ][ 'site_title' ])) ? esc_attr($ecs_settings[ 'general' ][ 'site_title' ]) : ''; ?>"/>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Google Analytics', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <textarea name="settings[general][google_analytics]" class="ecs-settings-field"><?php echo (isset($ecs_settings[ 'general' ][ 'google_analytics' ])) ? esc_attr($ecs_settings[ 'general' ][ 'google_analytics' ]) : ''; ?></textarea>
            <p class="description"><?php _e('Please copy and paste the google analytics code in this area', 'everest-coming-soon'); ?></p>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Meta Tag Name', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <input type="text" name="settings[general][meta_tag_name]" class="ecs-settings-field" value="<?php echo (isset($ecs_settings[ 'general' ][ 'meta_tag_name' ])) ? esc_attr($ecs_settings[ 'general' ][ 'meta_tag_name' ]) : ''; ?>"/>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Meta Tag Content', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <textarea name="settings[general][meta_tag_content]" class="ecs-settings-field"><?php echo (isset($ecs_settings[ 'general' ][ 'meta_tag_content' ])) ? esc_attr($ecs_settings[ 'general' ][ 'meta_tag_content' ]) : ''; ?></textarea>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Favicon', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <input type="text" name="settings[general][favicon]" class="ecs-settings-field" value="<?php echo (isset($ecs_settings[ 'general' ][ 'favicon' ])) ? esc_attr($ecs_settings[ 'general' ][ 'favicon' ]) : ''; ?>"/>
            <input type="button" class="ecs-file-upload button-secondary" value="<?php _e('Upload', 'everest-coming-soon'); ?>" data-button-label='<?php _e('Insert Image', 'everest-coming-soon'); ?>' data-window-title='<?php _e('Choose Image', 'everest-coming-soon'); ?>'>
            <div class="ecs-image-preview"></div>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Hide from Search Engines', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <input type="checkbox" name="settings[general][hide_search]" value="1"  class="ecs-settings-field" <?php echo (isset($ecs_settings[ 'general' ][ 'hide_search' ])) ? 'checked="checked"' : ''; ?>/>
            <p class="description"><?php _e('Please check if you want to disable the crawling of the site from search engines', 'everest-coming-soon'); ?></p>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Disable Coming Soon Mode for', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <?php
            $disable_roles = isset($ecs_settings[ 'general' ][ 'disable_roles' ]) ? array_map('esc_attr', $ecs_settings[ 'general' ][ 'disable_roles' ]) : array();
            global $wp_roles;
            $wp_roles = new WP_Roles();
            $all_roles = $wp_roles->get_names();
            foreach ( $all_roles as $roles => $value ) {
                ?>
                <label class="ecs-block-label">
                    <input type="checkbox" name="settings[general][disable_roles][]" value="<?php echo $roles; ?>" class="ecs-settings-field" <?php echo (in_array($roles, $disable_roles)) ? 'checked="checked"' : ''; ?>/>
                    <?php echo $value; ?>
                </label>
            <?php } ?>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Email - From Name', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <input type="text" name="settings[general][email_from_name]" class="ecs-settings-field" value="<?php echo (isset($ecs_settings[ 'general' ][ 'email_from_name' ])) ? esc_attr($ecs_settings[ 'general' ][ 'email_from_name' ]) : ''; ?>"/>
            <p class="description"><?php _e('This detail will be used while sending the email such as contact email or subscriber confirmation email', 'everest-coming-soon'); ?></p>
        </div>
    </div>
    <div class="ecs-field-wrap">
        <label><?php _e('Email - From Email', 'everest-coming-soon'); ?></label>
        <div class="ecs-field">
            <input type="text" name="settings[general][email_from_email]" class="ecs-settings-field" value="<?php echo (isset($ecs_settings[ 'general' ][ 'email_from_email' ])) ? esc_attr($ecs_settings[ 'general' ][ 'email_from_email' ]) : ''; ?>"/>
            <p class="description"><?php _e('This detail will be used while sending the email such as contact email or subscriber confirmation email', 'everest-coming-soon'); ?></p>
        </div>
    </div>

</div>