<?php

defined('ABSPATH') or die('No script kiddies please!!');
if ( !class_exists('ECS_Admin') ) {

    class ECS_Admin extends ECS_Library {

        function __construct() {
            add_action('admin_menu', array( $this, 'backend_menu' ));
        }

        function backend_menu() {
            add_menu_page(__('Everest Coming Soon', 'everest-coming-soon'), __('Everest Coming Soon', 'everest-coming-soon'), 'manage_options', 'everest-coming-soon', array( $this, 'main_settings_page' ), 'dashicons-clock');
            add_submenu_page('everest-coming-soon', __('Settings', 'everest-coming-soon'), __('Settings', 'everest-coming-soon'), 'manage_options', 'everest-coming-soon', array( $this, 'main_settings_page' ));
            add_submenu_page('everest-coming-soon', __('Subscribers', 'everest-coming-soon'), __('Subscribers', 'everest-coming-soon'), 'manage_options', 'ecs-subscribers', array( $this, 'subscribers_list' ));
            add_submenu_page('everest-coming-soon', __('How to Use', 'everest-coming-soon'), __('How to Use', 'everest-coming-soon'), 'manage_options', 'ecs-how-to-use', array( $this, 'how_to_use' ));
            add_submenu_page('everest-coming-soon', __('About', 'everest-coming-soon'), __('About', 'everest-coming-soon'), 'manage_options', 'ecs-about', array( $this, 'about' ));
        }

        function main_settings_page() {
            include(ECS_PATH . 'inc/views/backend/main-settings.php');
        }

        function subscribers_list() {
            include(ECS_PATH . 'inc/views/backend/subscribers-list.php');
        }

        function how_to_use() {
            include(ECS_PATH . 'inc/views/backend/how-to-use.php');
        }

        function about() {
            include(ECS_PATH . 'inc/views/backend/about.php');
        }

    }

    new ECS_Admin();
}