<?php

defined('ABSPATH') or die('No script kiddies please!!');
/*
  Plugin Name: Everest Coming Soon
  Plugin URI: http://accesspressthemes.com/wordpress-plugins/everest-coming-soon
  Description: An ultimate site under construction management plugin
  Version: 	1.0.4
  Author:  	AccessPress Themes
  Author URI:  http://accesspressthemes.com
  Domain Path: /languages
  Text Domain: everest-coming-soon
 */

/**
 * Plugin Main Class
 *
 * @since 1.0.0
 */
if ( !class_exists('Everest_Coming_Soon') ) {

    class Everest_Coming_Soon {

        /**
         * Plugin Main initialization
         *
         * @since 1.0.0
         */
        function __construct() {
            $this->define_constants();
            $this->includes();
        }

        /**
         * Necessary Constants Define
         *
         * @since 1.0.0
         */
        function define_constants() {
            global $wpdb;
            defined('ECS_PATH') or define('ECS_PATH', plugin_dir_path(__FILE__));
            defined('ECS_URL') or define('ECS_URL', plugin_dir_url(__FILE__));
            defined('ECS_IMG_DIR') or define('ECS_IMG_DIR', plugin_dir_url(__FILE__) . 'img/');
            defined('ECS_CSS_DIR') or define('ECS_CSS_DIR', plugin_dir_url(__FILE__) . 'css/');
            defined('ECS_JS_DIR') or define('ECS_JS_DIR', plugin_dir_url(__FILE__) . 'js/');
            defined('ECS_VERSION') or define('ECS_VERSION', '1.0.4');
        }

        /**
         * Includes necessary constants
         *
         * @since 1.0.0
         */
        function includes() {
            include(ECS_PATH . 'inc/classes/class-ecs-library.php');
            include(ECS_PATH . 'inc/classes/class-ecs-activation.php');
            include(ECS_PATH . 'inc/classes/class-ecs-admin-ajax.php');
            include(ECS_PATH . 'inc/classes/class-ecs-ajax.php');
            include(ECS_PATH . 'inc/classes/class-ecs-admin.php');
            include(ECS_PATH . 'inc/classes/class-ecs-enqueue.php');
            include(ECS_PATH . 'inc/classes/class-ecs-admin-enqueue.php');
            include(ECS_PATH . 'inc/classes/class-ecs-hooks.php');
        }

    }

    new Everest_Coming_Soon();
}
