<?php
defined( 'ABSPATH' ) or die( "No script kiddies please!" );
/*
Plugin name: AccessPress Instagram Feed Pro
Plugin URI: https://accesspressthemes.com/wordpress-plugins/accesspress-instagram-feed/
Description: A plugin to add various instagram feeds to posts and pages with dynamic configuration options.
Version: 2.1.5
Author: AccessPress Themes
Author URI: http://accesspressthemes.com
Text Domain: accesspress-instagram-feed-pro
Domain Path: /languages/
License: GPLv2 or later
*/
//Decleration of the necessary constants for plugin
if( !defined( 'APIF_VERSION' ) )
{
    define( 'APIF_VERSION', '2.1.5' );
}

if( !defined( 'APIF_IMAGE_DIR' ) )
{
    define( 'APIF_IMAGE_DIR', plugin_dir_url( __FILE__ ) . 'images' );
}

if( !defined( 'APIF_JS_DIR' ) )
{
    define( 'APIF_JS_DIR', plugin_dir_url( __FILE__ ) . 'js' );
}

if( !defined( 'APIF_CSS_DIR' ) )
{
    define( 'APIF_CSS_DIR', plugin_dir_url( __FILE__ ) . 'css' );
}

if( !defined( 'APIF_INST_PATH' ) )
{
    define( 'APIF_INST_PATH', plugin_dir_path( __FILE__ ) );
}

if( !defined( 'APIF_LANG_DIR' ) )
{
    define( 'APIF_LANG_DIR', basename( dirname( __FILE__ ) ) . '/languages/' );
}

if( !defined( 'APIF_TEXT_DOMAIN' ) )
{
    define( 'APIF_TEXT_DOMAIN', 'accesspress-instagram-feed-pro' );
}
//Include admin


/**
 * Register of widgets
 *
 */
include_once( 'inc/backend/widgetside.php' );
include_once( 'inc/backend/widget_integration.php');

if( !class_exists( 'IF_Pro_Class' ) )
{
    
    class IF_Pro_Class
    {
        
        var $apif_settings;
        /**
         * Initializes the plugin functions
         */
        function __construct()
        {
            $this->apif_settings = get_option( 'apif_settings' );
            register_activation_hook( __FILE__, array($this, 'load_default_settings') );
            //plugin's table creation
            register_activation_hook( __FILE__, array($this, 'my_plugin_create_db') );
            //loads default settings for the plugin while activating the plugin
            add_action( 'init', array($this, 'plugin_text_domain') );
            //loads text domain for translation ready
            add_action( 'init', array($this, 'session_init') );
            //starts the session
            add_action( 'admin_menu', array($this, 'add_if_menu') );
            //adds plugin menu in wp-admin
            add_action( 'admin_enqueue_scripts', array($this, 'register_admin_assets') );
            //registers admin assests such as js and css
            add_action( 'wp_enqueue_scripts', array($this, 'register_frontend_assets') );
            //registers js and css for frontend
            add_action( 'admin_post_apif_settings_action', array($this, 'apif_settings_action') );
            //recieves the posted values from settings form
            add_action( 'admin_post_apif_new_feed', array($this, 'apif_add_feed') );
            //recieves the posted values from settings form
            add_action( 'admin_post_apif_edit_feed', array($this, 'apif_edit_feed') );
            //recieves the posted values from settings form
            add_action( 'admin_post_apif_copy_action', array($this, 'apif_copy_action') );
            //recieves the posted values from settings form
            add_action( 'admin_post_apif_delete_action', array($this, 'apif_delete_action') );
            //recieves the posted values from settings form
            add_action( 'admin_post_apif_instagram_settings_action', array($this, 'apif_instagram_settings_action') );

            add_action( 'admin_post_apif_delete_cache', array($this, 'apif_delete_cache'));
            //recieves the posted values from settings form
            // add_action( 'admin_post_apif_restore_default', array($this, 'apif_restore_default') );
            //restores default settings;
            add_shortcode( 'ap_instagram_feed_pro', array($this, 'ap_instagram_feed_pro') );
            add_action( 'widgets_init', array($this, 'register_apif_widget') );
            //registers the widget
            
            // ajax call for load more function
            add_action( 'wp_ajax_load_more', array($this, 'load_more') );
            add_action( 'wp_ajax_nopriv_load_more', array($this, 'load_more') );
            // add_action( 'wp_footer', array($this, 'photoswipe_div'), 100 );
            add_action( 'wp_footer', array( $this, 'accesspress_popup') );
            
        }



        /**
         * [apif_delete_cache description]
         * @return [type] [description]
         */
        function apif_delete_cache(){
            if (!empty($_GET) && wp_verify_nonce($_GET['_wpnonce'], 'apif-delete-cache-nonce')) {
                delete_transient('any_user_feed_transient');
                delete_transient('tag_feed_transient');
                delete_transient('likes_feed_transient');
                delete_transient('recent_feed_transient');

                $_SESSION['apif_message'] = __('Cache cleared Successfully','accesspress-instagram-feed-pro');
                wp_redirect(admin_url().'admin.php?page=apif-settings');
            }
        }

        /**
         * Load Default Settings
         *
         */
        function load_default_settings(){
            if( !get_option( 'apif_settings' ) )
            {
                include( 'inc/backend/activation.php' );
            }
        }

        function my_plugin_create_db() {
            global $wpdb;
            $charset_collate = $wpdb->get_charset_collate();
            $table_name = $wpdb->prefix . 'instagram_feeds';

            $sql = "CREATE TABLE $table_name (
                        id int(11) NOT NULL AUTO_INCREMENT,
                        feed_settings varchar(16000) NOT NULL,
                        PRIMARY KEY  (id)
                        ) $charset_collate;";

            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
            dbDelta( $sql );
        }

        /**
         * Plugin Translation
         */
        function plugin_text_domain(){
            load_plugin_textdomain( 'accesspress-instagram-feed-pro', false, basename( dirname( __FILE__ ) ) . '/languages/' );
        }

        /**
         * Starts the session
         */
        function session_init() 
        {
            if( !session_id() && !headers_sent())
            {
                session_start();
            }
        }

        /**
         * Plugin Admin Menu
         */
        function add_if_menu() 
        {
            add_menu_page( __( 'AP Instagram Feed Pro', 'accesspress-instagram-feed-pro' ), __( 'AP Instagram Feed Pro', 'accesspress-instagram-feed-pro' ), 'manage_options', 'ap-instagram-feed-pro', array($this, 'main_page'), APIF_IMAGE_DIR . '/sc-icon.png' );
            add_submenu_page( 'ap-instagram-feed-pro', __( 'Instagram Feeds', 'accesspress-instagram-feed-pro' ), __( 'Instagram Feeds', 'accesspress-instagram-feed-pro' ), 'manage_options', 'ap-instagram-feed-pro', array($this, 'main_page') );
            add_submenu_page( 'ap-instagram-feed-pro', __( 'Add New Feed', 'accesspress-instagram-feed-pro' ), __( 'Add New Feed', 'accesspress-instagram-feed-pro' ), 'manage_options', 'apif-add-feed', array($this, 'add_new_feed') );
            add_submenu_page( 'ap-instagram-feed-pro', __( 'Instagram Settings', 'accesspress-instagram-feed-pro' ), __( 'Instagram Settings', 'accesspress-instagram-feed-pro' ), 'manage_options', 'apif-settings', array($this, 'apif_settings') );
            add_submenu_page( 'ap-instagram-feed-pro', __( 'How to use', 'accesspress-instagram-feed-pro' ), __( 'How to use', 'accesspress-instagram-feed-pro' ), 'manage_options', 'apif-how-to-use', array($this, 'how_to_use') );
            add_submenu_page( 'ap-instagram-feed-pro', __( 'About', 'accesspress-instagram-feed-pro' ), __( 'About', 'accesspress-instagram-feed-pro' ), 'manage_options', 'apif-about', array($this, 'about') );
        }

        /**
         * Registering of backend js and css
         */
        function register_admin_assets() 
        {
            if( isset( $_GET['page'] ) &&( $_GET['page'] == 'ap-instagram-feed-pro' || $_GET['page'] == 'apif-add-feed' || $_GET['page'] == 'apif-settings' || $_GET['page'] == 'apif-how-to-use' || $_GET['page'] == 'apif-about' ) )
            {
                wp_enqueue_style( 'sc-admin-css', APIF_CSS_DIR . '/backend.css', array(), APIF_VERSION );
                
                // Add the color picker css file
                wp_enqueue_style( 'wp-color-picker' );
                
                wp_enqueue_script( 'alpha-color-picker', APIF_JS_DIR . '/alpha-color-picker/alpha-color-picker.js',
                // Update to where you put the file.
                array('jquery', 'wp-color-picker'),
                // You must include these here.
                null, true );
                
                wp_enqueue_style( 'alpha-color-picker', APIF_CSS_DIR . '/alpha-color-picker/alpha-color-picker.css',
                // Update to where you put the file.
                array('wp-color-picker')
                // You must include these here.
                 );
                
                wp_enqueue_script( 'sc-admin-js', APIF_JS_DIR . '/backend.js', array('jquery', 'jquery-ui-sortable', 'wp-color-picker', 'alpha-color-picker'), APIF_VERSION );
            }
        }

        /**
         * Registers Frontend Assets
         *
         */
        function register_frontend_assets()
        {
            wp_register_style( 'lightbox', APIF_CSS_DIR . '/lightbox.css', array(), APIF_VERSION );

            wp_register_style( 'owl-theme', APIF_CSS_DIR . '/owl.theme.css', array(), APIF_VERSION );
            wp_register_style( 'owl-carousel', APIF_CSS_DIR . '/owl.carousel.css', array(), APIF_VERSION );

            wp_register_style( 'apif-gridrotator', APIF_CSS_DIR . '/gridrotator.css', array(), APIF_VERSION );
            
            // for swipebox css
            wp_register_style( 'swipebox-core-style', APIF_CSS_DIR . '/swipebox/swipebox.min.css', array(), APIF_VERSION );
            // for swipebox css ends
            
            // for prettyphoto
            wp_register_style( 'apif-prettyphoto-lightbox', APIF_CSS_DIR . '/prettyphoto/prettyPhoto.css', array(), APIF_VERSION );
            // for prettyphoto ends
            
            //for litbx css
            wp_register_style( 'apif-litbx-lightbox', APIF_CSS_DIR . '/litbx/litbx.core.min.css', array(), APIF_VERSION );
            //for litbx css ends
            
            // for venobox.css
            wp_register_style( 'apif-venobox-lightbox', APIF_CSS_DIR . '/venobox/venobox.css', array(), APIF_VERSION );
            // for venobox.css ends
            
            // for bx slider
            wp_register_style( 'apif-bx-slider', APIF_CSS_DIR . '/bxslider/jquery.bxslider.css', array(), APIF_VERSION );
            // for bx slider
            
            // for thumbnail-scroller-master
            wp_register_style( 'apif-thumbnail-scroller-master', APIF_CSS_DIR . '/thumbnail-scroller-master/jquery.mThumbnailScroller.css', array(), APIF_VERSION );
            // for thumbnail-scroller-master ends
            
            // for nivo slider
            wp_register_style( 'apif-nivo-slider', APIF_CSS_DIR . '/nivo-slider/nivo-slider.css', array(), APIF_VERSION );
            wp_register_style( 'apif-nivo-slider-default-theme', APIF_CSS_DIR . '/nivo-slider/themes/default/default.css', array(), APIF_VERSION );
            wp_register_style( 'apif-nivo-slider-bar-theme', APIF_CSS_DIR . '/nivo-slider/themes/bar/bar.css', array(), APIF_VERSION );
            wp_register_style( 'apif-nivo-slider-dark-theme', APIF_CSS_DIR . '/nivo-slider/themes/dark/dark.css', array(), APIF_VERSION );
            wp_register_style( 'apif-nivo-slider-light-theme', APIF_CSS_DIR . '/nivo-slider/themes/light/light.css', array(), APIF_VERSION );
            // for nivo slider ends
            
            // for pgwslider
            wp_register_style( 'apif-pgw-slider', APIF_CSS_DIR . '/pgwslider/pgwslider.min.css', array(), APIF_VERSION );
            // for pgwslider ends
            
            // for sliderpro
            wp_register_style( 'apif-sliderpro', APIF_CSS_DIR . '/sliderpro/slider-pro.min.css', array(), APIF_VERSION );
            // for sliderpro ends
            
            wp_register_style( 'animate-style', APIF_CSS_DIR . '/animate.css', array(), APIF_VERSION );
            
            wp_enqueue_style( 'apsc-font-awesome', APIF_CSS_DIR . '/font-awesome.min.css', array(), APIF_VERSION );
            wp_enqueue_style( 'apif-frontend-css', APIF_CSS_DIR . '/frontend.css', array(), APIF_VERSION );
            
            wp_register_script( 'lightbox-js', APIF_JS_DIR . '/lightbox.js', array('jquery'), '2.8.1', true );
            wp_register_script( 'apif-isotope-pkgd-min-js', APIF_JS_DIR . '/isotope.pkgd.min.js', array('jquery'), '2.2.0', true );
            wp_register_script( 'apif-imagesloaded-min-js', APIF_JS_DIR . '/imagesloaded.min.js', array('jquery'), '3.1.8', true );

            wp_register_script( 'owl-carousel-js', APIF_JS_DIR . '/owl.carousel.js', array('jquery') );
            // wp_enqueue_script( 'moment', APIF_JS_DIR . '/moment.js', array('jquery') );
            // wp_enqueue_script( 'livestamp', APIF_JS_DIR . '/livestamp.js', array('jquery', 'moment') );
            wp_register_script( 'apif-modernizr-custom', APIF_JS_DIR . '/modernizr.custom.26633.js', '', '1.0' );
            wp_register_script( 'apif-gridrotator', APIF_JS_DIR . '/jquery.gridrotator.js', array('jquery', 'apif-modernizr-custom'), '1.0' );
            

             // for jcarousel
            wp_register_script( 'apif-jcarousel-core', APIF_JS_DIR . '/jcarousel/jquery.jcarousel-core.js', array('jquery'), APIF_VERSION );
            wp_register_script( 'apif-jcarousel-skeleton', APIF_JS_DIR . '/jcarousel/jcarousel-skeleton.js', array('jquery', 'apif-jcarousel-core'), APIF_VERSION );
            wp_register_script( 'apif-jcarousel-control', APIF_JS_DIR . '/jcarousel/jquery.jcarousel-control.js', array('jquery', 'apif-jcarousel-core'), '1.0' );
            wp_register_script( 'apif-jcarousel-autoscroll', APIF_JS_DIR . '/jcarousel/jquery.jcarousel-autoscroll.js', array('jquery', 'apif-jcarousel-core'), '1.0' );
            // for jcarousel ends
            
            // for swipebox js
            wp_register_script( 'apif-swipebox-core-js', APIF_JS_DIR . '/swipebox/jquery.swipebox.min.js', array('jquery'), APIF_VERSION );
            // for swipebox js ends
            
            // for prettyphoto
            wp_register_script( 'apif-prettyphoto-lightbox-core-js', APIF_JS_DIR . '/prettyphoto/jquery.prettyPhoto.js', array('jquery'), APIF_VERSION );
            // for prettyphoto ends
            
            // for litbx
            wp_register_script( 'apif-litbx-core', APIF_JS_DIR . '/litbx/litbx.min.js', array('jquery'), APIF_VERSION );
            // for litbx ends
            
            // for venobox
            wp_register_script( 'apif-venobox-core', APIF_JS_DIR . '/venobox/venobox.min.js', array('jquery'), APIF_VERSION );
            // for venobox ends
            
            // for bx slider
            wp_register_script( 'apif-bxslider-core', APIF_JS_DIR . '/bxslider/jquery.bxslider.min.js', array('jquery'), APIF_VERSION );
            // for bx slider ends
            
            // for nivo slider
            wp_register_script( 'apif-nivoslider-core', APIF_JS_DIR . '/nivo-slider/jquery.nivo.slider.js', array('jquery'), APIF_VERSION );
            // for nivo slider ends
            
            // for pgw slider
            wp_register_script( 'apif-pgwslider-core', APIF_JS_DIR . '/pgwslider/pgwslider.min.js', array('jquery'), APIF_VERSION );
            // for pgw slider ends
            
            // for sliderpro
            wp_register_script( 'apif-sliderpro-core', APIF_JS_DIR . '/sliderpro/jquery.sliderPro.min.js', array('jquery'), APIF_VERSION );
            // for sliderpro ends
            
           
            
            // for thumbnail-scroller-master
            wp_register_script( 'apif-thumbnail-scroller-master-core', APIF_JS_DIR . '/thumbnail-scroller-master/jquery.mThumbnailScroller.js', array('jquery'), APIF_VERSION );
            // for thumbnail-scroller-master ends
            
            wp_register_script( 'wow-animation', APIF_JS_DIR . '/wow.js', array('jquery'), '1.0' );
            
            // mesonry js
            // wp_enqueue_script( 'jquery-masonry' );
            // wp_enqueue_script('jquery-isotope', 'https://unpkg.com/isotope-layout@3/dist/isotope.pkgd.min.js', 'jquery', APIF_VERSION );
            // masonry ends

            wp_register_script( 'apif-frontend-js', APIF_JS_DIR . '/frontend.js', array( 'jquery' ), APIF_VERSION );
            
            //for the frontend ajax call for load more option
            $ajax_nonce = wp_create_nonce( 'apif-ajax-nonce' );
            $apif_settings = get_option( 'apif_settings' );
            $link_enable = isset($apif_settings['enable_links']) ? $apif_settings['enable_links'] : '';
            wp_localize_script( 'apif-frontend-js', 'frontend_ajax_object', array('ajax_url' => admin_url() . 'admin-ajax.php', 'ajax_nonce' => $ajax_nonce, 'enable_links_in_username_and_tags' =>$link_enable) );
        }

        /**
         * Saves settings to database
         */
        function apif_settings_action() 
        {
            if( !empty( $_POST ) && wp_verify_nonce( $_POST['apif_settings_nonce'], 'apif_settings_action' ) )
            {
                include( 'inc/backend/save-settings.php' );
            }
        }

        /*
         * Save the new instagram feeds settings to wordpress table
        */
        function apif_add_feed() 
        {
            if( !empty( $_POST ) && wp_verify_nonce( $_POST['apif_add_feed_nonce'], 'apif_add_feed_action' ) )
            {
                include( 'inc/backend/save-new-feed.php' );
            }
        }

        /*
         * Save the edits for the feeds
        */
        function apif_edit_feed() 
        {
            
            if( !empty( $_POST['if_id'] ) && wp_verify_nonce( $_POST['apif_edit_feed_nonce'], 'apif_edit_feed_action' ) )
            {
                include( 'inc/backend/save-edit-feed.php' );
            }
        }

        /*
         *  Copy the settings of a given id
         *
        */
        function apif_copy_action() 
        {
            if( isset( $_GET['action'], $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], 'apif-copy-nonce' ) )
            {
                include_once( 'inc/backend/copy-feed-settings.php' );
            } 
            else
            {
                die( 'No script kiddies please!' );
            }
        }
        /*
         * Delete the settigs of a given id
        */
        function apif_delete_action() 
        {
            if( isset( $_GET['action'], $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], 'apif-delete-nonce' ) )
            {
                include_once( 'inc/backend/delete-feed-settings.php' );
            } 
            else
            {
                die( 'No script kiddies please!' );
            }
        }

        /*
         * Save the instagram settings
        */
        function apif_instagram_settings_action() 
        {
            if( !empty( $_POST ) && wp_verify_nonce( $_POST['apif_instagram_settings_nonce'], 'apif_instagram_settings_action' ) )
            {
                include( 'inc/backend/save-instagram-settings.php' );
            }
        }

        /**
         * AccessPress Instagram Feed Widget
         */
        function register_apif_widget() 
        {
            // register_widget( 'APIF_Widget' );
            register_widget( 'APIF_Pro_SideWidget' );
            register_widget ( 'APIF_Widget_Instagram_Feeds' );
        }

        /**
         * loads the more images from instagram
         */
        function load_more() 
        {
            if( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'apif-ajax-nonce' ) )
            {
                include( 'inc/frontend/feed-ajax.php' );
                wp_die();
            }
        }

        function accesspress_popup(){
            include('inc/frontend/accesspress_popup.php');
        }

        //plugin's backend admin page
        function main_page() 
        {
            include( 'inc/backend/main-page-new.php' );
        }

        // function to add new instagram feeds
        function add_new_feed() 
        {
            include( 'inc/backend/boards/add_new_feed.php' );
        }

        //function to add/edit the instagram settings
        function apif_settings() 
        {
            include( 'inc/backend/boards/instagram-settings.php' );
        }

        //function to show how to use section
        function how_to_use() 
        {
            include( 'inc/backend/boards/how-to-use-new.php' );
        }
        //function to about section
        function about() 
        {
            include( 'inc/backend/boards/about-new.php' );
        }


        /**
         * Returns Default Settings
         */
        function get_default_settings() 
        {
            $apif_settings = array('username' => '', 'access_token' => '', 'user_id' => '', 'instagram_mosaic' => 'mosaic');
            return $apif_settings;
        }

        // instagram feed shortcode
        function ap_instagram_feed_pro( $attr )
        {
            ob_start();
            include( 'inc/frontend/instagram-feed-pro.php' );
            $html = ob_get_contents();
            ob_get_clean();
            return $html;
        }

        /**
         *
         * @param int $count
         * @param string $format
         */
        static function get_formatted_count( $count, $format )
        {
            switch( $format )
            {
            case '2':
                $count = number_format( $count );
                break;

            case '3':
                $count = self::abreviateTotalCount( $count );
                break;

            default:
                break;
            }
            return $count;
        }
        
        /**
         *
         * @param integer $value
         * @return string
         */
        static function abreviateTotalCount( $value )
        {
            if($value == 0){
                return $value;
            }else{
                $abbreviations = array(12 => 'T', 9 => 'B', 6 => 'M', 3 => 'K', 0 => '');
                foreach ($abbreviations as $exponent => $abbreviation) {
                    if ($value >= pow(10, $exponent)) {
                        return round(floatval($value / pow(10, $exponent)), 1) . $abbreviation;
                    }
                }
            }
        }

        /**
         *
         * @param integer $value
         * @return string
         * Since 1.0.2
         */

        static function return_string_80_char($string){
            if(strlen($string) <= 120 ){
                return $string;
            }else if( strlen($string) >= 120 ){
                $string = strip_tags($string);
                return substr($string, 0, 80).'...';
            }
        }

        function SortByLikesOrder($a, $b) {
            return $b['likes_count'] - $a['likes_count'];
        }

        function SortByCommentOrder($a, $b) {
            return $b['comment_count'] - $a['comment_count'];
        }

        function SortByDateOrder($a, $b) {
            return $b['created_time'] - $a['created_time'];
        }

        function apif_contains_keywords($str, array $arr)
        {
            foreach($arr as $a) {
                if (stripos($str,$a) !== false) return true;
            }
            return false;
        }

        function apif_doesnt_contains_keywords($str, array $arr)
        {
            foreach($arr as $a) {
                if (stripos($str,$a) !== true) return true;
            }
            return false;
        }

        public static function contains($str, array $arr){
            foreach($arr as $a) {
                if (stripos($str,$a) !== false) return true;
            }
            return false;
        }

    }
$sc_object = new IF_Pro_Class();
//initialization of plugin
    
    
}

?>