<?php 
/* 
Template Name: Template - Home Width Sidebar
*/ 
?>
<?php get_header(); // add header  ?>


<!-- Begin Wrap Content -->
<div class="wrap-fullwidth">
 
    <!-- Begin Main Home Content -->
    <div class="wrap-content">
        <?php if (have_posts()) : while (have_posts()) : the_post(); 
            $thecontent = get_the_content();
            if(!empty($thecontent)) { ?>        
                <div class="home-content"><?php the_content(''); // content ?></div>
            <?php } ?>
        <?php endwhile; endif; ?>    

        <!-- Home Modules (Widgets) -->
        <?php if ( is_active_sidebar( 'homemodules_viralvideo_wp' ) ) { ?>
            <?php dynamic_sidebar( 'homemodules_viralvideo_wp' ); ?>
        <?php } ?> 
        <!-- End. Home Modules --> 

        <h3 class="title-home"><?php esc_html_e( 'Recent Content', 'viralvideo-wp' ); ?></h3>
        <ul class="grid_list">

        <?php
            if ( get_query_var('paged') )  {  $paged = get_query_var('paged'); } elseif ( get_query_var('page') ) { $paged = get_query_var('page'); } else { $paged = 1;  }
            // The Query
            query_posts( array( 'post_type' => 'post', 'paged' => $paged ) );
            if (have_posts()) : while (have_posts()) : the_post();
        ?>

            <li <?php post_class('') ?> id="post-<?php the_ID(); ?>">
                <?php if ( has_post_thumbnail()) { ?>        
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('viralvideo_wp_thumbnail-blog-grid', array('title' => "")); ?></a>
                    <div class="avatar-grid"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 30 ); ?></a></div><div class="clear"></div>
                <div class="content-grid">
                <?php } else { ?>
                    <div class="noimg"></div>
                    <div class="avatar-grid"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 30 ); ?></a></div><div class="clear"></div>
                <div class="content-grid">
                <?php } // Post Thumbnail ?> 
                    <a href="<?php the_permalink(); ?>"><h2><?php viralvideo_wp_the_title( 55, ' ..'); ?></h2></a>
                    <div class="clear"></div>
                    <span class="anpostdate"><?php esc_html_e('Posted on', 'viralvideo-wp'); ?> <?php the_time('M j, Y'); ?></span>
                    <?php if ( function_exists( 'getPostViews_viralvideo_wp' ) ) { ?> <span class="anviews"><i class="icofont icofont-fire-burn" title="<?php esc_html_e( 'Views!', 'viralvideo-wp' ); ?>"></i> <?php echo getPostViews_viralvideo_wp(get_the_ID()); ?></span><?php } ?>             
                    <?php if (get_comments_number()==0) { } else { ?><span class="comm"><i class="fa fa-commenting" aria-hidden="true"></i> <?php comments_popup_link('0', '1', '%'); ?></span><?php } ?>
                </div><!-- end .content-grid -->
            </li>

        <?php endwhile; ?>
        </ul>  

        <!-- Pagination -->
        <?php if(function_exists('wp_pagenavi')) { ?>
            <?php wp_pagenavi(); ?>
            <?php } else { ?>
            <div class="clear"></div>
            <div class="defaultpag">
                    <div class="sright"><?php next_posts_link('' . esc_html__('Older Entries', 'viralvideo-wp') . ' &rsaquo;'); ?></div>
                    <div class="sleft"><?php previous_posts_link('&lsaquo; ' . esc_html__('Newer Entries', 'viralvideo-wp') . ''); ?></div>
            </div><!-- end .defaultpag -->
        <?php } // Default Pagination ?>
        <!-- pagination -->

        <?php endif; ?>
    </div><!-- end .wrap-content -->


    <!-- Begin Sidebar (default right) -->
    <?php get_sidebar(); // add sidebar ?>
    <!-- end #sidebar (default right) --> 

        
<div class="clear"></div>
</div><!-- end .wrap-fullwidth -->

<?php get_footer(); // add footer  ?>