<?php get_header(); // add header ?>  
<?php
    // Display related articles / AD (Yes/No)
    $viralvideo_wp_display_add_relatedarticles = get_theme_mod('viralvideo_wp_display_add_relatedarticles');
    if (empty($viralvideo_wp_display_add_relatedarticles)) { $viralvideo_wp_display_add_relatedarticles = 'No'; }
    $viralvideo_wp_related_add300 = get_theme_mod('viralvideo_wp_related_add300'); 

    // Hide Featured Image (Yes/No)
    $viralvideo_wp_hidefimg = get_theme_mod('viralvideo_wp_hidefimg');
    if (empty($viralvideo_wp_hidefimg)) { $viralvideo_wp_hidefimg = 'No'; }
?>

<!-- Begin Content -->
<div class="wrap-fullwidth">

    <div class="single-content">
        <?php if (have_posts()) : while (have_posts()) : the_post();  ?>
        <div class="entry-top">
            <h1 class="article-title entry-title"><?php the_title(); ?></h1>
            <ul class="meta-entry-top">
                <li><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 25 ); ?></a>
                <li class="vcard author"><span class="fn"><?php the_author_posts_link(); ?></span> <?php esc_html_e('on', 'viralvideo-wp'); ?> <span class="updated"><?php the_time('F j, Y'); ?></span></li>
                <li><?php if ( function_exists( 'viralvideo_wp_social_share_single' ) ) { viralvideo_wp_social_share_single(); } ?> </li>
            </ul><div class="clear"></div>
        </div><!-- end .entry-top -->
        <?php endwhile; endif; ?>


        <article>
            <?php if (have_posts()) : while (have_posts()) : the_post();  ?>
            <?php if ( function_exists( 'getPostViews_viralvideo_wp' ) ) { setPostViews_viralvideo_wp(get_the_ID()); } ?>
            <div <?php post_class('post') ?> id="post-<?php the_ID(); ?>">

            <div class="media-single-content">
            <?php if ( function_exists( 'rwmb_meta' ) ) {  
            // If Meta Box plugin is activate ?>
                <?php
                $viralvideo_wp_hideimg_id = rwmb_meta('viralvideo_wp_hideimg', true );
                ?> 

                <?php if ($viralvideo_wp_hidefimg == 'Yes') { } else {
                        if(!empty($viralvideo_wp_hideimg_id)) { } else { ?>
                            <?php the_post_thumbnail('viralvideo_wp_thumbnail-single-image'); ?>
                        <?php } // disable featured image for one post ?>
                <?php } // for all posts ?>

            <?php } else { 
            // Meta Box Plugin 
                if ($viralvideo_wp_hidefimg == 'Yes') { } else {
                    the_post_thumbnail('viralvideo_wp_thumbnail-single-image'); 
                }
             } ?> 
            </div><!-- end .media-single-content -->

                    <div class="entry">
                        <!-- excerpt -->
                        <?php if ( !empty( $post->post_excerpt ) ) { ?> <?php echo the_excerpt(); ?><?php } ?>                         
                        <?php the_content(''); // content ?>
                        <?php wp_link_pages(); // content pagination ?>
                        <div class="clear"></div>

                        <div class="tags-cats">
                            <!-- views -->
                            <?php if ( function_exists( 'getPostViews_viralvideo_wp' ) ) { ?>
                                <div class="ct-size"><div class="entry-btn"><?php esc_html_e( 'Views:', 'viralvideo-wp' ); ?></div> <?php echo getPostViews_viralvideo_wp(get_the_ID()); ?></div><div class="clear"></div>
                            <?php } ?>

                            <!-- tags -->
                            <?php $viralvideo_wp_single_tags = get_the_tags(); 
                            if ($viralvideo_wp_single_tags): ?>
                                <div class="ct-size"><div class="entry-btn"><?php esc_html_e( 'Article Tags:', 'viralvideo-wp' ); ?></div> <?php the_tags('',' &middot; '); // tags ?></div><div class="clear"></div>
                            <?php endif; ?>

                            <!-- categories -->
                            <?php $viralvideo_wp_single_categories = get_the_category(); 
                            if ($viralvideo_wp_single_categories): ?>
                                <div class="ct-size"><div class="entry-btn"><?php esc_html_e( 'Article Categories:', 'viralvideo-wp' ); ?></div> <?php the_category(' &middot; '); // categories ?></div><div class="clear"></div>
                            <?php endif; ?>
                        </div><!-- end .tags-cats -->

                        <div class="clear"></div>                        
                    </div><!-- end .entry -->
                    <div class="clear"></div> 
            </div><!-- end #post -->
            <?php endwhile; endif; ?>
        </article><!-- end article -->


        <?php if ($viralvideo_wp_display_add_relatedarticles == 'Yes') { ?>
        <!-- Related Articles -->
        <div class="single-related">
        <div class="single-related-wrap">
            <div class="one_half_sr">
                <?php echo stripslashes($viralvideo_wp_related_add300); ?>
            </div>

            <div class="one_half_last_sr">
                <h3><?php esc_html_e( 'Related Articles', 'viralvideo-wp' ); ?></h3>
                <ul class="article_list">
                    <?php $viralvideo_wp_related = get_posts( array( 'category__in' => wp_get_post_categories($post->ID), 'ignore_sticky_posts' => 1, 'numberposts' => esc_attr(4), 'post__not_in' => array($post->ID) ) );
                    $num=1; if( $viralvideo_wp_related ) foreach( $viralvideo_wp_related as $post ) { setup_postdata($post); ?>  
                      <li>
                          <?php if ( has_post_thumbnail()) { ?>
                          <div class="post-nr"><?php echo esc_html($num++); ?></div>
                          <?php } ?>    
                          <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('viralvideo_wp_thumbnail-widget-small'); ?></a>
                          <div class="an-widget-title" <?php if ( has_post_thumbnail()) { ?> style="margin-left:135px;" <?php } ?>>
                            <a href="<?php the_permalink(); ?>"><h4 class="article-title"><?php the_title(); ?></h4></a>              
                            <div class="authorname"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 18 ); ?></a> </div>
                            <?php if ( function_exists( 'getPostViews_viralvideo_wp' ) ) { ?> <span class="anviews"><i class="icofont icofont-fire-burn" title="<?php esc_html_e( 'Views!', 'viralvideo-wp' ); ?>"></i> <?php echo getPostViews_viralvideo_wp(get_the_ID()); ?></span><?php } ?> 
                            <?php if (get_comments_number()==0) { } else { ?><span class="comm"><i class="fa fa-commenting" aria-hidden="true"></i> <?php comments_popup_link('0', '1', '%'); ?></span><?php } ?>
                          </div>
                      </li>
                  <?php } wp_reset_postdata(); ?>
                </ul>
            </div><div class="clear"></div>
        </div><!-- end .single-related-wrap -->
        </div><!-- end .single.related -->
        <?php } ?>

 
        <!-- Comments -->
        <div class="entry-bottom">
            <?php if ( ! post_password_required() ) { ?>
                <?php if (get_comments_number()==0) { } else { ?>
                    <h3 class="title"> <?php esc_html_e( 'Comments', 'viralvideo-wp' ); ?></h3>
                <?php } ?>
            <?php } ?>            
            
            <!-- Comments -->
            <div id="comments" class="comments">
                <?php comments_template('', true); // comments ?>
            </div>
            <div class="clear"></div>
        </div><!-- end .entry-bottom -->

    </div><!-- end .single-content -->


    <!-- Begin Sidebar (right) -->
    <?php  get_sidebar(); // add sidebar ?>
    <!-- end #sidebar  (right) -->    


    <div class="clear"></div>
</div><!-- end .wrap-fullwidth  -->
<?php get_footer(); // add footer  ?>