<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>
<head>
<?php
    // Logo
    $viralvideo_wp_logo = get_theme_mod('viralvideo_wp_logo');
    if (empty($viralvideo_wp_logo)) { $viralvideo_wp_logo = get_template_directory_uri().'/images/logo.png'; }

    // Social icons
    $viralvideo_wp_top_social_icons = get_theme_mod('viralvideo_wp_top_social_icons');       
    $viralvideo_wp_topicons_display = get_theme_mod('viralvideo_wp_topicons_display');
    if (empty($viralvideo_wp_topicons_display)) { $viralvideo_wp_topicons_display = 'No'; } 

    // Most viewed Articles
    $viralvideo_wp_display_tvp = get_theme_mod('viralvideo_wp_display_tvp');
    if (empty($viralvideo_wp_display_tvp)) { $viralvideo_wp_display_tvp = 'No'; }   
?>
    <!-- Meta Tags -->
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

    <!-- Mobile Device Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1"> 

    <!-- Theme output -->
    <?php wp_head(); ?> 

</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>


<!-- Begin Header -->
<header>
        <!-- Top bar colors -->
        <div class="main-header">
            <!-- Logo -->  
            <a href="<?php echo esc_url(home_url( '/' )); ?>"><img class="logo" src="<?php echo esc_url($viralvideo_wp_logo); ?>" alt="<?php esc_attr(bloginfo('sitename')); ?>" /></a>

            <!-- search form get_search_form(); -->
            <?php get_search_form(); ?>

            <!-- Navigation Menu -->
            <?php if ( has_nav_menu( 'viralvideo_wp_primary-menu' ) ) : // Check if there's a menu assigned to the 'Header Navigation' location. ?>
                <nav id="myjquerymenu" class="jquerycssmenu">
                    <?php wp_nav_menu( array( 'container' => false, 'items_wrap' => '<ul>%3$s</ul>', 'theme_location' =>   'viralvideo_wp_primary-menu' ) ); ?>
                </nav>
            <?php endif; // End check for menu. ?>
            <div class="clear"></div>
        </div><!-- end .main-header -->
</header><!-- end #header -->

    <?php if ($viralvideo_wp_topicons_display == 'Yes') { ?>
        <ul class="top-social">
            <?php if (!empty($viralvideo_wp_top_social_icons)) { ?><?php echo wp_kses_post(stripslashes($viralvideo_wp_top_social_icons)); ?><?php } ?>
        </ul><!-- end .top-social -->
    <?php } ?>


<?php if ( is_page_template( 'template-home.php' ) ) { 
    if ($viralvideo_wp_display_tvp == 'Yes') : ?> 
    <!-- Featured Blog Posts -->
    <div id="featured-posts">
    <ul class="featured-home-posts">
      <?php $viralvideo_featured_topposts = new WP_Query(array( 'ignore_sticky_posts' => esc_attr(1), 'meta_key' => 'post_views_count_viralvideo_wp', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'posts_per_page' =>  esc_attr(5) )); // number to display more / less ?>
            <?php $post = $posts[0]; $c=0;?>
      <?php while ($viralvideo_featured_topposts->have_posts()) : $viralvideo_featured_topposts->the_post(); ?> 


        <?php $c++;
        if( !$paged && $c == 1) : ?>
        <li class="big"> 
            <?php if ( has_post_thumbnail()) { ?>   
                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('viralvideo_wp_thumbnail-blog-featured'); ?></a>
            <?php } else { ?> 
                <a href="<?php the_permalink(); ?>"> <img src="<?php echo get_template_directory_uri(); ?>/images/random-img.png" alt="article image" /></a>
            <?php } ?>
            <div class="title-box">
                <a class="read-more" href="<?php the_permalink(); ?>"><i class="fa fa-chevron-right" aria-hidden="true"></i></a>
                <a href="<?php the_permalink(); ?>"><h2><?php if ( strlen(get_the_title()) > 100 ) { echo substr(get_the_title(), 0, 90)." .."; } else { the_title(''); } ?></h2></a>
            </div>
        </li>
        <?php else : ?>
        <li>
            <?php if ( has_post_thumbnail()) { ?> 
                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('viralvideo_wp_thumbnail-blog-featured-small'); ?></a>
            <?php } else { ?> 
                <a href="<?php the_permalink(); ?>"> <img src="<?php echo get_template_directory_uri(); ?>/images/random-img.png" alt="article image" /></a>
            <?php } ?>            
            <div class="title-box">
                <a class="read-more" href="<?php the_permalink(); ?>"><i class="fa fa-chevron-right" aria-hidden="true"></i></a>
                <a href="<?php the_permalink(); ?>"><h2><?php if ( strlen(get_the_title()) > 50 ) { echo substr(get_the_title(), 0, 45)." .."; } else { the_title(''); } ?></h2></a>
            </div>
        </li>
        <?php endif;?>

      <?php endwhile; 
      /* Restore original Post Data */
      wp_reset_postdata(); ?>
    </ul><!-- end .featured-home-posts -->
    <div class="clear"></div>
    </div><!-- end #featured-posts -->
    <div class="clear"></div>
  <?php endif; ?> 
<?php } ?> 