<?php
// ------------------------------------------------------
// ------ Module 1: Articles by Categories  -------------
// ------ by AnThemes.net -------------------------------
//        http://themeforest.net/user/An-Themes/portfolio
//        http://themeforest.net/user/An-Themes/follow 
// ------------------------------------------------------

class viralvideo_wp_module2 extends WP_Widget {
     function __construct() {
	    $widget_ops = array('description' => esc_html__('Module 2: Articles by Categories with black background.', 'viralvideo-wp'));
        parent::__construct(false, $name = ''. esc_html__('== Module 2 == Articles by Categories', 'viralvideo-wp') .'',$widget_ops); 
    }

   function widget($args, $instance) {  
		extract( $args );
		$title = $instance['title'];
    $moduletitle = $instance['moduletitle'];
		$category = $instance['category'];
    $number = $instance['number'];

    // Get the ID of a given category
    $category_id = $category;

    // Get the URL of this category
    $category_link = get_category_link( $category_id );    
?>
 
<?php echo wp_kses_post($before_widget); ?>
<?php if ( $title ) echo wp_kses_post($before_title) . esc_attr($title) . wp_kses_post($after_title); ?>


        <h3 class="title-home titlewhite"><?php echo esc_attr( $moduletitle ); ?></h3>
        <ul id="module-black" class="grid_list">

          <?php $viralvideo_wp_module2_categories = new WP_Query(array('post_type' => 'post',  'ignore_sticky_posts' => esc_attr(1), 'cat' => esc_attr($category), 'posts_per_page' => esc_attr($number) )); // number to display more / less ?>
          <?php while ($viralvideo_wp_module2_categories->have_posts()) : $viralvideo_wp_module2_categories->the_post(); ?> 

            <li <?php post_class('ex34') ?> id="post-<?php the_ID(); ?>">
                <?php if ( has_post_thumbnail()) { ?>        
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('viralvideo_wp_thumbnail-blog-grid', array('title' => "")); ?></a>
                    <div class="avatar-grid"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 30 ); ?></a></div><div class="clear"></div>
                <div class="content-grid">
                <?php } else { ?>
                    <div class="noimg"></div>
                    <div class="avatar-grid"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 30 ); ?></a></div><div class="clear"></div>
                <div class="content-grid">
                <?php } // Post Thumbnail ?> 
                    <a href="<?php the_permalink(); ?>"><h2><?php viralvideo_wp_the_title( 55, ' ..'); ?></h2></a>
                    <div class="clear"></div>
                    <span class="anpostdate"><?php esc_html_e('Posted on', 'viralvideo-wp'); ?> <?php the_time('M j, Y'); ?></span>
                    <?php if ( function_exists( 'getPostViews_viralvideo_wp' ) ) { ?> <span class="anviews"><i class="icofont icofont-fire-burn" title="<?php esc_html_e( 'Views!', 'viralvideo-wp' ); ?>"></i> <?php echo getPostViews_viralvideo_wp(get_the_ID()); ?></span><?php } ?>             
                    <?php if (get_comments_number()==0) { } else { ?><span class="comm"><i class="fa fa-commenting" aria-hidden="true"></i> <?php comments_popup_link('0', '1', '%'); ?></span><?php } ?>
                </div><!-- end .content-grid -->
            </li>

          <?php endwhile; 
          /* Restore original Post Data */
          wp_reset_postdata(); ?>
        </ul><div class="clear"></div>

 

<?php echo wp_kses_post($after_widget); ?> 
  
<?php
    }

    function update($new_instance, $old_instance) {       
    $instance = $old_instance;
    $instance['title'] = strip_tags($new_instance['title']);
    $instance['number']    = is_numeric( $new_instance['number'] ) ? intval( $new_instance['number'] ) : 6;
    $instance['moduletitle'] = strip_tags($new_instance['moduletitle']);
    $instance['category']  = wp_strip_all_tags( $new_instance['category'] );
     return $instance;
    }

  function form( $instance ) {
    $defaults  = array( 'title' => '', 'moduletitle' => '', 'category' => '', 'number' => 6);
    $instance  = wp_parse_args( ( array ) $instance, $defaults );
    $title     = $instance['title'];
    $moduletitle     = $instance['moduletitle'];
    $category  = $instance['category'];
    $number    = $instance['number'];
?>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('moduletitle')); ?>"><?php esc_html_e( 'Title:', 'viralvideo-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('moduletitle')); ?>" name="<?php echo esc_attr($this->get_field_name('moduletitle')); ?>" type="text" value="<?php if( isset($instance['moduletitle']) ) echo esc_attr($instance['moduletitle']); ?>" />
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e( 'Number of Posts:', 'viralvideo-wp' ); ?></label>      
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php if( isset($instance['number']) ) echo esc_attr($instance['number']); ?>" />
        </p> 

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e( 'Category:', 'viralvideo-wp' ); ?></label>      
            <?php
            wp_dropdown_categories( array(

              'show_count' => 1,
              'orderby'    => 'title',
              'hide_empty' => false,
              'name'       => $this->get_field_name( 'category' ),
              'id'         => 'rpjc_widget_cat_recent_posts_category',
              'class'      => 'widefat',
              'selected'   => $category

            ) );
            ?>
        </p> 

<?php  } }

// register widget
function viralvideo_wp_module2_init_widget () {
    return register_widget('viralvideo_wp_module2');
  }
add_action ('widgets_init', 'viralvideo_wp_module2_init_widget');
?>