<?php
// ------------------------------------------------------
// ------ Posts by Categories  --------------------------
// ------ by Anthemes.net -------------------------------
//        http://themeforest.net/user/An-Themes/portfolio
//        http://themeforest.net/user/An-Themes/follow 
// ------------------------------------------------------

class viralvideo_wp_postcat extends WP_Widget {
     function __construct() {
      $widget_ops = array('description' => esc_html__('Posts by Categories', 'viralvideo-wp'));
        parent::__construct(false, $name = ''. esc_html__('Custom: Posts by Categories', 'viralvideo-wp') .'',$widget_ops);  
    }



    function widget($args, $instance) {   
        extract( $args );
        $number = $instance['number'];
        $title = $instance['title'];
        $category = $instance['category'];

?>



<?php echo wp_kses_post($before_widget); ?>
<?php if ( $title ) echo wp_kses_post($before_title) . esc_attr($title) . wp_kses_post($after_title); ?>


<ul class="article_list">
<?php $viralvideo_wp_widget_postcat = new WP_Query(array('post_type' => 'post',  'ignore_sticky_posts' => 1, 'cat' => esc_attr($category), 'posts_per_page' => esc_attr($number) )); // number to display more / less ?>
<?php $num=1; while ($viralvideo_wp_widget_postcat->have_posts()) : $viralvideo_wp_widget_postcat->the_post(); ?> 
 
  <li>
      <?php if ( has_post_thumbnail()) { ?>
      <div class="post-nr"><?php echo esc_html($num++); ?></div>
      <?php } ?>    
      <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('viralvideo_wp_thumbnail-widget-small'); ?></a>
      <div class="an-widget-title" <?php if ( has_post_thumbnail()) { ?> style="margin-left:135px;" <?php } ?>>
        <a href="<?php the_permalink(); ?>"><h4 class="article-title"><?php viralvideo_wp_the_title( 38, ' ..'); ?></h4></a>              
        <div class="authorname"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 18 ); ?></a> </div>
        <?php if ( function_exists( 'getPostViews_viralvideo_wp' ) ) { ?> <span class="anviews"><i class="icofont icofont-fire-burn" title="<?php esc_html_e( 'Views!', 'viralvideo-wp' ); ?>"></i> <?php echo getPostViews_viralvideo_wp(get_the_ID()); ?></span><?php } ?> 
        <?php if (get_comments_number()==0) { } else { ?><span class="comm"><i class="fa fa-commenting" aria-hidden="true"></i> <?php comments_popup_link('0', '1', '%'); ?></span><?php } ?>
      </div>
  </li>

<?php endwhile; 
/* Restore original Post Data */
wp_reset_postdata(); ?>
</ul><div class="clear"></div>

<?php echo wp_kses_post($after_widget); ?> 


<?php
    }
    function update($new_instance, $old_instance) {       
    $instance = $old_instance;
    $instance['title'] = strip_tags($new_instance['title']);
    $instance['number']    = is_numeric( $new_instance['number'] ) ? intval( $new_instance['number'] ) : 5;
    $instance['category']  = wp_strip_all_tags( $new_instance['category'] );
    return $instance;
    }

  function form( $instance ) {
    $defaults  = array(
      'title' => '', 'category' => '', 'number' => 5,
       );
    $instance  = wp_parse_args( ( array ) $instance, $defaults );
    $title     = $instance['title'];
    $category  = $instance['category'];
    $number    = $instance['number'];
?>


        <p>
          <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e( 'Title:', 'viralvideo-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php if( isset($instance['title']) ) echo esc_attr($instance['title']); ?>" />
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e( 'Number of Posts:', 'viralvideo-wp' ); ?></label>      
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php if( isset($instance['number']) ) echo esc_attr($instance['number']); ?>" />
        </p> 
         
        <p>
          <label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e( 'Category:', 'viralvideo-wp' ); ?></label>      
            <?php
            wp_dropdown_categories( array(

              'show_count' => 1,
              'orderby'    => 'title',
              'hide_empty' => false,
              'name'       => $this->get_field_name( 'category' ),
              'id'         => 'rpjc_widget_cat_recent_posts_category',
              'class'      => 'widefat',
              'selected'   => $category

            ) );
            ?>
        </p> 

<?php  } } 

// register widget
function viralvideo_wp_postcat_init_widget () {
    return register_widget('viralvideo_wp_postcat');
  }
add_action ('widgets_init', 'viralvideo_wp_postcat_init_widget');
?>