<?php
// ------------------------------------------------ 
// ---------- Options Framework Theme -------------
// ------------------------------------------------
 include( get_template_directory() . '/admin/index.php');

// ---------------------------------------------- 
// --------------- Load Custom Widgets ----------
// ----------------------------------------------
 include( get_template_directory() . '/functions/widgets.php');
 include( get_template_directory() . '/functions/widgets/widget-top-tags.php');
 include( get_template_directory() . '/functions/widgets/widget-latest-posts.php');
 include( get_template_directory() . '/functions/widgets/widget-cat-posts.php'); 
 include( get_template_directory() . '/functions/widgets/widget-top-posts.php');
 include( get_template_directory() . '/functions/widgets/widget-feedburner.php');
 include( get_template_directory() . '/functions/widgets/widget-banner.php');
 include( get_template_directory() . '/functions/widgets/widget-module-1.php');
 include( get_template_directory() . '/functions/widgets/widget-module-2.php');

// ----------------------------------------------
// --------------- Load Custom ------------------
// ---------------------------------------------- 
 include( get_template_directory() . '/functions/custom/comments.php');
  
// ----------------------------------------------
// ------ Content width -------------------------
// ----------------------------------------------
if ( ! isset( $content_width ) ) $content_width = 950;

// ----------------------------------------------
// ------ Theme set up --------------------------
// ----------------------------------------------
add_action( 'after_setup_theme', 'viralvideo_wp_theme_setup' );
if ( !function_exists('viralvideo_wp_theme_setup') ) {

    function viralvideo_wp_theme_setup() {
    
        // Register navigation menu
        register_nav_menus(
            array(
                'viralvideo_wp_primary-menu' => esc_html__( 'Header Navigation', 'viralvideo-wp' ),
                'viralvideo_wp_footer-menu' => esc_html__( 'Footer Navigation', 'viralvideo-wp' )
            )
        );
        
        // Localization support
        load_theme_textdomain( 'viralvideo-wp', get_template_directory() . '/languages' );
        
        // Feed Links
        add_theme_support( 'automatic-feed-links' );
        
        // Title Tag
        add_theme_support( 'title-tag' );

        // Post thumbnails
        add_theme_support( 'post-thumbnails' );
        add_image_size( 'viralvideo_wp_thumbnail-blog-grid', 283, 165, true ); // Blog thumbnails home full width
        add_image_size( 'viralvideo_wp_thumbnail-blog-featured', 640, 460, true ); // Blog thumbnails home featured posts
        add_image_size( 'viralvideo_wp_thumbnail-blog-featured-small', 320, 230, true ); // Blog small thumbnails home featured posts
        add_image_size( 'viralvideo_wp_thumbnail-widget-small', 120, 90, true ); // Sidebar Widget thumbnails small
        add_image_size( 'viralvideo_wp_thumbnail-single-image', 950, '', true ); // Single thumbnails

    }
}

// ----------------------------------------------
// ------------ JavaScrips Files ----------------
// ----------------------------------------------
if( !function_exists( 'viralvideo_wp_enqueue_scripts' ) ) {
    function viralvideo_wp_enqueue_scripts() {

        // Register css files
        wp_enqueue_style( 'viralvideo_wp_style', get_stylesheet_uri(), '', '2.8');
        wp_enqueue_style( 'viralvideo_wp_default', get_template_directory_uri() . '/css/colors/default.css', array( 'viralvideo_wp_style' ), '2.8' );
        wp_enqueue_style( 'viralvideo_wp_responsive', get_template_directory_uri() . '/css/responsive.css', array( 'viralvideo_wp_style' ), '2.8' );
        wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome-4.7.0/css/font-awesome.min.css', array(), '4.7.0' );
        wp_enqueue_style( 'icofont', get_template_directory_uri() . '/css/icofont/icofont.min.css', array(), '1.0.1' );

        // Register scripts
        wp_enqueue_script( 'viralvideo_wp_customjs', get_template_directory_uri() . '/js/custom.js', array( 'jquery' ), '1.1.1', true );
        wp_enqueue_script( 'jquery-sticky-kit',  get_template_directory_uri() . '/js/jquery.sticky-kit.js', array( 'jquery' ), '1.1.2', true );
        $viralvideo_wp_js_custom = array( 'template_url' => get_template_directory_uri('template_url') ); wp_localize_script( 'viralvideo_wp_customjs', 'viralvideo_wp_js_custom', $viralvideo_wp_js_custom );

        // Load Comments & .js files.
        if( is_single() ) {
            wp_enqueue_script( 'comment-reply' );
         }

// ----------------------------------------------
// Register Fonts: https://gist.github.com/kailoon/e2dc2a04a8bd5034682c
// ----------------------------------------------
        function viralvideo_wp_fonts_url() {
            $viralvideo_wp_font_url_google = '';
            
            /*
            Translators: If there are characters in your language that are not supported
            by chosen font(s), translate this to 'off'. Do not translate into your own language.
             */
            if ( 'off' !== _x( 'on', 'Google font: on or off', 'viralvideo-wp' ) ) {
                $viralvideo_wp_font_url_google = add_query_arg( 'family', urlencode( 'Ruda:400,700|Baloo Bhaina|Open Sans Condensed:300,700' ), "//fonts.googleapis.com/css" );
            }
            return $viralvideo_wp_font_url_google;
        }
        /* -- Enqueue styles -- */
        wp_enqueue_style( 'viralvideo_wp_fonts', viralvideo_wp_fonts_url(), array(), '1.0.0' );
  

    }
    add_action('wp_enqueue_scripts', 'viralvideo_wp_enqueue_scripts');
}


// ----------------------------------------------
// ---------- excerpt length adjust -------------
// ----------------------------------------------
function viralvideo_wp_excerpt($str, $length, $minword = 3) {
    $sub = '';
    $len = 0;
    foreach (explode(' ', $str) as $word) {
        $part = (($sub != '') ? ' ' : '') . $word;
        $sub .= $part;
        $len += strlen($part);
        if (strlen($word) > $minword && strlen($sub) >= $length) { break; }
    }
    return $sub . (($len < strlen($str)) ? ' ..' : '');
}


// ------------------------------------------------ 
// ------------ Nr of Topics for Tags -------------
// ------------------------------------------------  
if ( ! function_exists('tag_cloud_count_anthemes')) {
function tag_cloud_count_anthemes($content, $tags, $args)
{ 
  $count=0;
  $output=preg_replace_callback('(</a\s*>)', 
  function($match) use ($tags, &$count) {
      return "<span class=\"tagcount\"> ".$tags[$count++]->count."</span></a>";  
  }
  , $content);
  
  return $output;
}
add_filter('wp_generate_tag_cloud','tag_cloud_count_anthemes', 10, 3); 
}


// ------------------------------------------------ 
// --- Characters limit for title -----------------
// ------------------------------------------------ 
function viralvideo_wp_the_title($length, $replacer = ' ..') {
    $string = get_the_title();
    if( mb_strlen( $string ) > $length ) {
        $string = mb_substr( $string, 0, $length-3 );
        echo $string . $replacer;
    } else echo $string;
}


// ------------------------------------------------ 
// --- One Click Demo Import (Plugin) -------------
// ------------------------------------------------ 
function kickcube_wp_plugin_intro_text( $kickcube_wp_default_text ) {
    $kickcube_wp_default_text =  /* https://wordpress.org/plugins/one-click-demo-import/faq/ the inline style is added for the demo import plugin, that is displayed via Dashboard > Appearance. */ '<div class="ocdi__intro-text" style="width:355px;">'. esc_html__( 'Please click "Import Demo Data" button only once and wait, it can take a couple of minutes.', 'viralvideo-wp' ) .'</div>';?><br /><img style="width:400px; margin-bottom: 20px; border-radius: 4px;" src="<?php echo get_template_directory_uri(); ?>/screenshot.png" width="400" hieght="300" alt="img" /><br /> In the meantime, you check the <a href="https://anthemes.com/docs/viral-video/" target="_blank">help file</a> or <a href="https://anthemes.com/support/" target="_blank">get support</a>.<?php
    return $kickcube_wp_default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'kickcube_wp_plugin_intro_text' );

function kickcube_wp_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Main Demo', 'viralvideo-wp' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . '/functions/demo/viralvideo-content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . '/functions/demo/viralvideo-widgets.wie',
        ) 
    );
}
add_filter( 'pt-ocdi/import_files', 'kickcube_wp_import_files' );


// ------------------------------------------------ 
// ------------ Notice ----------------------------
// ------------------------------------------------
function themes_admin_notice(){
    global $pagenow;
    if ( $pagenow == 'themes.php' ) {
         echo '<div class="notice notice-info is-dismissible" style="box-shadow: 0 1px 5px rgba(0,0,0,0.2); ">
             <p><a class="button" href="https://anthemes.com/" target="_blank">Anthemes.com</a> <a class="button activate" href="https://themeforest.net/item/viralvideo-responsive-magazine-wordpress-theme/20801118" target="_blank">ViralVideo Theme</a> <a class="button activate" href="https://themeforest.net/item/viralvideo-responsive-magazine-wordpress-theme/20801118/support" target="_blank">Get Support</a></p>
         </div>';
    }
}
add_action('admin_notices', 'themes_admin_notice');
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );


// ------------------------------------------------ 
// ---------- TGM_Plugin_Activation ---------------
// ------------------------------------------------ 
 include( get_template_directory() . '/functions/custom/class-tgm-plugin-activation.php');
 add_action( 'tgmpa_register', 'viralvideo_wp_register_required_plugins' );

function viralvideo_wp_register_required_plugins() {

    $plugins = array(
         array(
            'name'                  => esc_html__( 'Shortcodes', 'viralvideo-wp' ), // The plugin name
            'slug'                  => 'anthemes-shortcodes', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/anthemes-shortcodes.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '1.2', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'ViralVideo Theme Core', 'viralvideo-wp' ), // The plugin name
            'slug'                  => 'viralvideo-wp-options', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/viralvideo-wp-options.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '1.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'Top Users Widget', 'viralvideo-wp' ), // The plugin name
            'slug'                  => 'anthemes-top-users', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/anthemes-top-users.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'Responsive Menu', 'viralvideo-wp' ), // The plugin name
            'slug'                  => 'responsive-menu', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/responsive-menu.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '6.1.4', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'Meta Box', 'viralvideo-wp' ),
            'slug'                  => 'meta-box',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'Video Thumbnails', 'viralvideo-wp' ),
            'slug'                  => 'video-thumbnails',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'Ultimate Member', 'viralvideo-wp' ),
            'slug'                  => 'ultimate-member',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'User Submitted Posts', 'viralvideo-wp' ),
            'slug'                  => 'user-submitted-posts',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'Daves WordPress Live Search', 'viralvideo-wp' ),
            'slug'                  => 'daves-wordpress-live-search',
            'required'              => false,
            'version'               => '',
        ), 
 
        array(
            'name'                  => esc_html__( 'WP-PageNavi', 'viralvideo-wp' ),
            'slug'                  => 'wp-pagenavi',
            'required'              => false,
            'version'               => '',
        ), 

        array(
            'name'                  => esc_html__( 'One Click Demo Import', 'viralvideo-wp' ),
            'slug'                  => 'one-click-demo-import',
            'required'              => false,
            'version'               => '',
        ),  

    );

    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.

    );

    tgmpa( $plugins, $config );

}

?>