<?php
    // Logo Footer
    $viralvideo_wp_logo_footer = get_theme_mod('viralvideo_wp_logo_footer');
    if (empty($viralvideo_wp_logo_footer)) { $viralvideo_wp_logo_footer = get_template_directory_uri().'/images/logo.png'; }

    // Custom Copyright
    $viralvideo_wp_display_custom_copyright = get_theme_mod('viralvideo_wp_display_custom_copyright');
    if (empty($viralvideo_wp_display_custom_copyright)) { $viralvideo_wp_display_custom_copyright = 'No'; }   

    // Copyright
    $viralvideo_wp_copyright = get_theme_mod('viralvideo_wp_copyright'); 
?>
<!-- Begin Footer -->
<?php if ( has_nav_menu( 'viralvideo_wp_footer-menu' ) ) : // Check if there's a menu assigned to the 'Footer Navigation' location. ?>
<div class="clear"></div>
<div class="waveHorizontals">
    <div id="waveHorizontal1" class="waveHorizontal"></div>
    <div id="waveHorizontal2" class="waveHorizontal"></div>
    <div id="waveHorizontal3" class="waveHorizontal"></div>
</div>
<div class="footer-navigation">
    <div class="wrap-center">
        <div id="popular-words">
            <?php wp_nav_menu( array( 'container' => false, 'items_wrap' => '<ul>%3$s</ul>', 'theme_location' =>   'viralvideo_wp_footer-menu' ) ); ?>
        </div>
    </div>
</div><div class="clear"></div>  
<?php endif; // End check for menu. ?>

<footer>
    <div class="wrap-footer">
        <!-- Logo -->
        <div class="footer-logo-wrap">  
            <a href="<?php echo esc_url(home_url( '/' )); ?>"><img class="footer-logo" src="<?php echo esc_url($viralvideo_wp_logo_footer); ?>" alt="<?php esc_attr(bloginfo('sitename')); ?>" /></a>
        </div><!-- end .footer-logo-wrap -->


        <?php if ($viralvideo_wp_display_custom_copyright == 'Yes') { ?>
            <?php if (!empty($viralvideo_wp_copyright)) { echo wp_kses_post(stripslashes($viralvideo_wp_copyright)); } ?>
        <?php } else { ?>
          <p><span><?php esc_html_e( 'Powered by WordPress.', 'viralvideo-wp' ); ?></span></p>
          <p><span><?php esc_html_e( 'All Rights Reserved.', 'viralvideo-wp' ); ?></span></p>
        <?php } ?>
    </div><!-- end .wrap-footer -->


	<p id="back-top"><a href="#top">
      <span><i class="fa fa-chevron-up"></i></span></a>
    </p><!-- end #back-top -->
</footer><!-- end #footer -->

<!-- Footer Theme output -->
<?php wp_footer();?>
</body>
</html>