<?php

add_action('init','of_options');

if (!function_exists('of_options'))
{
	function of_options()
	{
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages('sort_column=post_parent,menu_order');    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");       
	
		//Testing 
		$of_options_select 	= array("one","two","three","four","five"); 
		$of_options_radio 	= array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
		
		//Sample Homepage blocks for the layout manager (sorter)
		$of_options_homepage_blocks = array
		( 
			"disabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_one"		=> "Block One",
				"block_two"		=> "Block Two",
				"block_three"	=> "Block Three",
			), 
			"enabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_four"	=> "Block Four",
			),
		);

 
	
		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr 		= wp_upload_dir();
		$all_uploads_path 	= $uploads_arr['path'];
		$all_uploads 		= get_option('of_uploads');
		$other_entries 		= array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
		$body_repeat 		= array("no-repeat","repeat-x","repeat-y","repeat");
		$body_pos 			= array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");
		
		$imgs_url = get_template_directory_uri().'/images/';
		$imgs_url_demo = get_template_directory_uri().'/demo';



// Set the Options Array
// viralvideo-wp
// viralvideo_wp
global $of_options;
$of_options = array();
 

 

/*-----------------------------------------------------------------------------------*/
/* Header Settings */
/*-----------------------------------------------------------------------------------*/

$of_options[] = array( 	"name" 		=> esc_html__( 'General Settings', 'viralvideo-wp' ),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-header.png"
				);


$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "",
						"id" 		=> "introduction_7",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Custom Logo.', 'viralvideo-wp') ."</h3>
						". esc_html__('Upload a custom logo image for your site.', 'viralvideo-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Custom Logo.', 'viralvideo-wp' ),
						"desc" 		=> esc_html__('Upload a custom logo image for your site here. Size for height should be 90px or bigger for retina screens.', 'viralvideo-wp'),
						"id" 		=> "viralvideo_wp_logo",
						"std" 		=> $imgs_url.'logo.png',
						"type" 		=> "upload");


$of_options[] = array( 	"name" 		=> esc_html__( 'Header Social Icons', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_social",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Header Social Icons.', 'viralvideo-wp') ."</h3>
						<strong>". esc_html__('Social Icons', 'viralvideo-wp') ."</strong> ". esc_html__('- Header Social Icons.', 'viralvideo-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Display Social Icons?', 'viralvideo-wp'),
						"desc" 		=> esc_html__('Display Social Icons?', 'viralvideo-wp'),
						"id" 		=> "viralvideo_wp_topicons_display",
						"std" 		=> esc_html__( 'No', 'viralvideo-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
									   esc_html__( 'No', 'viralvideo-wp' ),
									   esc_html__( 'Yes', 'viralvideo-wp' )
									),
					);

$of_options[] = array( 	"name" 		=> esc_html__( 'Social Icons.', 'viralvideo-wp' ),
						"desc" 		=> "". esc_html__('You can use HTML code. For more social icons go to', 'viralvideo-wp') ." <a href=\"http://fontawesome.io/icons/\" target=\"_blank\">Font Awesome</a> ". esc_html__('and at the bottom you have Brand Icons!', 'viralvideo-wp') ."",
						"id" 		=> "viralvideo_wp_top_social_icons",
						"std" 		=> "
<li><a href=\"#\"><i class=\"fa fa-facebook\"></i></a></li>
<li><a href=\"#\"><i class=\"fa fa-twitter\"></i></a></li>
<li><a href=\"#\"><i class=\"fa fa-pinterest\"></i></a></li>
<li><a href=\"#\"><i class=\"fa fa-instagram\"></i></a></li>
",
						"type" 		=> "textarea");	



/*-----------------------------------------------------------------------------------*/
/* Blog Settings */
/*-----------------------------------------------------------------------------------*/
$of_options[] = array( 	"name" 		=> esc_html__( 'Blog Settings', 'viralvideo-wp' ),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-home.png"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Header Slider', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_slider",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Top viewed posts.', 'viralvideo-wp') ."</h3>
						<strong>". esc_html__('Featured Header Section', 'viralvideo-wp') ."</strong> ". esc_html__(' - top viewed posts.', 'viralvideo-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Display Top viewed Posts?', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Display Top viewed Posts?', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_display_tvp",
						"std" 		=> esc_html__( 'No', 'viralvideo-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
										esc_html__( 'No', 'viralvideo-wp' ),
										esc_html__( 'Yes', 'viralvideo-wp' )
									),
					);


$of_options[] = array( 	"name" 		=> esc_html__( 'Featured Image', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_featuredimg",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Featured Image.', 'viralvideo-wp') ."</h3>
						<strong>". esc_html__('Hide Featured Image', 'viralvideo-wp') ."</strong> ". esc_html__(' - for all posts in the post page.', 'viralvideo-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Hide Featured Image?', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Hide Featured Image?', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_hidefimg",
						"std" 		=> esc_html__( 'No', 'viralvideo-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
										esc_html__( 'No', 'viralvideo-wp' ),
										esc_html__( 'Yes', 'viralvideo-wp' )
									),
					);



$of_options[] = array( 	"name" 		=> esc_html__( 'Advertisements and Related Articles', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_siglepage",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Advertisements and Related Articles', 'viralvideo-wp') ."</h3>
						<strong>". esc_html__('Advertisements and Related Articles', 'viralvideo-wp') ."</strong> ". esc_html__('- for article pages after the content.', 'viralvideo-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");


$of_options[] = array( 	"name" 		=> esc_html__( 'Display Advertisements and Related Articles?', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Display Advertisements and Related Articles?', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_display_add_relatedarticles",
						"std" 		=> esc_html__( 'No', 'viralvideo-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
										esc_html__( 'No', 'viralvideo-wp' ),
										esc_html__( 'Yes', 'viralvideo-wp' )
									),
					);

$of_options[] = array( 	"name" 		=> esc_html__( '300x250 Advertisements.', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Paste your HTML or JavaScript code here. Advertisements displayed to the left in Related Articles section.', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_related_add300",
						"std" 		=> "
<a href=\"#\"><img src=\"http://placehold.it/300x250\" width=\"300\" height=\"250\" alt=\"img\" /></a>

<a href=\"#\"><img src=\"http://placehold.it/300x250\" width=\"300\" height=\"250\" alt=\"img\" /></a>",
						"type" 		=> "textarea");	


/*-----------------------------------------------------------------------------------*/
/* Style Settings */
/*-----------------------------------------------------------------------------------*/
$of_options[] = array( 	"name" 		=> esc_html__( 'Style Settings', 'viralvideo-wp' ),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-paint.png");


$of_options[] = array( 	"name" 		=> esc_html__( 'Style', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_14",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">".esc_html__( 'Style Settings', 'viralvideo-wp' )."</h3>
						". esc_html__( 'Use the color picker to change the main color of the site to match your brand color.', 'viralvideo-wp' ) ."",
						"icon" 		=> true,
						"type" 		=> "info");


$of_options[] = array( 	"name" 		=> esc_html__( 'Main Color (red)', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the main color of the site to match your brand color.', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_main_color",
						"std" 		=> "#e42b26",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Style', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_11",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">".esc_html__( 'Style Settings', 'viralvideo-wp' )."</h3>
						". esc_html__( 'Use the color picker to change the colors of the site to match your brand color.', 'viralvideo-wp' ) ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Header Background Color', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the color of the site to match your brand color.', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_header_bg",
						"std" 		=> "#191919",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Footer Navigation Background Color', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the color of the site to match your brand color.', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_footer_nav_bg",
						"std" 		=> "#ffc80b",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Footer Background Color', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the color of the site to match your brand color.', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_footer_bg",
						"std" 		=> "#191919",
						"type" 		=> "color"
				);


$of_options[] = array( 	"name" 		=> esc_html__( 'Entry Link Color', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the entry link color on article or default / full width pages.', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_entry_linkcolor",
						"std" 		=> "#e42b26",
						"type" 		=> "color"
				);


$of_options[] = array( 	"name" 		=> esc_html__( 'Custom CSS.', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_customcss",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">Custom CSS.</h3>
						". esc_html__( 'Enter your custom CSS code via Appearance > Customize > Additional CSS.', 'viralvideo-wp' ) ."",
						"icon" 		=> true,
						"type" 		=> "info"); 





/*-----------------------------------------------------------------------------------*/
/* Footer Settings */
/*-----------------------------------------------------------------------------------*/
$of_options[] = array( 	"name" 		=> esc_html__( 'Footer Settings', 'viralvideo-wp' ),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-settings.png");


$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "",
						"id" 		=> "introduction_7",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Custom Logo for Footer.', 'viralvideo-wp') ."</h3>
						". esc_html__('Upload a custom logo image for your site.', 'viralvideo-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Footer Custom Logo.', 'viralvideo-wp' ),
						"desc" 		=> esc_html__('Upload a custom logo image for your site here. The Logo can have any size.', 'viralvideo-wp'),
						"id" 		=> "viralvideo_wp_logo_footer",
						"std" 		=> $imgs_url.'logo.png',
						"type" 		=> "upload");
					

$of_options[] = array( 	"name" 		=> esc_html__( 'Copyright', 'viralvideo-wp' ),
						"desc" 		=> "",
						"id" 		=> "introduction_copy",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Copyright.', 'viralvideo-wp') ."</h3>
						". esc_html__('Footer Copyright.', 'viralvideo-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Display Custom Copyright?', 'viralvideo-wp' ),
						"desc" 		=> esc_html__( 'Display Custom Copyright?', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_display_custom_copyright",
						"std" 		=> esc_html__( 'No', 'viralvideo-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
										esc_html__( 'No', 'viralvideo-wp' ),
										esc_html__( 'Yes', 'viralvideo-wp' )
									),
					);


$of_options[] = array( 	"name" 		=> esc_html__( 'Copyright', 'viralvideo-wp' ),
						"desc" 		=> __( 'You can use HTML code. Change # with your link.', 'viralvideo-wp' ),
						"id" 		=> "viralvideo_wp_copyright",
						"std" 		=> "<p>851 E. Tropicana Avenue Las Vegas 
<i class=\"fa fa-times\"></i> (702)&nbsp;895-3174 

<i class=\"fa fa-times\"></i> <a href=\"#\">Users </a> 

<i class=\"fa fa-times\"></i> <a href=\"#\">About</a> 

<i class=\"fa fa-times\"></i> <a href=\"#\">Contact</a> 

<i class=\"fa fa-times\"></i> <a href=\"mailto:info@viralvideo.com\">info@viralvideo.com</a> </p>

<p><span>&copy; 2022 ViralVideo. All Rights Reserved. Theme by <a target=\"_blank\" href=\"https://anthemes.com/\">Anthemes.com</a></span></p>",
						"type" 		=> "textarea");	
 

	}//End &copy; function: of_options()
}//End chack if function exists: of_options()
?>
