<!-- VK CONTENT -->
<div class="vk-content">
  <!-- SECTION BANNER -->
  <div class="section-banner">
    <!-- SECTION BANNER ICON-->
    <svg class="section-banner-icon icon-logo-vikinger">
      <use href="#svg-logo-vikinger"></use>
    </svg>
    <!-- /SECTION BANNER ICON-->

    <!-- SECTION BANNER PRETITLE -->
    <p class="section-banner-pretitle">
    <?php

      printf(
        esc_html__('Version %s', 'vikinger'),
        VIKINGER_VERSION
      );

    ?>
    </p>
    <!-- /SECTION BANNER PRETITLE -->

    <!-- SECTION BANNER TITLE -->
    <p class="section-banner-title"><?php esc_html_e('Vikinger Theme', 'vikinger'); ?></p>
    <!-- /SECTION BANNER TITLE -->

    <!-- SECTION BANNER TEXT -->
    <p class="section-banner-text">
    <?php
    
      echo wp_kses(
        sprintf(
          esc_html__('%sThank you for your purchase!%s Below you will find information on how to setup the theme to start using it!.', 'vikinger'),
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION BANNER TEXT -->
  </div>
  <!-- /SECTION BANNER -->

  <!-- SECTION -->
  <div class="section">
    <!-- SECTION TOP IMAGE -->
    <img class="section-top-image" src="<?php echo VIKINGER_URL; ?>/img/admin/activation-submit.png" alt="activation-submit">
    <!-- /SECTION TOP IMAGE -->

    <!-- SECTION PRETITLE -->
    <p class="section-pretitle"><?php esc_html_e('Setup', 'vikinger'); ?></p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Theme Setup', 'vikinger'); ?></p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('%sThe theme requires the following plugins to be installed, updated and activated in order to function correctly%s. You can install, update and activate the following plugins manually or use the button below to install, update and activate all of them with 1 click!.', 'vikinger'),
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Setup Status', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

  <?php  
  
    $required_plugins_status_text = vikinger_plugin_get_required_plugins_status_text();

    if ($required_plugins_status_text === 'ok') {
      $message_box_type = 'success';
      $message_box_title = esc_html__('Everything is OK!', 'vikinger');
      $message_box_text = esc_html__('All required plugins are installed, updated and activated!', 'vikinger');
    } else {
      $message_box_type = 'error';
      $message_box_title = esc_html__('Something is wrong!', 'vikinger');
      $message_box_text = esc_html__('Some plugins need to be installed, updated or activated! Please install, update or activate them manually or by using the button below!', 'vikinger');
    }
  
  ?>

    <!-- MESSAGE BOX -->
    <div class="message-box message-box-<?php echo esc_attr($message_box_type); ?>">
      <!-- MESSAGE BOX ICON WRAP -->
      <div class="message-box-icon-wrap">
        <!-- MESSAGE BOX ICON -->
        <svg class="message-box-icon icon-<?php echo esc_attr($message_box_type); ?>">
          <use href="#svg-<?php echo esc_attr($message_box_type); ?>"></use>
        </svg>
        <!-- /MESSAGE BOX ICON -->
      </div>
      <!-- /MESSAGE BOX ICON WRAP -->

      <!-- MESSAGE BOX TITLE -->
      <p class="message-box-title"><?php echo esc_html($message_box_title); ?></p>
      <!-- /MESSAGE BOX TITLE -->

      <!-- MESSAGE BOX TEXT -->
      <p class="message-box-text"><?php echo esc_html($message_box_text); ?></p>
      <!-- /MESSAGE BOX TEXT -->
    </div>
    <!-- /MESSAGE BOX -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div class="section">
    <!-- SECTION TOP IMAGE -->
    <img class="section-top-image" src="<?php echo VIKINGER_URL; ?>/img/admin/plugins.png" alt="plugins">
    <!-- /SECTION TOP IMAGE -->

    <!-- SECTION PRETITLE -->
    <p class="section-pretitle"><?php esc_html_e('Plugins', 'vikinger'); ?></p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Required Plugins', 'vikinger'); ?></p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('The following plugins are required by the theme. If a plugin is not installed, updated or activated, a button will appear below that you can click to bulk install, update or activate all missing plugins!.%sThe theme will do its best to try and install, update and activate all the plugins in the list, but it can happen that a plugin fails to install, update or activate. In this case, just use the same button again to complete the process. %s%sPlease be patient as the process may take a few minutes.%s', 'vikinger'),
          '<br><br>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- VK REQUIRED PLUGIN LIST -->
    <div id="vk-required-plugin-list"></div>
    <!-- /VK REQUIRED PLUGIN LIST -->
  </div>
  <!-- /SECTION -->
</div>
<!-- /VK CONTENT -->