<!-- VK CONTENT -->
<div class="vk-content">
  <!-- SECTION BANNER -->
  <div class="section-banner">
    <!-- SECTION BANNER ICON-->
    <svg class="section-banner-icon icon-logo-vikinger">
      <use href="#svg-logo-vikinger"></use>
    </svg>
    <!-- /SECTION BANNER ICON-->

    <!-- SECTION BANNER PRETITLE -->
    <p class="section-banner-pretitle">
    <?php

      printf(
        esc_html__('Version %s', 'vikinger'),
        VIKINGER_VERSION
      );

    ?>
    </p>
    <!-- /SECTION BANNER PRETITLE -->

    <!-- SECTION BANNER TITLE -->
    <p class="section-banner-title"><?php esc_html_e('Changelog', 'vikinger'); ?></p>
    <!-- /SECTION BANNER TITLE -->

    <!-- SECTION BANNER TEXT -->
    <p class="section-banner-text">
    <?php
    
      echo wp_kses(
        sprintf(
          esc_html__('%sThank you for your purchase!%s Below you will find information on theme updates!.', 'vikinger'),
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION BANNER TEXT -->
  </div>
  <!-- /SECTION BANNER -->

  <!-- SECTION -->
  <div class="section">
    <!-- SECTION TOP IMAGE -->
    <img class="section-top-image" src="<?php echo VIKINGER_URL; ?>/img/admin/plugins.png" alt="plugins">
    <!-- /SECTION TOP IMAGE -->

    <!-- SECTION PRETITLE -->
    <p class="section-pretitle"><?php esc_html_e('Changelog', 'vikinger'); ?></p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('How to update the theme?', 'vikinger'); ?></p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You can either install the update manually by downloading the updated theme package from themeforest, or you can use the %sEnvato Market WordPress Plugin%s.%s %sDo not delete any of the theme required plugins or you will loose all associated data, like reactions and images.%s', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.3.5" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">March 04, 2021</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.3.5</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused the forum description notice to try to get the last author information even when the forum had no content.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed post comment list showing a loading indicator even when the post had 0 comments.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that could cause the comment list to wrongly report that more comments where available to show after creating a new comment.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused the reply button to show on comments when the "Allow Comments" option was disabled.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused the light/dark mode toggle to not refresh the page under certain conditions.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused duplicated characters to appear on some inputs when using certain languages.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a different background color to forum and topic even rows to improve visual separation between them.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Pages with "Allow Comments" option disabled now hide all comment related elements instead of only disabling the comment form.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('bbPress Group Forums', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Users can now create a forum for their group by using the frontend "Manage Groups" settings screen.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('If the bbPress settings option "Allow BuddyPress Groups to have their own forums" is active, then a new "Forum" tab will be added to the group manage popup for group admins. You can also select a forum or category to be used to contain all group forums from this settings screen by using the bbPress "Primary Forum" option.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('From the group manage popup "Forum" tab, the "Enable forum for this group" option can be activated to create a forum for the group which will be available both on the forum page and as a new link on the group page navigation bar.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The group name, description and status will be used by default for the group forum, however users can choose to change the title, description and status of the forum (the group avatar image will be used as the forum image).', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('After enabling forum for the group, group admins can delete the forum and all its content just by disabling the same option ("Enable forum for this group") and by clicking on "Save Changes".', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.3.4" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">February 26, 2021</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.3.4</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed comment timestamp displaying with an offset for logged out users.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed some cases where the side menu item for the current page wouldn\'t be marked as active.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Improved visibility of the activity and comment settings dropdown icon.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Demo Import', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('We created a demo content import tool to allow users to easily replicate the content from the demo into their theme. This tool can be used any number of times and also includes the ability to reset (delete) the imported data. If you want to remove data created by the importer, please use this option.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The importer can be used from the new backend theme "Demo Import" menu. Users are not forced to import all demo content data and can select what they want to import.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('We created a new %stutorial video%s which includes the full theme install and setup process, including the use of this new demo import tool. We also updated the theme documentation to include a new "Demo Import" section.', 'vikinger'),
          '<a href="https://www.youtube.com/watch?v=SXEgduXEupk" target="_blank">',
          '</a>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.3.3" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">February 19, 2021</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.3.3</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('The "Add New" button of the Groups backend menu now correctly sends the user to their "Manage Groups" settings screen.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed a crash that would occur when a duplicate comment was created on a blog post.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('The "Light" and "Dark" Color Switch now clears user meta cache to force getting and displaying the user selected theme when switching.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('The "Account Settings" section has been added to the users Account menu. From here, users can use the "Delete Account" button to delete their account from the site. Site admins can choose to enable or disable allowing registered members to delete their own accounts by using the BuddyPress backend settings option: "Settings" -> "BuddyPress" -> "Options" -> "Account Deletion".', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Updated the "Vikinger - BuddyPress Extension" plugin to include the new delete account related "Account Settings" menu. Please update the plugin using the theme installer.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Introduced newsfeed related performance optimizations.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Activity Improvements', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Users can now delete their activity and blog comments. A new actions dropdown has been added next to the "Reply" button with the option "Delete Comment" to comments owned by the logged in user.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('A new grayscale fade visual effect has been added on activity and comment deletion confirmation that indicates that the activity or comments are being deleted.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Activity Feed Settings', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Several new options have been added to the "Customizer" -> "Vikinger Settings" -> "Newsfeed" section which allow users more control over activity feed related settings.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Activity - Show More Status: by enabling this option, a "Show More" button will appear on activities that have a large height.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Activity - Show More Height: you can control the maximum height that the feed activities can have. If an activity has a height that is greater than this value, then the remaining content will be hidden and a "Show More" button will be created to allow users to display the remaining activity content.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Activity - Character Limit: you can control the maximum number of characters that users can put into an activity.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Activity - Comment Character Limit: you can control the maximum number of characters that users can put into an activity comment (this limit also applies for blog post comments).', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Members Settings', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Several new options have been added to the "Customizer" -> "Vikinger Settings" -> "Members" section which allow users more control over members related settings.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('From this section, you can now enable or disable member profile pages added by the theme. This will allow you to easily disable a member profile page and associated navigation item if you don\'t want to use it (like the profile blog page).', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('You can also choose the order in which enabled pages are displayed in the profile navigation bar (lower numbered pages will display before higher numbered ones), allowing you to display the pages you think are more important or should be easier to access first in the navigation bar.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('BP Better Messages Integration', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Modified the BP Better Messages plugin elements styles so that they use theme preset colors and made several adjustments to each element to make its styles integrate better with the theme.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.3.2" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">February 12, 2021</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.3.2</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the membership requests settings screen page title using the received invitations screen title.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue which would prevent received membership requests from being displayed on the user "Membership Requests" settings page.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that would cause some BuddyPress Private Messaging module related features to show when the "Private Messaging" module was deactivated on the BuddyPress Settings Page.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Dates in the user profile about widgets are now displayed localized and with the format selected on the WordPress backend "Settings" -> "General" -> "Date Format" setting.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text">
        <?php

          echo wp_kses(
            sprintf(
              esc_html__('Added a new Customizer option that allows limiting YouTube embed video playbacks on the newsfeed. The option can be found on "Vikinger Settings" -> "Newsfeed" -> "Limit YouTube Playback". You can use this option to limit YouTube embedded video playbacks on the newsfeed of the site. If you select "Yes", only one YouTube video will be played at a time, this means that, if a user is playing a video and chooses to play another one, then the previous video will be paused. The %sYouTube Player API%s is used to achieve this behaviour.', 'vikinger'),
              '<a href="https://developers.google.com/youtube/iframe_api_reference" target="_blank">',
              '</a>'
            ),
            vikinger_wp_kses_admin_text_get_allowed_tags()
          );

        ?>
        </p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Introduced several performance improvements and optimizations.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.3.1" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">February 03, 2021</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.3.1</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the header showing the cogwheel dropdown on lower resolutions when the same information was available on the mobile menu.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the username (mention name) of the post author (in post version 3) being centered instead of aligned to the left.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the "locked" and "unlocked!" achievement progress bar text not being translatable.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed "Archive" pages showing the page headers when the option to hide them was selected on the Customizer.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Replaced "Messages" string with "Inbox" on the header messages dropdown to avoid confusion regarding the previewed content.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Color Theme Switch', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('You can now choose to enable a color theme switch via the "Customizer" -> "Vikinger Settings" -> "Color Presets" menu.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('If enabled, your site logged in users will be able to change between a "Light" and "Dark" theme while browsing the site by using a sun / moon button that is added on the header on desktop and on the header menu on mobile.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('From the same Customizer section you can set which of the existing color presets you want to assign when the "Light" or "Dark" theme modes are activated. For example, you can choose to use the "Custom" color preset for the "Light" theme mode, and the "Carbon Yellow" color preset for the "Dark" theme mode.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('You can also set the default theme mode ("Light" or "Dark") that is used when the color theme switch is active.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('When the color theme switch is disabled, the theme will use the color preset that you assign in the "Color Preset" option.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('BP Better Messages Compatibility', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The theme is now compatible with the BP Better Messages plugin.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('This means that, when the plugin is installed and active, it will replace the Messages profile setting screen with the one provided by the plugin. Also, when clicking on a message from the header messages dropdown, it will correctly open and display that message on the settings screen.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Verified Member for BuddyPress Integration', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Added support for the "Verified Member for BuddyPress" plugin.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('All member related widgets now support the display of the "verified" badge next to the user fullname or username (mention name) according to the setting the user has selected on the plugin ("Settings" -> "BuddyPress" -> "Verified Member").', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.3.0" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">January 26, 2021</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.3.0</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that would cause group slugs to display incorrect characters when using certain languages.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that could cause the group manage popup to infinite load after submitting the creation of a new group.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused the activity feed to stop working when an activity or post that was shared was deleted and added a message which informs the user that the shared content was deleted.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed group status dropdown text not being translated correctly in the group management popup.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused the notifications bar to stop working when a user had a message from a deleted user in their inbox.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('BuddyPress Profile Fields that are empty will no longer display in the About, Personal Information and Personal Interests widgets, when they would previously display with a "-" as value.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('The slug option has been removed from the group creation and manage screens based on user feedback.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a smooth scrolling effect when navigating to page anchors.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Navigating to page anchors now takes into account the floating header height, which prevents the top part of the anchored content from being covered by the header.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('bbPress Integration', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Added support for bbPress forums. Users can now use bbPress with the theme to create and manage forums.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('We also added support for forum images, this allows users to associate an image to a forum in the backend, this image will be displayed next to the forum information on the frontend and make it easier to visually identify forum content.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('A new navigation item has been added to user profiles called "Forum", this new page has information about the forum activity of a particular user (created topics and replies, engagements and favorites). Logged in users can also view their forum and topic subscriptions from this page.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('bbPress generated notifications will now show in the user notifications settings screen and the notifications header bar dropdown. These notifications include useful information and links to forum content.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('bbPress generated activities will now show on activity feeds and we have added 2 new "Show" filters for them on the activity feed filters bar ("Forum Topics" and "Forum Replies").', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Group Forums are not yet supported and will be added on a future update.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('We highly recommend checking out the new tutorial videos we have released, which explain how to install the update and create a link to your new forums as well as show a forum creation example.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('FAQs and Support', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('We\'ve updated the "FAQs" section with answers to the most frequently asked questions our support team has been receiving and we also updated the "Support" section with a more detailed explanation of what the theme Support includes according to Envato\'s Support Policy as well as third party sources that offer Customization Services for users that want to customize their theme.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.2.0" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">December 5, 2020</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.2.0</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the group profile avatar hexagon showing incorrect color on mobile resolutions.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed Radio Buttons and Checkboxes profile field types displaying too close to each other if there were too many of them on mobile resolutions.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed some section banners still showing after selecting to hide all page headers from the Customizer.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused the members profile photos page header to not have the correct spacing.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that could cause activities from previous filters to show on the activities feed when quickly changing between different filters.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed chat messages not being marked as read when accessing them directly by using the header message notifications dropdown.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Group invitation notifications now have a link to the user "Received Group Invitations" settings page.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a new notification for private group membership requests sent.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a new notification for private group membership request rejections.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Updated the "Vikinger - BuddyPress Extension" plugin to include the new private groups related "Membership Requests" menu. Please update the plugin using the theme installer.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a new field in the group creation and manage popups that allows the user to select the status of the group (public, private).', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a tag sticker that shows the group status on each group box in the manage groups settings screen to help the user know the status of a group without having to open its management popup.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a tag sticker that shows the group status in the group management popup.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a tag sticker that shows the group status on the activity feed and profile group widgets.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added information that indicates the amount of admins, mods, members and banned members the group has in the manage group members tab.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Removed activity post form from all member profiles except own user profile based on user feedback, as it led to confusion.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Removed unused privacy dropdown from activity post forms.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Private Groups', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Added support for BuddyPress private groups. Users can now create private groups which content can only be seen by members of the group.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Private groups have a "Request Membership" button instead of the "Join Group" button that the public groups have. To join a private group, a user has to send a membership request and needs the approval of a member of that group. The membership request can also be canceled by the initiating user or rejected by any member of the private group.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Both membership requests and rejections now feature a specific notification message which links to the new group membership requests settings page. This new page allows to manage membership requests sent to a group and received by any private group the user is a member of.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Existing public groups can be converted to private groups by editing them from the "Manage Groups" settings page, the group manage popup will now have the option to select group status via a dropdown.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Activity Feed Improvements', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('We introduced several improvements related to the activity feed, including activity preloading and removing the need for the feed to reload when adding a new post.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The new activity preloading allows for activities to load faster after the initial load, activities are loaded in the background while browsing and displayed when the user scrolls to view more.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Removing activity list reload when updating the feed to show new posts allows for activity shares to be displayed dynamically when previously a page reload was needed as to not break the flow when the user scrolled and wanted to share something but continue browsing afterwards without having the feed reload. Regular activity posts also benefit from this new behaviour, they will display dynamically and faster after submitting them.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('We also introduced some improvements to the Pin activity functionality, pinned activities are now visible to all users instead of only to the user that made the pin, this allows for the pin functionality to not only be used personally but to highlight a post in a user profile for others to see. Also, users can now only pin an activity in their profile feed page, removing the option incorrectly showing on the main activity feed and other profile activity feeds.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.1.1" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">November 28, 2020</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.1.1</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the "No badges unlocked text" incorrectly showing on the Elementor login register widget when the GamiPress plugin was not active.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused text to not wrap correctly on some element boxes.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that caused users to show in the ranks page when their account was not activated.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed incorrect color being used for the header progress bar underline in the dark purple preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed incorrect color being used for the avatar rank hexagon in the carbon yellow preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Deleting a user will now remove its uploads directory at wp-content/uploads/vikinger/member/member_id, deleting all media uploaded by the user from the server.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Deleting a group will now remove its uploads directory at wp-content/uploads/vikinger/group/group_id, deleting all media uploaded to the group from the server.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added support for BuddyPress notification email settings, this will allow users to opt-out of receiving emails when each action occurs, for example when the user is mentioned in a post. The new settings page can be found under "Account" with the name "Email Settings".', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Updated the "Vikinger - BuddyPress Extension" plugin to include the new "Email Settings" menu. Please update the plugin using the theme installer.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Removed Mentions, Favorites, Friends and Groups tab filters from the main activity feed for logged out users.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added an option in the Customizer that allows to display or hide all page banners from the theme pages. This new option is available in the Vikinger Settings -> Page Headers section.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.1.0" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">November 21, 2020</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.1.0</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed background of activity comment replies not using correct color.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that could cause long strings of text to not wrap correctly on activity posts and comments.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed positioning of the header side menu trigger and menu.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added missing group related translation strings.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added link to homepage to both the header logo and title.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Color Presets', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The new "Color Presets" option allows users to quickly change between several different presets to easily change the look and feel of their site. There is also a "Custom" preset available that uses all colors you have defined for your theme on previous versions, so you can keep your previously defined color configuration!.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('There are a total of 7 presets:', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Custom.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Light.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Dark.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Dark Blue.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Dark Purple.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Dark Cyan.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Carbon Yellow.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('Each preset has its own default colors that give a unique look to the site and each preset colors are completely customizable through the Customizer, so you can use the presets as a base and change only some of its colors if you like to do so.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The new Customizer sections that allow preset and colors customizations are:', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Color Presets.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Colors - Custom Preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Colors - Light Preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Colors - Dark Preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Colors - Dark Blue Preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Colors - Dark Purple Preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Colors - Dark Cyan Preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Colors - Carbon Yellow Preset.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Login and Register', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The login and register process has been revised and improved. The default WordPress login page has been completely styled to match the theme look with a customizable background image, text (can be set to an empty string if you don\'t want to display text over the background image), logo and colors while preserving its default functionality. You can now use this page to allow users to log in to your site or use the forgot password WordPress functionality.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The BuddyPress register and activate pages have been enabled and styled to match the theme look while also removing the header, side menu and footer to adjust it\'s look to match the new login page. These pages use the same customizable background image, text, logo and colors as the login page. You can now use them to allow your users to register to your page and require them to activate their account before they can login.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The header of the theme now includes a Login button instead of the login form, that will send users to the new login page and the mobile bottom bar that allowed register and login has been moved inside the mobile menu to free screen space when browsing the site on lower resolution screens.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('We highly recommend using this new login, register and activation process as it provides more security and options for both the login process, with the forgot password functionality, and the register process, which requires account activation via a key that is sent to the registering user email.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The Elementor landing page can still be used but the login and register Elementor Widget form won\'t provide these functions, we recommend removing the widget using the Elementor editor and using the page as a regular landing page to display any sections you like your site visitors to see!.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('It\'s now also possible to restrict access to the site if the user isn\'t logged in, this feature is disabled by default and can be enabled from the Customizer. If enabled, logged out users will be redirected to the login page if they try to access any page of the theme except the login, register and activate pages.', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- SECTION TEXT -->
    <p class="section-text"><?php esc_html_e('The new Customizer section which allows login and register page customization is:', 'vikinger'); ?></p>
    <!-- /SECTION TEXT -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Vikinger Settings -> Login - Register.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.0.3.1" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">November 17, 2020</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.0.3.1</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that prevented the registration form and popups from being visible on multisite installations.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed header inputs, rank and points text not using the "Header Text - Color" customizer setting.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added "Header Mobile Menu Trigger Icon - Color" to the available colors in the Customizer. This setting controls the mobile menu trigger icon color.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.0.3" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">November 13, 2020</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.0.3</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed a number of styling issues on 720p and below resolutions.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue with the send message link on the friendship activity that is generated when a friendship is created.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that prevented friendships to be working correctly on WordPress Multisite installations.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed header menu sub items arrow not using hover color.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text">
        <?php

          echo wp_kses(
            sprintf(
              esc_html__('Added a child theme, check %sthis link%s for information about what a WordPress child theme is. The child theme is called "vikinger-child" and can be found in the Theme/ directory of the package.', 'vikinger'),
              '<a href="https://developer.wordpress.org/themes/advanced-topics/child-themes/#what-is-a-child-theme" target="_blank">',
              '</a>'
            ),
            vikinger_wp_kses_admin_text_get_allowed_tags()
          );

        ?>
        </p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a Customizer section called "Admin Bar" and an option "Display / Hide" that allows the user to hide the WordPress admin bar (top bar) for all logged in users (except admins). This doesn\'t affect BuddyPress toolbar for logged out users, to hide the bar for logged out users, deactivate BuddyPress Toolbar setting in the  Settings -> BuddyPress -> Options tab.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Improved chat widget loading in the profile settings messages page, now the loading indicator doesn\'t disappear before the messages widget finishes loading.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Clicking on a message on the header messages dropdown now opens that message thread automatically on the profile settings messages screen.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Notifications in the header notifications dropdown and the profile settings notifications page now have more functional links, like a link to the user that triggered the notification and the action related to that notification. For example, the "sent you a message" notification now links to that message thread, the "sent you a friend request" now links to the friend requests page, etc.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added more entries to the theme FAQs and updated old entries to reflect new features.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added support for the "Settings" -> "Reading" -> "Blog pages show at most" WordPress option, the blog posts list will now limit the posts per page shown according to this setting.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added support for the "Settings" -> "BuddyPress" -> "Options" -> "Group Creation" BuddyPress option, this allows users to enable or disable group creation for all users.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added "Header Profile Settings Icon - Color" to the available colors in the Customizer. This setting controls the cog icon color on the right part of the header.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added "Header Text - Color" to the available colors in the Customizer. This setting controls the header site title, menu text and submenu arrows color.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.0.2" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">November 7, 2020</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.0.2</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed user avatar list overflowing on the achievement widgets when many users where displayed.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed a mobile style issue which showed the decorative icons from the credit award and deduct boxes not centered and out of their respective boxes.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed an issue that could cause some images in the user profile timeline photos widget to not display.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed group member preview list overlay not using customizer secondary color.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Moved header register button closer to the login form.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Released a new version of the Vikinger - BuddyPress Extension plugin that adds translatable strings for the wordpress admin bar top right profile related menus. Please update the plugin to the latest version using the theme installer.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added group navigation missing translatable strings.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added error/notice messages to the activity form to allow the user to know the reason a post doesn\'t submit (i.e. when clicking post without entering text or adding an image).', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Made it possible to post activity status updates with only images (no text).', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a new header version with only logo, a new option has been added to the customizer Site Identity section so users can select which header version they want to use.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a new customizer color option in the Vikinger Settings - Colors section to allow users to customize the header logo background color for the new header version (you can set this to the same color as the header to make it invisible).', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a new customizer option in the Footer section to allow users to hide the footer of the site.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added a new section to the customizer called Side Menu, added an option in this new section that allows users to hide the side menu. Hiding the side menu will also hide the side menu trigger that appears on the header of the site.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Customizer changes made by this update:', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->

        <!-- UNORDERED LIST -->
        <ul class="unordered-list">
          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Display Logo and Site Title / Display Logo option in the Site Identity section.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Header Logo - Background option in the Vikinger Settings - Colors section.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Vikinger Settings - Side Menu section.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Display / Hide option in the Vikinger Settings - Side Menu section.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Display / Hide option in the Vikinger Settings - Footer section.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->
        </ul>
        <!-- /UNORDERED LIST -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added FAQs section on the theme options.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added icons and colors for the following social networks in member profile fields (the name for the profile field must be the same as listed below - case insensitive - in order for it to be recognized and assigned it\'s respective icon):', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->

        <!-- UNORDERED LIST -->
        <ul class="unordered-list">
          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Behance.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('DeviantArt.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Dribbble.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Github.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Linkedin.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Pinterest.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Reddit.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Snapchat.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Spotify.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Tiktok.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Tumblr.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Vk.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->
        </ul>
        <!-- /UNORDERED LIST -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->
  </div>
  <!-- /SECTION -->

  <!-- SECTION -->
  <div id="vk-version-1.0.1" class="section section-full">
    <!-- SECTION PRETITLE -->
    <p class="section-pretitle">October 31, 2020</p>
    <!-- /SECTION PRETITLE -->

    <!-- SECTION TITLE -->
    <p class="section-title"><?php esc_html_e('Version', 'vikinger'); ?> 1.0.1</p>
    <!-- /SECTION TITLE -->

    <!-- SECTION TEXT -->
    <p class="section-text">
    <?php

      echo wp_kses(
        sprintf(
          esc_html__('You\'ll find information about this update below. If you want to provide feedback, suggestions or report bugs please contact our support team by using the email provided in the support tab.', 'vikinger'),
          '<a href="https://envato.com/market-plugin/" target="_blank">',
          '</a>',
          '<br><br>',
          '<strong>',
          '</strong>'
        ),
        vikinger_wp_kses_admin_text_get_allowed_tags()
      );

    ?>
    </p>
    <!-- /SECTION TEXT -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('Fixes', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed image stretching when used inside a Group Block in a post.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the activation and registration page being accessible when they shouldn\'t be.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed the upload boxes not showing all accepted image formats by the theme (jpg/jpeg/png/gif).', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed default link icon not showing when creating social links using an unsupported social network.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed more photos link directing to user photos page instead of group photos page when uploading photos to a group through a status update.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed text, box layer and hexagon colors that didn\'t have the correct derived color or user custom color assigned to them when customizing the theme colors.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed single activity stream pages not showing user cover image and stats information.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Fixed credit deducts limit text saying it was an "Award Limit" instead of a "Deduct Limit".', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Features', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Introduced the following changes and additions in the color customization:', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->

        <!-- UNORDERED LIST -->
        <ul class="unordered-list">
          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Header Icon - Hover Color.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Renamed Text to Text - Primary.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Text - Secondary.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Text - Tertiary.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Box - Shadow.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Over Box - Shadow.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Over Box Dark - Shadow.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Over Box Big - Shadow.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Header Progress Bar Line Gradient - Start Color (if you don\'t want to use gradient, just set start and end colors to the same color).', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Header Progress Bar Line Gradient - End Color.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Header Progress Bar Underline - Color.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Progress Bar Line Gradient - Start Color (global, user avatars and achievement progress bars).', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Progress Bar Line Gradient - End Color.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Progress Bar Underline - Color.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Added Avatar Rank Hexagon - Color.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->
        </ul>
        <!-- /UNORDERED LIST -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Replaced quest, credits and group creation decorative images with HTML elements to allow users for better customization when changing theme colors, specially when going for a dark version palette. These elements will now be colored appropiately by using customizer colors.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added support for more profile field types (Checkboxes, Radio Buttons and Drop Down Select Box). Profile field types available with this update:', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->

        <!-- UNORDERED LIST -->
        <ul class="unordered-list">
          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Text Box.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Multi-line Text Area.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('URL.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Date Selector.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Checkboxes.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Radio Buttons.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->

          <!-- UNORDERED LIST ITEM -->
          <li class="unordered-list-item">
            <!-- UNORDERED LIST ITEM TEXT -->
            <p class="unordered-list-item-text"><?php esc_html_e('Drop Down Select Box.', 'vikinger'); ?></p>
            <!-- /UNORDERED LIST ITEM TEXT -->
          </li>
          <!-- /UNORDERED LIST ITEM -->
        </ul>
        <!-- /UNORDERED LIST -->
      </li>
      <!-- /UNORDERED LIST ITEM -->

      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Increased the width of the photo popup box so that images with bigger size display better.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION SUBTITLE -->
    <p class="section-subtitle"><?php esc_html_e('New Illustrations', 'vikinger'); ?></p>
    <!-- /SECTION SUBTITLE -->

    <!-- UNORDERED LIST -->
    <ul class="unordered-list">
      <!-- UNORDERED LIST ITEM -->
      <li class="unordered-list-item">
        <!-- UNORDERED LIST ITEM TEXT -->
        <p class="unordered-list-item-text"><?php esc_html_e('Added new credits and ranks illustrations so you\'ll have more options to choose from. You can find them inside the Illustrations folder in the updated pack.', 'vikinger'); ?></p>
        <!-- /UNORDERED LIST ITEM TEXT -->
      </li>
      <!-- /UNORDERED LIST ITEM -->
    </ul>
    <!-- /UNORDERED LIST -->

    <!-- SECTION IMAGE -->
    <img class="section-image" src="https://imagizer.imageshack.com/img923/3766/PSzcjU.jpg" alt="new-illustrations">
    <!-- /SECTION IMAGE -->
  </div>
  <!-- /SECTION -->
</div>
<!-- /VK CONTENT -->