<?php
/**
 * Vikinger Template Part - Widget Info Group
 * 
 * @package Vikinger
 * @since 1.0.0
 * @author Odin Design Themes (https://odindesignthemes.com/)
 * 
 * @see vikinger_groups_get
 * 
 * @param array $args {
 *   @type array $group     Group data.
 * }
 */

  // Add user register date
  $information_items = [
    [
      'title' => esc_html__('Created', 'vikinger'),
      'type'  => 'text',
      'value' => (new DateTime($args['group']['date_created']))->format('F jS, Y')
    ],
    [
      'title' => esc_html__('Type', 'vikinger'),
      'type'  => 'text',
      'value' => ucfirst($args['group']['status'])
    ]
  ];

  /**
   * Widget Info
   */
  get_template_part('template-part/widget/widget-info', null, [
    'widget_title'      => esc_html__('Group Info', 'vikinger'),
    'widget_text'       => $group['description'],
    'information_items' => $information_items
  ]);

?>