<?php
/**
 * Vikinger Template Part - Widget Info About
 * 
 * @package Vikinger
 * @since 1.0.0
 * @author Odin Design Themes (https://odindesignthemes.com/)
 * 
 * @see vikinger_members_get
 * 
 * @param array $args {
 *   @type array $member     Member data.
 * }
 */

  $user = get_userdata($member['id']);

  // Add user register date
  $information_items = [
    [
      'title' => esc_html__('Joined', 'vikinger'),
      'type'  => 'text',
      'value' => date_i18n(get_option('date_format'), strtotime($user->user_registered))
    ]
  ];

  // get Bio information, except for the About field
  $bio_information = vikinger_members_xprofile_get_group_fields($args['member'], 'Profile_Bio', ['About']);

  // add bio information to the information items to display
  $information_items = array_merge($information_items, $bio_information);

  /**
   * Widget Info
   */
  get_template_part('template-part/widget/widget-info', null, [
    'widget_title'      => esc_html__('About Me', 'vikinger'),
    'widget_text'       => vikinger_members_xprofile_get_field_value($args['member'], 'Profile_Bio_About'),
    'information_items' => $information_items
  ]);

?>