<?php
/**
 * Vikinger Template Part - Dropdown Navigation
 * 
 * @package Vikinger
 * @since 1.0.0
 * @author Odin Design Themes (https://odindesignthemes.com/)
 * 
 * @see vikinger_members_get, vikinger_members_get_settings_navigation_sections
 * 
 * @param array $args {
 *   @type array    $user                   User data.
 *   @type array    $navigation_sections    Navigation sections.
 *   @type string   $modifiers              Optional. Additional class names to add to the HTML wrapper.
 * }
 */

  $modifiers  = isset($args['modifiers']) ? $args['modifiers'] : false;

  $modifiers_classes  = $modifiers ? $modifiers : '';

  global $vikinger_settings;

  $display_verified = vikinger_plugin_bpverifiedmember_is_active();

  $display_verified_in_fullname = $display_verified && $vikinger_settings['bp_verified_member_display_badge_in_profile_fullname'];
  $display_verified_in_username = $display_verified && $vikinger_settings['bp_verified_member_display_badge_in_profile_username'];

  $verified_user = $display_verified && $args['user']['verified'];

?>

<div class="dropdown-navigation <?php echo esc_attr($modifiers_classes); ?>">
  <!-- DROPDOWN NAVIGATION HEADER -->
  <div class="dropdown-navigation-header">
    <!-- USER STATUS -->
    <div class="user-status">
    <?php

      /**
       * Ranked Avatar Small
       */
      get_template_part('template-part/avatar/ranked-avatar', 'small', [
        'user'      => $args['user'],
        'modifiers' => 'user-status-avatar',
        'linked'    => vikinger_plugin_buddypress_is_active(),
        'no_border' => true
      ]);

    ?>
  
      <!-- USER STATUS TITLE -->
      <p class="user-status-title">
        <span class="bold">
        <?php

          printf(esc_html_x('Hi %s!', 'Settings dropdown welcome text', 'vikinger'), $args['user']['name']);

          if ($display_verified_in_fullname && $verified_user) {
            echo $vikinger_settings['bp_verified_member_badge'];
          }

        ?>
        </span>
      </p>
      <!-- /USER STATUS TITLE -->
  
      <!-- USER STATUS TEXT -->
      <p class="user-status-text small">
      <?php

        echo '&#64;' . esc_html($args['user']['mention_name']);

        if ($display_verified_in_username && $verified_user) {
          echo $vikinger_settings['bp_verified_member_badge'];
        }

      ?>
      </p>
      <!-- /USER STATUS TEXT -->
    </div>
    <!-- /USER STATUS -->
  </div>
  <!-- /DROPDOWN NAVIGATION HEADER -->

<?php

  foreach ($args['navigation_sections'] as $navigation_section) {
    /**
     * Dropdown Navigation Section
     */
    get_template_part('template-part/navigation/dropdown-navigation-section', null, [
      'section_name'  => $navigation_section['title'],
      'section_links' => $navigation_section['menu_items']
    ]);
  }

?>
  
  <!-- DROPDOWN NAVIGATION BUTTON -->
  <a class="dropdown-navigation-button button small secondary" href="<?php echo esc_url(wp_logout_url()); ?>"><?php esc_html_e('Logout', 'vikinger'); ?></a>
  <!-- /DROPDOWN NAVIGATION BUTTON -->
</div>