<?php
/**
 * Vikinger Template - Search
 * 
 * @package Vikinger
 * @since 1.0.0
 * @author Odin Design Themes (https://odindesignthemes.com/)
 * 
 */

  get_header();

  $search_query = get_search_query();

?>

<!-- CONTENT GRID -->
<div class="content-grid">
<?php

  $page_header_status = get_theme_mod('vikinger_pageheader_setting_display', 'display');

  if ($page_header_status === 'display') {
    $search_header_icon_id      = get_theme_mod('vikinger_pageheader_search_setting_image', false);
    $search_header_description  = get_theme_mod('vikinger_pageheader_search_setting_description', esc_html_x('Browse your search results', 'Search Page - Description', 'vikinger'));

    if ($search_header_icon_id) {
      $search_header_icon_url = wp_get_attachment_image_src($search_header_icon_id , 'full')[0];
    } else {
      $search_header_icon_url = vikinger_customizer_search_page_image_get_default();
    }

    /**
     * Section Banner
     */
    get_template_part('template-part/section/section', 'banner', [
      'section_icon_url'    => $search_header_icon_url,
      'section_title'       => esc_html_x('Search Results', 'Search Page - Title', 'vikinger') . ': "' . $search_query . '"',
      'section_description' => $search_header_description
    ]);
  }

  // add BuddyPress member search data if BuddyPress is active
  if (vikinger_plugin_buddypress_is_active()) :
    /**
     * Section Header
     */
    get_template_part('template-part/section/section', 'header', [
      'section_pretitle'  => esc_html__('Browse', 'vikinger'),
      'section_title'     => esc_html__('Members', 'vikinger')
    ]);

?>
  <!-- MEMBER FILTERABLE LIST -->
  <div id="member-filterable-list" class="filterable-list" data-searchterm="<?php echo esc_attr($search_query); ?>"></div>
  <!-- /MEMBER FILTERABLE LIST -->
<?php

  endif;

  // add BuddyPress group search data if BuddyPress and the groups component are active
  if (vikinger_plugin_buddypress_is_active() && bp_is_active('groups')) :
    /**
     * Section Header
     */
    get_template_part('template-part/section/section', 'header', [
      'section_pretitle'  => esc_html__('Browse', 'vikinger'),
      'section_title'     => esc_html__('Groups', 'vikinger')
    ]);

?>
  <!-- GROUP FILTERABLE LIST -->
  <div id="group-filterable-list" class="filterable-list" data-searchterm="<?php echo esc_attr($search_query); ?>"></div>
  <!-- /GROUP FILTERABLE LIST -->
<?php

  endif;

  /**
   * Section Header
   */
  get_template_part('template-part/section/section', 'header', [
    'section_pretitle'  => esc_html__('Browse', 'vikinger'),
    'section_title'     => esc_html__('Posts', 'vikinger')
  ]);

?>
  <!-- POST PREVIEW FILTERABLE LIST -->
  <div id="post-preview-filterable-list" class="filterable-list" data-searchterm="<?php echo esc_attr($search_query); ?>"></div>
  <!-- /POST PREVIEW FILTERABLE LIST -->
</div>
<!-- /CONTENT GRID -->

<?php get_footer(); ?>