const React = require('react');

const RankedAvatar = require('../avatar/RankedAvatar');

class UserPreview extends React.Component {
  constructor(props) {
    super(props);
  }

  render() {
    return (
      <div className="user-preview small fixed-height">
        {/* USER PREVIEW COVER */}
        <div className="user-preview-cover" style={{background: `url('${this.props.data.cover_url}') center center /  cover no-repeat`}}></div>
        {/* USER PREVIEW COVER */}
      
        {/* USER PREVIEW INFO */}
        <div className="user-preview-info">
          <div className="user-short-description small">
            <RankedAvatar data={this.props.data}
                          modifiers="user-short-description-avatar"
                          noLink
            />
          </div>
        </div>
        {/* USER PREVIEW INFO */}
      </div>
    );
  }
}

module.exports = UserPreview;