const React = require('react');

const HexagonBorder_120_130 = require('../hexagon/HexagonBorder_120_130'),
      HexagonImage_82_90 = require('../hexagon/HexagonImage_82_90'),
      HexagonProgress_100_110 = require('../hexagon/HexagonProgress_100_110'),
      HexagonProgressBorder_100_110 = require('../hexagon/HexagonProgressBorder_100_110'),
      HexagonBadge_26_28 = require('../hexagon/HexagonBadge_26_28'),
      HexagonBadgeBorder_32_36 = require('../hexagon/HexagonBadgeBorder_32_36');

class RankedAvatarMedium extends React.Component {
  constructor(props) {
    super(props);
  }

  render() {
    const Element = this.props.noLink || !vikinger_constants.plugin_active.buddypress ? 'div' : 'a';
    
    return (
      <Element  className={`user-avatar medium ${this.props.noBorder ? 'no-outline' : ''} ${this.props.modifiers || ''}`}
                {...(!this.props.noLink ? { href: this.props.data.link } : {})}
      >
        {
          !this.props.noBorder &&
            <HexagonBorder_120_130 />
        }
        <HexagonImage_82_90 imageURL={this.props.data.avatar_url} />
        <HexagonProgress_100_110 data={this.props.data.rank} />
        <HexagonProgressBorder_100_110 />
        <div className="user-avatar-badge">
          <HexagonBadgeBorder_32_36 />
          <HexagonBadge_26_28 />
          <p className="user-avatar-badge-text">{this.props.data.rank.current}</p>
        </div>
      </Element>
    );
  }
}

module.exports = RankedAvatarMedium;