const React = require('react');

const HexagonBorder_100_110 = require('../hexagon/HexagonBorder_100_110'),
      HexagonImage_68_74 = require('../hexagon/HexagonImage_68_74'),
      HexagonProgress_84_92 = require('../hexagon/HexagonProgress_84_92'),
      HexagonProgressBorder_84_92 = require('../hexagon/HexagonProgressBorder_84_92'),
      HexagonBadge_22_24 = require('../hexagon/HexagonBadge_22_24'),
      HexagonBadgeBorder_28_32 = require('../hexagon/HexagonBadgeBorder_28_32');

class RankedAvatar extends React.Component {
  constructor(props) {
    super(props);
  }

  render() {
    const Element = this.props.noLink || !vikinger_constants.plugin_active.buddypress ? 'div' : 'a';
    
    return (
      <Element  className={`user-avatar ${this.props.noBorder ? 'no-outline' : ''} ${this.props.modifiers || ''}`}
                {...(!this.props.noLink ? { href: this.props.data.link } : {})}
      >
        {
          !this.props.noBorder &&
            <HexagonBorder_100_110 />
        }
        <HexagonImage_68_74 imageURL={this.props.data.avatar_url} />
        <HexagonProgress_84_92 data={this.props.data.rank} />
        <HexagonProgressBorder_84_92 />
        <div className="user-avatar-badge">
          <HexagonBadgeBorder_28_32 />
          <HexagonBadge_22_24 />
          <p className="user-avatar-badge-text">{this.props.data.rank.current}</p>
        </div>
      </Element>
    );
  }
}

module.exports = RankedAvatar;