const React = require('react'),
      ReactDOM = require('react-dom');

const ActivityMediaList = require('../../component/activity/ActivityMediaList');

const activityMediaListElement = document.querySelector('#activity-media-list');

if (activityMediaListElement) {
  const userID = Number.parseInt(activityMediaListElement.getAttribute('data-userid'), 10) || false,
        groupID = Number.parseInt(activityMediaListElement.getAttribute('data-groupid'), 10) || false,
        order = 'DESC';

  ReactDOM.render(
    <ActivityMediaList  userID={userID}
                        groupID={groupID}
                        perPage={24}
                        order={order}
    />,
    activityMediaListElement
  );
}