const React = require('react'),
      ReactDOM = require('react-dom');

const GroupMemberFilterableList = require('../../component/filter/GroupMemberFilterableList');

const groupMemberFilterableListElement = document.querySelector('#group-members-filterable-list');

if (groupMemberFilterableListElement) {
  const themeColor = groupMemberFilterableListElement.getAttribute('data-themecolor') || false,
        groupID = Number.parseInt(groupMemberFilterableListElement.getAttribute('data-groupid'), 10) || false,
        searchTerm = groupMemberFilterableListElement.getAttribute('data-searchterm') || false;

  ReactDOM.render(
    <GroupMemberFilterableList  itemsPerPage={12}
                                themeColor={themeColor}
                                groupID={groupID}
                                searchTerm={searchTerm}
    />,
    groupMemberFilterableListElement
  );
}