/*-------------
    SIDEBAR 
-------------*/
require('./sidebar/sidebar');

/*------------
    SVG 
------------*/
require('./utils/svg-loader');

/*----------------
    SCROLLBARS 
----------------*/
require('simplebar');

/*------------
    FORM
------------*/
require('./form/form-input');
require('./form/form-login');
require('./form/form-register');

/*--------------
    GLOBAL
--------------*/
require('./global/color-theme-toggle');
require('./global/smooth-scroll');
require('./global/sliders');
require('./global/progressBars');
require('./global/hexagons');
require('./global/popups');
require('./global/dropdowns');
require('./global/tab');
require('./global/tooltips');
require('./global/accordions');
require('./global/forum');
require('./global/user-delete');

/*--------------------------------------------------------------------
                        COMPONENT DOM
--------------------------------------------------------------------*/
/*-----------------------
    LOGIN FORM POPUP
-----------------------*/
require('./component-dom/login/login-form-popup');

/*-----------------------
    SEARCH FORM
-----------------------*/
require('./component-dom/search/search-form');

/*---------------------------
    HEADER NOTIFICATIONS
---------------------------*/
require('./component-dom/header/header-notifications');

/*---------------------------
    COMMENT LIST
---------------------------*/
require('./component-dom/comments/comment-list');

/*---------------------------
    POST PREVIEW LIST
---------------------------*/
require('./component-dom/posts/post-preview-list');

/*---------------------------
    MEMBER LIST
---------------------------*/
require('./component-dom/members/members-list');

/*---------------------------
    GROUP LIST
---------------------------*/
require('./component-dom/groups/groups-list');
require('./component-dom/groups/group-members-list');

/*---------------------------
    MEMBER HEADER ACTIONS
---------------------------*/
require('./component-dom/members/profile-header-actions');

/*---------------------------
    GROUP HEADER ACTIONS
---------------------------*/
require('./component-dom/groups/group-header-actions');

/*---------------------------
    ACTIVITY LIST
---------------------------*/
require('./component-dom/activity/list-activities');

/*---------------------------
    MEDIA LIST
---------------------------*/
require('./component-dom/media/media-list');

/*---------------------------
    WIDGETS
---------------------------*/
require('./component-dom/widget/widget-friends');
require('./component-dom/widget/widget-members');
require('./component-dom/widget/widget-group-members');
require('./component-dom/widget/widget-groups');
require('./component-dom/widget/widget-photos');

/*-----------------------
    ACCOUNT HUB
-----------------------*/
require('./component-dom/settings/settings-profile');
require('./component-dom/settings/settings-social');
require('./component-dom/settings/settings-notifications');
require('./component-dom/settings/settings-messages');
require('./component-dom/settings/settings-friend-requests');

require('./component-dom/settings/settings-account-info');
require('./component-dom/settings/settings-password');
require('./component-dom/settings/settings-email-settings');

require('./component-dom/settings/settings-manage-groups');
require('./component-dom/settings/settings-send-group-invitations');
require('./component-dom/settings/settings-received-group-invitations');
require('./component-dom/settings/settings-group-membership-requests');

/*-----------------
    PAGE LOADER 
-----------------*/
require('./global/page-loader');