const React = require('react');

const TableItemStatus = require('./TableItemStatus'),
      LoaderSpinnerSmall = require('../loader/LoaderSpinnerSmall');

class TableRow extends React.Component {
  constructor(props) {
    super(props);
  }

  render() {
    let checkListItemStatusType = 'error';

    if (this.props.pluginsData.installed && this.props.pluginsData.updated && this.props.pluginsData.active) {
      checkListItemStatusType = 'success';
    }

    return (
      <div className="vk-table-row">
      {
        this.props.data.map((data, i) => {
          return (
            <div key={i} className="vk-table-cell">
              <p className="vk-table-cell-text">{data.text}</p>
            </div>
          );
        })
      }
      <div className="vk-table-cell">
      {
        this.props.processing &&
          <LoaderSpinnerSmall />
      }
      {
        !this.props.processing &&
          <TableItemStatus type={checkListItemStatusType} />
      }
      </div>
      </div>
    );
  }
}

module.exports = TableRow;