const React = require('react');

const app = require('../../../utils/core');

const Table = require('../table/Table'),
      LoaderSpinner = require('../loader/LoaderSpinner'),
      LoaderSpinnerSmall = require('../loader/LoaderSpinnerSmall');

const Pluginner = require('../utils/plugin')();

class RequirePluginList extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      requiredPlugins: [],
      processingPlugin: [],
      loading: true,
      processing: false
    };

    this.remediateMissingPlugins = this.remediateMissingPlugins.bind(this);
  }

  getRequiredPlugins() {
    const requiredPluginsPromise = Pluginner.getRequiredPlugins();

    requiredPluginsPromise
    .done((response) => {
      // console.log('REQUIRED PLUGIN LIST - GET REQUIRED PLUGINS RESPONSE: ', response);

      this.setState({
        requiredPlugins: response,
        processingPlugin: (new Array(response.length)).fill(false),
        loading: false
      });
    })
    .fail((error) => {
      // console.log('REQUIRED PLUGIN LIST - GET REQUIRED PLUGINS ERROR: ', error);
    });
  }

  remediatePlugin(plugins, i, callback = () => {}) {
    const plugin = plugins[i];

    // console.log('REQUIRED PLUGIN LIST - REMEDIATE PLUGIN: ', plugin, i);
    
    // if plugin not installed, updated or active
    if (!plugin.installed || !plugin.updated || !plugin.active) {
      // show processing plugin loader
      this.setState((state, props) => {
        const processingPlugin = state.processingPlugin.slice();

        processingPlugin[i] = true;

        return {
          processingPlugin: processingPlugin
        };
      });

      // plugin not installed, install and activate it
      if (!plugin.installed) {
        // console.log('REQUIRED PLUGIN LIST - PLUGIN NOT INSTALLED: ', plugin, i);

        const installPluginPromise = Pluginner.installAndActivatePlugin(plugin.plugin_name);

        installPluginPromise
        .done((response) => {
          // console.log('REQUIRED PLUGIN LIST - INSTALL PLUGIN RESPONSE: ', response);

          if (response) {
            this.setState((state, props) => {
              const newRequiredPlugins = [];

              app.deepExtend(newRequiredPlugins, state.requiredPlugins);

              for (const requiredPlugin of newRequiredPlugins) {
                if (requiredPlugin.slug === plugin.slug) {
                  requiredPlugin.current_version = requiredPlugin.latest_version;
                  requiredPlugin.installed = true;
                  requiredPlugin.updated = true;
                  requiredPlugin.active = true;
                }
              }

              // console.log('REQUIRED PLUGIN LIST - NEW REQUIRED PLUGINS: ', newRequiredPlugins);

              return {
                requiredPlugins: newRequiredPlugins
              };
            });
          }
        })
        .always(() => {
          // done processing
          this.setState((state, props) => {
            const processingPlugin = state.processingPlugin.slice();

            processingPlugin[i] = false;

            // console.log('REQUIRED PLUGIN LIST - INSTALL PLUGIN DONE PROCESSING: ', plugin, i);

            return {
              processingPlugin: processingPlugin
            };
          });

          // process next
          if (i < plugins.length - 1) {
            this.remediatePlugin(plugins, i + 1, callback)
          } else {
          // finish processing
            callback();
          }
        });

      } else if (!plugin.updated) {
      // plugin not updated, update and activate it
        // console.log('REQUIRED PLUGIN LIST - PLUGIN NOT UPDATED: ', plugin, i);

        const updatePluginPromise = Pluginner.updateAndActivatePlugin(plugin.plugin_name);

        updatePluginPromise
        .done((response) => {
          // console.log('REQUIRED PLUGIN LIST - UPDATE PLUGIN RESPONSE: ', response);

          if (response) {
            this.setState((state, props) => {
              const newRequiredPlugins = [];

              app.deepExtend(newRequiredPlugins, state.requiredPlugins);

              for (const requiredPlugin of newRequiredPlugins) {
                if (requiredPlugin.slug === plugin.slug) {
                  requiredPlugin.current_version = requiredPlugin.latest_version;
                  requiredPlugin.updated = true;
                  requiredPlugin.active = true;
                }
              }

              // console.log('REQUIRED PLUGIN LIST - NEW REQUIRED PLUGINS: ', newRequiredPlugins);

              return {
                requiredPlugins: newRequiredPlugins
              };
            });
          }
        })
        .always(() => {
          // done processing
          this.setState((state, props) => {
            const processingPlugin = state.processingPlugin.slice();

            processingPlugin[i] = false;

            // console.log('REQUIRED PLUGIN LIST - UPDATE PLUGIN DONE PROCESSING: ', plugin, i);

            return {
              processingPlugin: processingPlugin
            };
          });

          // process next
          if (i < plugins.length - 1) {
            this.remediatePlugin(plugins, i + 1, callback)
          } else {
          // finish processing
            callback();
          }
        });
      } else if (!plugin.active) {
      // plugin not active, activate it
        // console.log('REQUIRED PLUGIN LIST - PLUGIN NOT ACTIVE: ', plugin, i);

        const activatePluginPromise = Pluginner.activatePlugin(plugin.slug);

        activatePluginPromise
        .done((response) => {
          // console.log('REQUIRED PLUGIN LIST - ACTIVATE PLUGIN RESPONSE: ', response);

          if (response) {
            this.setState((state, props) => {
              const newRequiredPlugins = [];

              app.deepExtend(newRequiredPlugins, state.requiredPlugins);

              for (const requiredPlugin of newRequiredPlugins) {
                if (requiredPlugin.slug === plugin.slug) {
                  requiredPlugin.active = true;
                }
              }

              // console.log('REQUIRED PLUGIN LIST - NEW REQUIRED PLUGINS: ', newRequiredPlugins);

              return {
                requiredPlugins: newRequiredPlugins
              };
            });
          }
        })
        .always(() => {
          // done processing
          this.setState((state, props) => {
            const processingPlugin = state.processingPlugin.slice();

            processingPlugin[i] = false;

            // console.log('REQUIRED PLUGIN LIST - ACTIVATE PLUGIN DONE PROCESSING: ', plugin, i);

            return {
              processingPlugin: processingPlugin
            };
          });

          // process next
          if (i < plugins.length - 1) {
            this.remediatePlugin(plugins, i + 1, callback)
          } else {
          // finish processing
            callback();
          }
        });
      }
    } else {
    // plugin installed, updated and active
      // process next
      if (i < plugins.length - 1) {
        this.remediatePlugin(plugins, i + 1, callback);
      } else {
      // finish processing
        callback();
      }
    }
  }

  remediatePlugins(plugins, callback = () => {}) {
    this.remediatePlugin(plugins, 0, callback);
  }

  remediateMissingPlugins() {
    // if already processing, return
    if (this.state.processing) {
      return;
    }

    this.setState({
      processing: true
    });

    const requiredPlugins = this.state.requiredPlugins.slice();

    // process plugins sequentially, one by one
    this.remediatePlugins(requiredPlugins, () => {
      // console.log('REQUIRED PLUGIN LIST - REMEDIATE PLUGINS CALLBACK');

      window.location = window.location;
    });
  }

  requiredPluginMissing() {
    return this.state.requiredPlugins.some(requiredPlugin => !requiredPlugin.installed || !requiredPlugin.updated || !requiredPlugin.active);
  }

  componentDidMount() {
    this.getRequiredPlugins();
  }

  render() {
    const rowData = [];

    for (const plugin of this.state.requiredPlugins) {
      rowData.push(
        [
          {
            text: plugin.name
          },
          {
            text: plugin.installed && plugin.active ? plugin.current_version : '-'
          },
          {
            text: plugin.latest_version
          }
        ]
      );
    }

    return (
      <React.Fragment>
      {
        this.state.loading &&
          <LoaderSpinner />
      }
      {
        !this.state.loading &&
          <React.Fragment>
            <Table  headerData={[{text: 'Plugin'}, {text: 'Installed Version'}, {text: 'Latest Version'}]}
                    rowData={rowData}
                    pluginsData={this.state.requiredPlugins}
                    processingPlugin={this.state.processingPlugin}
            />

          {
            this.requiredPluginMissing() &&
              <div className="button short primary" onClick={this.remediateMissingPlugins}>
              {
                this.state.processing &&
                  <React.Fragment>
                    {vikinger_translation.processing}
                    <LoaderSpinnerSmall />
                  </React.Fragment>
              }
              {
                !this.state.processing &&
                  vikinger_translation.required_plugins_install_button_text
              }
              </div>
          }

          {
            !this.requiredPluginMissing() && this.state.processing &&
              <div className="button short primary">
                {vikinger_translation.processing}
                <LoaderSpinnerSmall />
              </div>
          }
          </React.Fragment>
      }
      </React.Fragment>
    );
  }
}

module.exports = RequirePluginList;