<?php
/**
 * Vikinger SETTINGS functions
 * 
 * @since 1.3.3
 */

/**
 * Returns vikinger theme settings.
 * 
 * @return array $settings      All settings.
 */
function vikinger_settings_get() {
  $settings = [
    /**
     * WordPress
     */
    'users_can_register'          => is_multisite() ? in_array(get_site_option('registration', false), ['all', 'user']) : get_option('users_can_register') === '1',
    'posts_per_page'              => get_option('posts_per_page'),
    'current_user_is_admin'       => current_user_can('administrator'),
    /**
     * Vikinger
     */
    'sidemenu_status' => get_theme_mod('vikinger_sidemenu_setting_display', 'display'),

    'newsfeed_yt_playback_limit'  => get_theme_mod('vikinger_newsfeed_setting_yt_playback_limit', 'no'),

    'activity_show_more_status'        => get_theme_mod('vikinger_activity_setting_show_more_status', 'enabled'),
    'activity_show_more_height'        => get_theme_mod('vikinger_activity_setting_show_more_height', 1000),
    'activity_character_limit'         => get_theme_mod('vikinger_activity_setting_character_limit', 1000),
    'activity_comment_character_limit' => get_theme_mod('vikinger_activity_setting_comment_character_limit', 500),

    'footer_status' => get_theme_mod('vikinger_footer_setting_display', 'display')
  ];

  // add BuddyPress related options if BuddyPress plugin is active
  if (vikinger_plugin_buddypress_is_active()) {
    $settings['bp_restrict_group_creation'] = (bool) bp_get_option('bp_restrict_group_creation', false);

    // add bbPress related options if both BuddyPress and bbPress are active
    if (vikinger_plugin_bbpress_is_active()) {
      $settings['bbp_is_group_forums_active'] = bbp_is_group_forums_active();
    }
  }

  // add Verified Member for BuddyPress related options if plugin is active
  if (vikinger_plugin_bpverifiedmember_is_active()) {
    $settings['bp_verified_member_badge'] = vikinger_bpverifiedmember_badge_get();

    $settings = array_merge($settings, vikinger_bpverifiedmember_settings_get());
  }

  return $settings;
}

/**
 * Check if a members profile page is enabled
 * 
 * @param string $page      Page name.
 * @return bool True if members profile about page is enabled, false otherwise.
 */
function vikinger_settings_members_profile_page_is_enabled($page) {
  return get_theme_mod('vikinger_members_setting_profile_' . $page . '_page_status', 'enabled') === 'enabled';
}

?>