<?php
/**
 * Vikinger USER AJAX
 * 
 * @since 1.0.0
 */

/**
 * Update user metadata
 */
function vikinger_user_meta_update_ajax() {
  // nonce check, dies early if the nonce cannot be verified
  check_ajax_referer('vikinger_ajax');
  
  $result = vikinger_user_meta_update($_POST['args']['user_id'], $_POST['args']['metadata']);

  header('Content-Type: application/json');
  
  echo json_encode($result);

  wp_die();
}

add_action('wp_ajax_vikinger_user_meta_update_ajax', 'vikinger_user_meta_update_ajax');

/**
 * Toggle logged user color theme
 */
function vikinger_logged_user_color_theme_toggle_ajax() {
  // nonce check, dies early if the nonce cannot be verified
  check_ajax_referer('vikinger_ajax');
  
  $result = vikinger_logged_user_color_theme_toggle();

  header('Content-Type: application/json');
  
  echo json_encode($result);

  wp_die();
}

add_action('wp_ajax_vikinger_logged_user_color_theme_toggle_ajax', 'vikinger_logged_user_color_theme_toggle_ajax');

/**
 * Delete logged user account
 */
function vikinger_logged_user_delete_account_ajax() {
  // nonce check, dies early if the nonce cannot be verified
  check_ajax_referer('vikinger_ajax');
  
  $result = vikinger_logged_user_delete_account();

  header('Content-Type: application/json');
  
  echo json_encode($result);

  wp_die();
}

add_action('wp_ajax_vikinger_logged_user_delete_account_ajax', 'vikinger_logged_user_delete_account_ajax');

?>