<?php
/**
 * Vikinger PLUGIN AJAX
 * 
 * @since 1.0.0
 */

/**
 * Returns required plugins status. 
 */
function vikinger_plugin_get_required_plugins_status_ajax() {
  // nonce check, dies early if the nonce cannot be verified
  check_ajax_referer('vikinger_admin_ajax');

  $result = vikinger_plugin_get_required_plugins_status();

  header('Content-Type: application/json');
  echo json_encode($result);

  wp_die();
}

add_action('wp_ajax_vikinger_plugin_get_required_plugins_status_ajax', 'vikinger_plugin_get_required_plugins_status_ajax');

/**
 * Install and activate plugin.
 */
function vikinger_plugin_install_and_activate_ajax() {
  // nonce check, dies early if the nonce cannot be verified
  check_ajax_referer('vikinger_admin_ajax');
  
  $result = vikinger_plugin_install_and_activate($_POST['plugin_name']);

  header('Content-Type: application/json');
  echo json_encode($result);

  wp_die();
}

add_action('wp_ajax_vikinger_plugin_install_and_activate_ajax', 'vikinger_plugin_install_and_activate_ajax');

/**
 * Update and activate plugin.
 */
function vikinger_plugin_update_and_activate_ajax() {
  // nonce check, dies early if the nonce cannot be verified
  check_ajax_referer('vikinger_admin_ajax');

  $result = vikinger_plugin_update_and_activate($_POST['plugin_name']);

  header('Content-Type: application/json');
  echo json_encode($result);

  wp_die();
}

add_action('wp_ajax_vikinger_plugin_update_and_activate_ajax', 'vikinger_plugin_update_and_activate_ajax');

/**
 * Activate a plugin.
 */
function vikinger_plugin_activate_ajax() {
  // nonce check, dies early if the nonce cannot be verified
  check_ajax_referer('vikinger_admin_ajax');

  $result = vikinger_plugin_activate($_POST['plugin_slug']);

  header('Content-Type: application/json');
  echo json_encode($result);

  wp_die();
}

add_action('wp_ajax_vikinger_plugin_activate_ajax', 'vikinger_plugin_activate_ajax');

?>