# Contributing

If you are interested in making a contribution there are a few ways you could help out the project.

## Filing issues

[GitHub Issues](https://github.com/fluid-player/fluid-player/issues) are used for all discussions around the codebase, including **bugs** and **features**.

### Reporting a Bug

Good bug reports can be very helpful. A bug is a demonstrable problem with the code.

Guidelines for bug reports:

1. Please use the [GitHub issue search](https://github.com/fluid-player/fluid-player/issues) — check if the issue has already been reported.
1. Check if the issue has already been fixed — try to reproduce it using the uncompressed code from latest `master` branch in the repository.
1. Create a small demo with the live example (reduced test case). You can possibly use [this codepen template](https://codepen.io/exads/pen/MdgbVj?editors=1010#0) as a starting point -- don't forget to update it to the fluid-player version you use.

A good bug report should be as detailed as possible, so that others won't have to follow up for the essential details.

**[File a bug report](https://github.com/fluid-player/fluid-player/issues/new)**

### Requesting a Feature

1. [Search the issues](https://github.com/fluid-player/fluid-player/issues) for any previous requests for the same feature, and give a thumbs up or +1 on existing requests.
1. If no previous requests exist, create a new issue. Please be as clear as possible about why the feature is needed and the intended use case.

**[Request a feature](https://github.com/fluid-player/fluid-player/issues/new)**

## Contributing code

If you plan to propose a major new feature, or the contribution requires significant or breaking code changes
it is recommended that you create an issue [issue](https://github.com/fluid-player/fluid-player/issues/new) with
a brief proposal (as described in Requesting a Feature) and discuss it with us first.

For smaller contributions just use this workflow:

* Fork the project.
* Create a branch for your feature or bug fix.
* Add code changes.
* Please apply changes only to the uncompressed versions of the files, for example only to fluidplayer.js and not to fluidplayer.min.js (these files will be generated by us before release)
* All new features or changes to the player settings or interface have to be documented in the [docs repo](https://github.com/fluid-player/fluid-player-docs), so that they are displayed on [https://docs.fluidplayer.com](https://docs.fluidplayer.com).
If you have made changes like this, please fork fluid-player-docs as well and create a branch with the same name as the feature branch, adding necessary changes to documentation.
* Send a pull request (both for fluid-player and fluid-player-docs)

After one of the contributors has checked and approved the changes, they will be merged into master branch and will be included in the next release tag.