<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

$hero_class = array('hero-block');
$hero_class[] = 'bg-soft-black';

$blog_main = array('blog-block-single');
$blog_main[] = 'blog-single-spacing';

if( victim_header_transparent() !== '' ) {
    $hero_class[] = victim_header_transparent();
    $blog_main[] = victim_header_transparent();
} 

$post_content_class = array();
$sidebar_content_class = array();
$post_content_class[] = 'blog-single-page';
$sidebar_content_class = array();

if(  !is_active_sidebar( 'woo_sidebar' ) || Victim_Utility::theme_options('woo_sidebar_dispay') == 'full'  ) {
    $post_content_class[] = 'col-lg-12 full-content';
} elseif(  Victim_Utility::theme_options('woo_sidebar_dispay') == 'left' ) {
    $post_content_class[] = 'col-lg-9 order-last layout-content';
    $sidebar_content_class[] = 'col-lg-3 order-first layout-sidebar';
} else {
    $post_content_class[] = 'col-lg-9 layout-content';
    $sidebar_content_class[] = 'col-lg-3 layout-sidebar';
} ?>
<!-- Hero Block
================================================== -->
<section class="<?php echo esc_attr( join(' ',$hero_class) ); ?>" style="background-image: url(<?php echo esc_url( get_header_image() ); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="pd-t-120 pd-b-120">
                	<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                		<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
                	<?php endif; ?>
                	<?php

                	/**
                	 * Hook: woocommerce_before_main_content.
                	 *
                	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                	 * @hooked woocommerce_breadcrumb - 20
                	 * @hooked WC_Structured_Data::generate_website_data() - 30
                	 */
                	do_action( 'woocommerce_before_main_content' ); ?>
                </div>
            </div><!--  /.col-md-12 -->
        </div><!--  /.row -->
    </div><!--  /.container -->
</section><!--  /.hero-block -->

<div id="main" class="<?php echo esc_attr( join(' ',$blog_main) ); ?>"<?php victim_schema_markup('main') ?>>
	<div class="container">
		<div class="row">
			<div class="<?php echo esc_attr( join(' ',$post_content_class) ); ?>">
				<header class="woocommerce-products-header">
					<?php
					/**
					 * Hook: woocommerce_archive_description.
					 *
					 * @hooked woocommerce_taxonomy_archive_description - 10
					 * @hooked woocommerce_product_archive_description - 10
					 */
					do_action( 'woocommerce_archive_description' );
					?>
				</header>

				<?php
				if ( woocommerce_product_loop() ) {

					/**
					 * Hook: woocommerce_before_shop_loop.
					 *
					 * @hooked woocommerce_output_all_notices - 10
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */
					do_action( 'woocommerce_before_shop_loop' );

					woocommerce_product_loop_start();

					if ( wc_get_loop_prop( 'total' ) ) {
						while ( have_posts() ) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 */
							do_action( 'woocommerce_shop_loop' );

							wc_get_template_part( 'content', 'product' );
						}
					}

					woocommerce_product_loop_end();

					/**
					 * Hook: woocommerce_after_shop_loop.
					 *
					 * @hooked woocommerce_pagination - 10
					 */
					do_action( 'woocommerce_after_shop_loop' );
				} else {
					/**
					 * Hook: woocommerce_no_products_found.
					 *
					 * @hooked wc_no_products_found - 10
					 */
					do_action( 'woocommerce_no_products_found' );
				} ?>

			</div>
			<?php 
				if( Victim_Utility::theme_options('woo_sidebar_dispay') !=='full' || is_active_sidebar( "woo_sidebar" ) ) { ?>
				<div class="<?php echo esc_attr( join(' ',$sidebar_content_class) ); ?>"<?php victim_schema_markup('sidebar') ?>>
					<div class="sidebar-block">
				    <?php dynamic_sidebar( 'woo_sidebar' ); ?>
					</div><!--  /.sidebar-block -->
				</div><!-- /.col-lg-4 -->
				<?php }
			?>
		</div><!--  /.row -->
	</div><!--  /.container -->
</div>

<?php 
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' ); 
?>


<?php
get_footer( 'shop' );