<?php
/**
 * Single Post Content
 *
 * @package Victim
 * @since 1.0
 */
$hero_class = array('hero-block');
$hero_class[] = 'bg-soft-black';

$blog_main = array('blog-block-single');
$blog_main[] = 'blog-single-spacing';

if( victim_header_transparent() !== '' ) {
    $hero_class[] = victim_header_transparent();
    $blog_main[] = victim_header_transparent();
} 

$post_content_class = array('col-lg-9');
$post_content_class[] = 'blog-single-page';

$sidebar_content_class = array();
$meta_post_option = Victim_Utility::meta_options('sidebar_position');

if( isset($meta_post_option) && ( $meta_post_option != '' && $meta_post_option != 'default' ) ) {
    if( $meta_post_option == 'full' ) {
        $post_content_class[] = 'full-content';
    } 
    if( $meta_post_option == 'left' ) {
        $post_content_class[] = 'order-last layout-content';

        $sidebar_content_class = array('col-lg-3');
        $sidebar_content_class[] = 'order-first layout-sidebar';
    } 
    if( $meta_post_option == 'right' ) {
        $post_content_class[] = 'layout-content';

        $sidebar_content_class = array('col-lg-3');
        $sidebar_content_class[] = 'layout-sidebar';
    }
} else {
    if(  !is_active_sidebar( 'sidebar-single' ) || Victim_Utility::theme_options('blog_single_sidebar_dispay') == 'full'  ) {
        $post_content_class[] = 'full-content';
    } elseif(  Victim_Utility::theme_options('blog_single_sidebar_dispay') == 'left' ) {
        $post_content_class[] = 'order-last layout-content';

        $sidebar_content_class = array('col-lg-3');
        $sidebar_content_class[] = 'order-first layout-sidebar';
    } else {
        $post_content_class[] = 'layout-content';

        $sidebar_content_class = array('col-lg-3');
        $sidebar_content_class[] = 'layout-sidebar';
    }
}

$post_thumb = array('post-thumb');
if( Victim_Utility::theme_options('blog_single_sidebar_dispay') == 'full' || !is_active_sidebar( "sidebar-single" ) ) {
    if( Victim_Utility::theme_options('feature_images_status') == 'wide' ) {
        $post_thumb[] = 'alignwide';
    } elseif( Victim_Utility::theme_options('feature_images_status') == 'full' ) {
        $post_thumb[] = 'alignfull';
    }
} ?>

<!-- Hero Block
================================================== -->
<section class="<?php echo esc_attr( join(' ',$hero_class) ); ?>" style="background-image: url(<?php echo esc_url( get_header_image() ); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="pd-t-150 pd-b-150"></div>
            </div><!--  /.col-md-12 -->
        </div><!--  /.row -->
    </div><!--  /.container -->
</section><!--  /.hero-block -->

<!-- Blog Page Block
================================================== -->
<div id="main" class="<?php echo esc_attr( join(' ',$blog_main) ); ?>"<?php victim_schema_markup('main') ?>>
    <div class="container">
        <!-- Content Row -->
        <div class="row">
            <div class="<?php echo esc_attr( join(' ',$post_content_class) ); ?>">
                <?php foreach (victim_single_blog_sections_positioning() as $elements ) { ?>
                    <?php if( 'blog_content' ==  $elements ) { ?>                
                        <!-- Blog Items -->
                        <?php while ( have_posts() ) : the_post(); ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
                            <div class="grid-layout">
                                <?php foreach (victim_single_blog_positioning() as $elements ) { ?>
                                    <?php if( 'featured_image' == $elements ) { ?>
                                        <?php if ( has_post_thumbnail() ) { ?>
                                            <figure class="<?php echo esc_attr( join(' ',$post_thumb) ); ?>"<?php victim_schema_markup('image') ?>>
                                                <?php 
                                                if ( Victim_Utility::theme_options('blog_single_sidebar_dispay') == 'right' ) {
                                                    Victim_Utility::featured_image(870, 500, true, false);
                                                } elseif ( Victim_Utility::theme_options('blog_single_sidebar_dispay') == 'left' ) {
                                                    Victim_Utility::featured_image(870, 500, true, false);
                                                } else {
                                                    if( Victim_Utility::theme_options('feature_images_status') == 'wide' ) {
                                                        Victim_Utility::featured_image(1140, 550, true, false);
                                                    } elseif ( Victim_Utility::theme_options('feature_images_status') == 'full') {
                                                        Victim_Utility::featured_image(1280, 550, true, false);
                                                    } else {
                                                        Victim_Utility::featured_image(1920, 750, true, false);
                                                    }
                                                } ?> 
                                            </figure><!-- /.post-thumb -->
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if( 'category' == $elements ) { ?>
                                        <div class="post-category">
                                            <?php the_category(' '); ?>
                                        </div>
                                    <?php } ?>

                                    <?php if( 'title' == $elements ) { ?>
                                       <h2 class="entry-title" <?php victim_schema_markup('headline') ?>><?php the_title(); ?></h2>
                                    <?php } ?>                     

                                    <?php if( 'meta' == $elements ) { ?>
                                       <div class="post-meta">
                                           <div class="entry-author"><span><?php esc_html_e('By', 'victim'); ?></span><?php echo the_author_posts_link(); ?></div>
                                           <div class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></div>
                                       </div><!-- /post-meta -->
                                    <?php } ?>

                                    <?php if( 'content' == $elements ) { ?>
                                        <div class="entry-content" <?php victim_schema_markup('entry_content') ?>>
                                            <?php 
                                                the_content(); 
                                                victim_wp_link_pages(); 
                                            ?>
                                        </div><!--  /.entry-content -->
                                    <?php } ?>

                                    <?php if( 'tag' == $elements ) { ?>
                                        <?php if( has_tag() ): ?>
                                        <div class="blog-tag">
                                            <div class="tagcloud">
                                                <span><?php esc_html_e('Tags: ', 'victim'); ?></span>
                                                <?php the_tags('', ''); ?>
                                            </div><!--  /.tagcloud -->
                                        </div><!--  /.blog-tag -->
                                        <?php endif; ?>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                        </article><!--  /.post -->
                        <?php endwhile; ?>
                    <?php } ?>

                    <?php if( 'related_posts' == $elements ) { ?>    
                        <div class="related-post-content">
                            <div class="title-content">
                                <h2 class="post-section-title"><?php echo esc_html__('Related Posts', 'victim'); ?></h2><!--  /.post-section-title -->
                            </div><!--  /.title-content -->
                            <div class="related-content row">
                                <?php get_template_part( 'template-parts/post/related-post' ); ?>
                            </div><!--  /.related-content -->
                        </div><!--  /.related-post-content -->
                    <?php } ?>

                    <?php
                        if( 'comments' == $elements  ) { 
                            // If comments are open or we have at least one comment, load up the comment template
                            if ( comments_open() || get_comments_number() ) :
                            comments_template();
                            endif;
                        }
                    ?>
                    
                    <?php if( 'post_pagination' == $elements ) { ?>
                        <?php if ( get_previous_post() || get_next_post() ) : ?>
                            <div class="single-post-pagination post">
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php if ( get_previous_post() ) { ?>
                                        <div class="text-left">
                                            <div class="more-link-wrap previous-posts">
                                                <div class="post-thumb">
                                                    <a href="<?php echo esc_url( get_permalink(get_previous_post()->ID) ); ?>">
                                                    <?php 
                                                    $prevThumbnail = get_the_post_thumbnail( get_previous_post()->ID, 'thumbnail' );
                                                    echo wp_kses_post($prevThumbnail);
                                                    ?>
                                                    </a>
                                                </div><!--  /.post-thumb -->
                                                <div class="page-post-content">
                                                    <?php previous_post_link('%link', esc_html__('Older Post', 'victim')); ?>
                                                    <h3><a href="<?php echo esc_url( get_permalink(get_previous_post()->ID) ); ?>"><?php echo get_the_title(get_previous_post()); ?></a></h3>
                                                </div><!--  /.post-content -->
                                            </div>
                                        </div><!--  /.text-left -->
                                        <?php } ?> 
                                    </div><!--  /.col-6 -->
                                    <div class="col-md-6">
                                        <?php if ( get_next_post() ) { ?>
                                        <div class="text-right">
                                            <div class="more-link-wrap next-posts">
                                                <div class="page-post-content">
                                                    <?php next_post_link('%link', esc_html__('Newer Post', 'victim')); ?>
                                                    <h3><a href="<?php echo esc_url( get_permalink(get_next_post()->ID) ); ?>"><?php echo get_the_title(get_next_post()); ?></a></h3>
                                                </div><!--  /.post-content -->
                                                <div class="post-thumb">
                                                    <a href="<?php echo esc_url( get_permalink(get_next_post()->ID) ); ?>">
                                                    <?php 
                                                    $prevThumbnail = get_the_post_thumbnail( get_next_post()->ID, 'thumbnail' );
                                                    echo wp_kses_post($prevThumbnail);
                                                    ?>
                                                    </a>
                                                </div><!--  /.post-thumb -->
                                            </div>
                                        </div><!--  /.text-right -->
                                        <?php } ?> 
                                    </div><!--  /.col-6 -->
                                </div><!--  /.row -->
                            </div><!--  /.single-post-pagination -->
                        <?php endif; ?>
                    <?php } ?>
                <?php } ?>
            </div><!--  /.col-lg-8 -->

            <?php
            $sidebar_position = Victim_Utility::meta_options('sidebar_position');
            if( isset( $sidebar_position) && ( $sidebar_position !== 'full' && $sidebar_position !=='default' ) ) { ?>
                    <div class="<?php echo esc_attr( join(' ',$sidebar_content_class) ); ?>"<?php victim_schema_markup('sidebar') ?>>
                        <?php get_sidebar(); ?>
                    </div><!-- /.col-lg-4 -->
                <?php
            } else {
                if( Victim_Utility::theme_options('blog_single_sidebar_dispay') !=='full' && is_active_sidebar( "sidebar-single" ) ) { ?>
                <div class="<?php echo esc_attr( join(' ', $sidebar_content_class) ); ?>"<?php victim_schema_markup('sidebar') ?>>
                    <?php get_sidebar(); ?>
                </div><!-- /.col-lg-4 -->
                <?php }
            } ?>
        </div><!--  /.row -->
    </div><!--  /.container -->
</div><!--  /.blog-page-block -->