<?php
/**
 * Single related posts
 *
 * @package Victim WordPress theme
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$query_based = Victim_Utility::theme_options( array('related_posts_query_type', 'category') );
$term_tax = $query_based  ? $query_based : 'category';

// Create an array of current term ID's
$terms = wp_get_post_terms( get_the_ID(), $term_tax );

if( !is_wp_error($terms) ) {
	$terms_ids = array();
	foreach( $terms as $term ) {
		$terms_ids[] = $term->term_id;
	}
} else {
	return false;
}

// Query args
$args = array(
	'posts_per_page' => Victim_Utility::theme_options( array('related_posts_number', 2) ),
	'orderby'        => 'rand',
	'post__not_in'   => array( get_the_ID() ),
	'no_found_rows'  => true,
);

// If category
if ( 'category' == $term_tax ) {
	$args['category__in'] = $terms_ids;
}

// If tags
if ( 'post_tag' == $term_tax ) {
	$args['tag__in'] = $terms_ids;
}

// Related query arguments
$victim_related_query = new WP_Query( $args );
while ($victim_related_query->have_posts()) : $victim_related_query->the_post();  ?>
<div class="col-md-6">
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        <div class="grid-layout">
        <?php foreach (victim_blog_entries_positioning() as $elements ) { ?>
            <?php if ( has_post_thumbnail() && 'featured_image' == $elements ) {  ?>
                <figure class="post-thumb" <?php victim_schema_markup('image') ?>>          
                    <a href="<?php the_permalink(); ?>">
                        <?php Victim_Utility::featured_image(400, 245, true, false); ?>            
                    </a> 
                </figure><!-- /.post-thumb -->
            <?php } ?>

            <?php if( 'category' == $elements ) { ?>
                <div class="post-category">
                    <?php the_category(' '); ?>
                </div><!--  /.post-category -->
            <?php } ?>

            <?php if( 'title' == $elements ) { 
                /* translators: %s: Permalinks of Posts */
                the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); 
            } ?>
            
            <?php if( 'content' == $elements ) { ?>
            <div class="entry-content" <?php victim_schema_markup('entry_content') ?>><?php echo Victim_Utility::postexcerpt( Victim_Utility::theme_options(array('excerpt_length', 25)) ); ?></div><!--  /.entry-content -->
            <?php } ?>

            <?php if( 'footer_meta' == $elements ) { ?>
                <div class="post-meta">
                    <div class="entry-author"><span><?php esc_html_e('By', 'victim'); ?></span><?php echo the_author_posts_link(); ?></div>
                    <div class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></div>
                </div><!-- /post-meta -->
            <?php } ?>
        <?php } ?>
        </div><!--  /.grid-layout -->
    </article><!--  /.post -->
</div><!--  /.col-lg-6 -->
<?php endwhile; wp_reset_postdata(); ?>