<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package Victim
 * @since 1.0
 */
$sidebar_position = Victim_Utility::theme_options('blog_sidebar_dispay');
if ( !is_active_sidebar( 'sidebar-blog' ) ) {         
    $post_columns_class = 'small-items col-lg-4';   
} else {
    if ( $sidebar_position == 'full' ) {
        $post_columns_class = 'small-items col-lg-4';
    } elseif ( $sidebar_position == 'left' ) {
       $post_columns_class = 'small-items col-lg-6';
    } else {
        $post_columns_class = 'small-items col-lg-6';
    }
}
if( is_sticky() && !is_paged() ) { ?>
<div class="col-lg-12 big-items">    
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
        <div class="grid-layout">
            <div class="row align-items-center">
                <?php if ( has_post_thumbnail() ) {  ?>
                <div class="col-lg-6">
                    <figure class="post-thumb" <?php victim_schema_markup('image') ?>>
                        <a href="<?php the_permalink(); ?>">
                            <?php 
                            if ( $sidebar_position == 'full' ) {
                                Victim_Utility::featured_image(540, 320, true, false);
                            } elseif ( $sidebar_position == 'left' ) {
                                Victim_Utility::featured_image(825, 599, true, false);
                            } else {
                                Victim_Utility::featured_image(825, 599, true, false);
                            } ?>    
                        </a>
                    </figure><!--  /.post-thumb -->
                </div><!--  /.col-lg-6 -->
                <div class="col-lg-6">
                <?php } else { ?>
                <div class="col-lg-12">
                <?php } ?>
                    <div class="post-category">
                        <?php the_category(' '); ?>
                    </div><!--  /.post-category -->
                    <?php 
                        /* translators: %s: Permalinks of Posts */
                        the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); 
                    ?>
                    <div class="entry-content"<?php victim_schema_markup('entry_content') ?>><?php echo Victim_Utility::postexcerpt( Victim_Utility::theme_options(array('excerpt_length', 25)) ); ?></div><!--  /.entry-content -->
                    <div class="post-meta">
                        <div class="entry-author"><span><?php esc_html_e('By', 'victim'); ?></span><?php echo the_author_posts_link(); ?></div>
                        <div class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></div>
                    </div><!-- /post-meta -->
                </div><!--  /.col-lg-6 -->
            </div><!--  /.col-md-12 -->
        </div><!--  /.row -->
    </article>
</div><!--  /.col-lg-12 -->
<?php } else { ?>
<div class="<?php echo esc_attr( $post_columns_class ); ?>">
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        <div class="grid-layout">
        <?php foreach (victim_blog_entries_positioning() as $elements ) { ?>
            <?php if ( has_post_thumbnail() && 'featured_image' == $elements ) {  ?>
                <figure class="post-thumb" <?php victim_schema_markup('image') ?>>          
                    <a href="<?php the_permalink(); ?>">
                        <?php
                        if ( !is_active_sidebar( 'sidebar-blog' ) ) {
                            Victim_Utility::featured_image(400, 245, true, false);
                        } else {
                            if ( $sidebar_position == 'full' ) {
                                Victim_Utility::featured_image(400, 245, true, false);
                            } elseif ( $sidebar_position == 'left' ) {
                                Victim_Utility::featured_image(370, 245, true, false);
                            } else {
                                Victim_Utility::featured_image(370, 245, true, false);
                            }
                        } ?>            
                    </a> 
                </figure><!-- /.post-thumb -->
            <?php } ?>

            <?php if( 'category' == $elements ) { ?>
                <div class="post-category">
                    <?php the_category(' '); ?>
                </div><!--  /.post-category -->
            <?php } ?>

            <?php if( 'title' == $elements ) { 
                /* translators: %s: Permalinks of Posts */
                the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); 
            } ?>
            
            <?php if( 'content' == $elements ) { ?>
            <div class="entry-content"<?php victim_schema_markup('entry_content') ?>><?php echo Victim_Utility::postexcerpt( Victim_Utility::theme_options(array('excerpt_length', 25)) ); ?><?php if( get_the_title() == '' ) {?><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e('More', 'victim'); ?></a><?php } ?>
            </div><!--  /.entry-content -->
            <?php } ?>

            <?php if( 'footer_meta' == $elements ) { ?>
                <div class="post-meta">
                    <div class="entry-author"><span><?php esc_html_e('By', 'victim'); ?></span><?php echo the_author_posts_link(); ?></div>
                    <div class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></div>
                </div><!-- /post-meta -->
            <?php } ?>
        <?php } ?>
        </div><!--  /.grid-layout -->
    </article><!--  /.post -->
</div><!--  /.col-lg-6 -->         
<?php }