<?php
/**
 * This template for displaying footer part
 *
 * @package Victim
 * @since 1.0
 */

/**
 * Footer Part show/hide condition
 *
 * @since 1.0
 */
if( Victim_Utility::meta_options('footer_show_footer') == 'no' ) {
    return;
} 
/**
 * Control Header Transparent
 * @package Victim
 * @since 1.0
 */
if( victim_fixed_footer() == 'yes' ) {
    $footer_fixed = 'footer-fixed';
} else {
    $footer_fixed = '';
} ?>

<!-- Custom Footer
================================================== --> 
<?php if( Victim_Utility::theme_options('footer_type') == 'custom_footer' && Victim_Utility::theme_options('footer_templates') !== 'default' || Victim_Utility::meta_options('footer_type') == 'custom_template' && Victim_Utility::meta_options('footer_template') !== 'default'  ) : ?>
<footer class="victim-custom-footer <?php echo esc_attr($footer_fixed); ?>" <?php victim_schema_markup('footer') ?>>
    <?php       
        $args = array( 'post_type' => 'victim_templates', 'p' => victim_footer_template_id() );

        $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post();
                the_content();
            endwhile;
        wp_reset_postdata();
    ?>
</footer><!--  /.victim-custom-header -->
<?php else : ?>

<?php 
if(  Victim_Utility::theme_options('full_footer_content') == true ) {
    $container_name = 'container-fluid';
} else {
    $container_name = 'container';
} ?>
<!-- Predefine Footer
================================================== -->
<footer class="site-footer <?php echo esc_attr($footer_fixed); ?>"<?php victim_schema_markup('footer') ?>>
    <div class="footer-top-block">
        <?php $footer_widgets_layout = victim_footer_widgets_layout_array(); ?>
        <div class="<?php echo esc_attr($container_name); ?>">
            <?php if ( ! empty( $footer_widgets_layout ) ) : ?>
            <div class="row">
                <?php dynamic_sidebar( 'footer-widgets' ); ?>
            </div>
            <?php endif; ?>
        </div><!-- /.container -->
    </div><!--  /.container -->

    <div class="footer-bottom-block">
        <div class="<?php echo esc_attr($container_name); ?>">
            <div class="row">
                <div class="col-md-12 text-center">
                    <p class="copyright-text"><?php echo wp_kses( Victim_Utility::theme_options( array('footer_copyright_info', __('Created With By <a href="#">SoftHopper</a>','victim') ) ), Victim_Static::html_allow() ); ?></p>
                </div><!--  /.col-md-12 -->
            </div><!--  /.row -->
        </div><!--  /.container -->
    </div><!--  /.footer-bottom-block -->
</footer><!--  /.site-footer -->
<?php endif; ?>