<?php
/**
 * This template for displaying default layout
 *
 * @package Victim
 * @since 1.0
 */
$theme_color_version = Victim_Utility::theme_options('theme_background_status'); ?>

<!-- Hero Block
================================================== -->
<section class="hero-block bg-soft-black <?php echo esc_attr( victim_header_transparent() ); ?>" style="background-image: url(<?php echo esc_url( get_header_image() ); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <?php if ( is_archive() || is_search() ): ?>
                    <div class="pd-t-120 pd-b-120">
                    <?php if ( is_archive() ) {
                        victim_archive_title( '<h2 class="victim-title">', '</h2>' );
                        ?><?php 
                    } elseif ( is_search() ) { ?>
                        <h2 class="victim-title"><span><?php esc_html_e( 'Search Results for : ', 'victim' ) ?></span><?php echo get_search_query(); ?></h2><!--  /.victim-title -->
                    <?php } ?>
                    </div>
                <?php else: ?>
                    <div class="pd-t-120 pd-b-120">
                    <h2 class="victim-title" <?php victim_schema_markup('headline') ?>><?php echo wp_kses( Victim_Utility::theme_options( array('blog_title_info', __('Latest Articles.','victim') ) ), Victim_Static::html_allow() ); ?></h2>
                    </div>
                <?php endif; ?>
            </div><!--  /.col-md-12 -->
        </div><!--  /.row -->
    </div><!--  /.container -->
</section><!--  /.hero-block -->

<!-- Blog Page Block
================================================== -->
<main class="blog-block" id="main"<?php victim_schema_markup('main') ?>>
    <div class="container">
        <!-- Content Row -->
        <div class="row">
            <?php
                ( isset($_GET["blog_sidebar"]) ) ? $blog_sidebar = $_GET["blog_sidebar"]  : $blog_sidebar = "" ;
                ($blog_sidebar) ? $sidebar_position = $blog_sidebar : $sidebar_position = Victim_Utility::theme_options('blog_sidebar_dispay');

                if( Victim_Utility::theme_options('blog_sidebar_status') == 'sticky' ) {
                    $sidebar_sticky = 'sticky-content';
                } else {
                    $sidebar_sticky = '';
                }

                if ( !is_active_sidebar( 'sidebar-blog' ) ) {         
                    $post_columns_class = 'col-lg-12';
                    $sidebar_columns_class = '';       
                } else {
                    if ( $sidebar_position == 'full' || Victim_Utility::theme_options('blog_layout_dispay') == 'grid_features' ) {
                        $post_columns_class = 'col-lg-12';
                        $sidebar_columns_class = '';
                    } elseif ( $sidebar_position == 'left' ) {
                       $post_columns_class = 'col-lg-9 order-last layout-content';
                       $sidebar_columns_class = 'col-lg-3 order-first layout-sidebar ' . $sidebar_sticky;
                    } else {
                        $post_columns_class = 'col-lg-9 layout-content';
                        $sidebar_columns_class = 'col-lg-3 layout-sidebar ' . $sidebar_sticky;
                    }
                }
            ?>
            <div class="<?php echo esc_attr( $post_columns_class ); ?>">
                <!-- Blog Items -->
                <div class="blog-latest-items">
                    <div class="row masonry-contents">                    
                        <?php
                            if ( have_posts() ) :
                                $i = 0;
                                while ( have_posts() ) : the_post();
                                    get_template_part( 'template-parts/post/content' );
                                endwhile;  
                            else :  
                                get_template_part( 'template-parts/post/content', 'none' ); 
                            endif; 
                        ?>  
                    </div><!--  /.row -->
                </div><!--  /.blog-latest-items -->
            
                <div class="row">
                    <div class="col-md-12 text-center">
                        <?php 
                        if( Victim_Utility::theme_options('pagination_types') == 'load_more') {
                            if( function_exists('victim_theme_load_more_post') ) {
                                echo victim_theme_load_more_post();
                            }
                        } else {
                            victim_posts_pagination_nav(); 
                        } ?>
                    </div><!--  /.col-md-12 -->
                </div><!--  /.row -->
            </div><!--  /.col-lg-8 -->

            <?php if( 'grid_features' !== Victim_Utility::theme_options('blog_layout_dispay') && $sidebar_position !=='full' || !is_active_sidebar( 'sidebar-blog' ) ) { ?>
            <div class="<?php echo esc_attr( $sidebar_columns_class ); ?>">
                <?php get_sidebar(); ?>
            </div><!-- /.col-lg-4 -->
            <?php } ?>
        </div><!--  /.row -->
    </div><!--  /.container -->  
</main><!-- /.blog-block -->