<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package Victim
 */
get_header();

$elemetor = get_post_meta( get_the_ID(), '_elementor_edit_mode');
$page_builder = ( get_post_meta($post->ID, '_wpb_vc_js_status', true) == 'true' ) ? true : false;

$page_class = array('blog-block pd-b-45 page-content-main');
if( victim_header_sticky() == 'yes' ) {
    $page_class[] = 'sticky-page-content';
} 

// If Elementor Page Builder
if( $elemetor ) : 
    if ( have_posts() ) : 
        while ( have_posts() ) : the_post(); ?> 
        <div class="victim-page-builder-elementor clearfix" id="main">
            <?php the_content(); ?>
        </div>
        <?php 
        endwhile; 
    endif;
else: ?>
    <!-- Blog Block
    ================================================== -->
    <section class="<?php echo esc_attr( join(' ',$page_class) ); ?>" id="main">
        <div class="container">
            <!-- Content Row -->
            <?php
                $sidebar_position = Victim_Utility::theme_options('page_sidebar_dispay');
                if ( !is_active_sidebar( "sidebar-page" ) ) {
                    $post_columns_class = 'col-lg-12 full-content';
                    $sidebar_columns_class = '';
                } else {                
                    if ( $sidebar_position == 'right' ) {
                        $post_columns_class = 'col-lg-8 layout-content';
                        $sidebar_columns_class = 'col-lg-4 layout-sidebar';
                    } elseif ( $sidebar_position == 'left' ) {
                       $post_columns_class = 'col-lg-8 order-last layout-content';
                       $sidebar_columns_class = 'col-lg-4 order-first layout-sidebar';
                    } else {
                       $post_columns_class = 'col-lg-12 full-content';
                       $sidebar_columns_class = '';
                    }
                }
            ?>
            
            <div class="row">
                <?php while ( have_posts() ) : the_post(); ?>
                <div class="<?php echo esc_attr( $post_columns_class ); ?>">
                    <div class="blog-single-page">
                        <article id="post-<?php the_ID(); ?>"<?php post_class(' post '); ?> >
                            <?php if ( has_post_thumbnail() && Victim_Utility::meta_options('show_featured_image_in_content') !== 'no' ) { ?>
                                <figure class="post-thumb" <?php victim_schema_markup('image') ?>>
                                    <a href="<?php the_permalink(); ?>">
                                    <?php 
                                        if ( $sidebar_position == 'right' ) {
                                            Victim_Utility::featured_image(870, 500, true, false);
                                        } elseif ( $sidebar_position == 'left' ) {
                                            Victim_Utility::featured_image(870, 500, true, false);
                                        } else {
                                            Victim_Utility::featured_image(1140, 650, true, false);
                                        }
                                    ?>
                                    </a> 
                                </figure><!-- /.entry-thumb -->
                            <?php } ?>

                            <div class="post-details">
                                <?php if( Victim_Utility::meta_options('show_page_title') !== 'no' ) { ?>
                                <h2 class="entry-title mrb-20"<?php victim_schema_markup('headline') ?>><?php the_title(); ?></h2> 
                                <?php } ?> 
                                <div class="entry-content"<?php victim_schema_markup('entry_content') ?>>                            
                                    <?php 
                                        the_content(); 
                                        victim_wp_link_pages(); 
                                    ?>
                                </div><!--  /.entry-content -->
                            </div><!-- /.entry-content -->
                        </article><!-- /.post -->
                        
                        <?php
                        // If comments are open or we have at least one comment, load up the comment template
                        if ( comments_open() || get_comments_number() ) :
                            comments_template();
                        endif; ?>
                    </div><!-- /.blog-page-content -->
                    
                </div><!-- /.col-md-9 full-content -->
                <?php endwhile; ?>

                <?php if( $sidebar_position =='left' || $sidebar_position =='right' || !is_active_sidebar( "sidebar-page" ) ) { ?>
                <div class="<?php echo esc_attr( $sidebar_columns_class ); ?> " <?php victim_schema_markup('sidebar') ?>>
                    <?php get_sidebar(); ?>
                </div><!-- /.col-lg-4 -->
                <?php } ?>
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /.blog-block -->
<?php endif; ?>
<?php get_footer(); ?>