<?php
/**
 *  Victim Register Location for elementor pro.
 *
 * @package Victim
 * @since 1.0.3
 */
function victim_register_elementor_locations( $elementor_theme_manager ) {
    $elementor_theme_manager->register_all_core_location();
}
// Add support for Elementor Pro locations
add_action( 'elementor/theme/register_locations', 'victim_register_elementor_locations' );

/**
 *  Victim Return array of the number which represent the layout of the footer.
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_footer_widgets_layout_array' ) ) {
    function victim_footer_widgets_layout_array() {
        $layout = Victim_Utility::theme_options( array('footer_widgets_layout', '[3,6,9]' ) );
        $layout = json_decode( $layout );

        if ( is_array( $layout ) && ! empty( $layout ) ) {
            $spans = array( (int)$layout[0] );

            for ( $i = 0; $i < ( sizeof( $layout ) - 1 ); $i++ ) {
                $spans[] = $layout[$i+1] - $layout[$i];
            }

            $spans[] = 12 - $layout[$i];

            return $spans;
        } else if ( 1 === $layout ) { // single column
            return array( '12' );
        }

        // default: disable footer
        return array();
    }
}

/**
 *  Victim Filter the dynamic sidebars and alter the BS col classes for the footer widgets
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_footer_widgets_params' ) ) {
    function victim_footer_widgets_params( $params ) {
        static $counter = 0;
        static $first_row = true;
        $footer_widgets_layout_array = victim_footer_widgets_layout_array();

        if ( $params[0]['id'] === 'footer-widgets' ) {
            // 'before_widget' contains %d, see inc/action_widgets_init.php
            $params[0]['before_widget'] = sprintf( $params[0]['before_widget'], $footer_widgets_layout_array[$counter] );

            // first widget in the any non-first row
            if ( false === $first_row && 0 === $counter ) {
                $params[0]['before_widget'] = '<div class="row">' . $params[0]['before_widget'];
            }

            $counter++;
        }

        end( $footer_widgets_layout_array );
        if ( $counter > key( $footer_widgets_layout_array ) ) {
            $counter = 0;
            $first_row = false;
        }

        return $params;
    }
    add_filter( 'dynamic_sidebar_params', 'victim_footer_widgets_params', 9, 1 );
}

/**
 *  Add Support For Elementor Header/Footer
 *
 * @package Victim
 * @since 1.0
 */
if( Victim_Utility::theme_options('header_type') == 'custom_header' ){ 
    function victim_header_buider_style() {
        $victim_stheader_template = Victim_Utility::theme_options( 'header_templates' );

        if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
            $css_file = new \Elementor\Core\Files\CSS\Post( $victim_stheader_template );
        } elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
            $css_file = new \Elementor\Post_CSS_File( $victim_stheader_template );
        }

        $css_file->enqueue();
    }
    add_action('wp_enqueue_scripts', 'victim_header_buider_style');
}

/**
 * Return correct schema markup
 *
 * @since 1.2.10
 */
if ( ! function_exists( 'victim_get_schema_markup' ) ) {

    function victim_get_schema_markup( $location ) {

        // Return if disable
        if ( Victim_Utility::theme_options( 'schema_markup' ) !== true  ) {
            return null;
        }

        // Default
        $schema = $itemprop = $itemtype = '';

        // HTML
        if ( 'html' == $location ) {
            $schema = 'itemscope itemtype="http://schema.org/WebPage"';
        }

        // Header
        elseif ( 'header' == $location ) {
            $schema = 'itemscope="itemscope" itemtype="http://schema.org/WPHeader"';
        }

        // Logo
        elseif ( 'logo' == $location ) {
            $schema = 'itemscope itemtype="http://schema.org/Brand"';
        }

        // Navigation
        elseif ( 'site_navigation' == $location ) {
            $schema = 'itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement"';
        }

        // Main
        elseif ( 'main' == $location ) {
            $itemtype = 'http://schema.org/WebPageElement';
            $itemprop = 'mainContentOfPage';
            if ( is_singular( 'post' ) ) {
                $itemprop = '';
                $itemtype = 'http://schema.org/Blog';
            } 

            $schema = 'itemscope itemprop="'. $itemprop .'" itemtype="'. $itemtype .'"';          
        }        
        
        // Creative Works
        elseif ( 'portfolio' == $location ) {
            $schema = 'itemtype="http://schema.org/CreativeWork"';
        }

        // Sidebar
        elseif ( 'sidebar' == $location ) {
            $schema = 'itemscope="itemscope" itemtype="http://schema.org/WPSideBar"';
        }

        // Footer widgets
        elseif ( 'footer' == $location ) {
            $schema = 'itemscope="itemscope" itemtype="http://schema.org/WPFooter"';
        }

        // Headings
        elseif ( 'headline' == $location ) {
            $schema = 'itemprop="headline"';
        }

        // Author name
        elseif ( 'name' == $location ) {
            $schema = 'itemprop="name"';
        }

        // Posts
        elseif ( 'entry_content' == $location ) {
            $schema = 'itemprop="text"';
        }

        // Publish date
        elseif ( 'publish_date' == $location ) {
            $schema = 'itemprop="datePublished"';
        }

        // Author name
        elseif ( 'author_name' == $location ) {
            $schema = 'itemprop="name"';
        }

        // Author link
        elseif ( 'author_link' == $location ) {
            $schema = 'itemprop="author" itemscope="itemscope" itemtype="http://schema.org/Person"';
        }

        // Item
        elseif ( 'item' == $location ) {
            $schema = 'itemprop="item"';
        }

        // Url
        elseif ( 'url' == $location ) {
            $schema = 'itemprop="url"';
        }

        // Position
        elseif ( 'position' == $location ) {
            $schema = 'itemprop="position"';
        }

        // Image
        elseif ( 'image' == $location ) {
            $schema = 'itemprop="image"';
        }

        return ' ' . apply_filters( 'victim_schema_markup', $schema );

    }

} 

/**
 * Outputs correct schema markup
 *
 * @since 1.2.10
 */
if ( ! function_exists( 'victim_schema_markup' ) ) {

    function victim_schema_markup( $location ) {
        echo victim_get_schema_markup( $location );
    }

}

if ( ! function_exists( 'victim_sidebar_functions' ) ) :
function victim_sidebar_functions( $post_meta, $theme_option, $sidebar_id  ) {
    if( Victim_Utility::meta_options('sidebar_status') == 'sticky' || Victim_Utility::theme_options('sidebar_status') == 'sticky' ) {
        $sidebar_sticky = 'sticky-content';
    } else {
        $sidebar_sticky = '';
    }
    if( Victim_Utility::meta_options($post_meta) && Victim_Utility::meta_options($post_meta) !=='default' ) {
        $sidebar_position = Victim_Utility::meta_options($post_meta);
        if ( $sidebar_position == 'full' ) {
            $post_columns_class = 'col-lg-9 full-content';
            $sidebar_columns_class = '';
        } elseif ( $sidebar_position == 'left' ) {
            $post_columns_class = 'col-lg-9 order-last layout-content';
            $sidebar_columns_class = 'col-lg-3 order-first layout-sidebar ' . $sidebar_sticky;
        } else {
            $post_columns_class = 'col-lg-9 layout-content';
            $sidebar_columns_class = 'col-lg-3 layout-sidebar ' . $sidebar_sticky;
        }
    } else {
        if ( !is_active_sidebar( $sidebar_id ) ) { 
            $post_columns_class = 'col-lg-9 full-content';
            $sidebar_columns_class = '';
            $sidebar_position = '';
        } else {                
            $sidebar_position = Victim_Utility::theme_options($theme_option);
            if ( $sidebar_position == 'full' ) {
                $post_columns_class = 'col-lg-9 full-content';
                $sidebar_columns_class = '';
            } elseif ( $sidebar_position == 'left' ) {
                $post_columns_class = 'col-lg-9 order-last layout-content';
                $sidebar_columns_class = 'col-lg-3 order-first layout-sidebar layout-sidebar ' . $sidebar_sticky;
            } else {
                $post_columns_class = 'col-lg-9 layout-content';
                $sidebar_columns_class = 'col-lg-3 layout-sidebar layout-sidebar ' . $sidebar_sticky;
            }
        }
    }

    return array( $post_columns_class, $sidebar_columns_class );
}
endif;


/**
 * Returns Blog Entries elements for the customizer
 * @package Victim
 * @since 1.0.0
 */
if ( ! function_exists( 'victim_blog_entries_elements' ) ) {

    function victim_blog_entries_elements() {
        // Default elements
        $elements = apply_filters( 'victim_blog_entries_positions', array(
            'featured_image'    => esc_html__( 'Featured Image', 'victim' ),
            'category'   => esc_html__( 'Categories', 'victim' ),
            'title' => esc_html__( 'Title', 'victim' ),
            'content'  => esc_html__( 'Content', 'victim' ),
            'footer_meta' => esc_html__( 'Footer Meta', 'victim' ),
        ) );

        // Return elements
        return $elements;
    }
}

if ( ! function_exists( 'victim_blog_single_entries_elements' ) ) {

    function victim_blog_single_entries_elements() {
        // Default elements
        $elements = apply_filters( 'victim_blog_single_entries_positions', array(
            'category'   => esc_html__( 'Categories', 'victim' ),
            'title' => esc_html__( 'Title', 'victim' ),
            'meta' => esc_html__( 'Meta', 'victim' ),
            'featured_image'    => esc_html__( 'Featured Image', 'victim' ),
            'content'  => esc_html__( 'Content', 'victim' ),
            'tag' => esc_html__( 'Tag', 'victim' ),
        ) );

        // Return elements
        return $elements;
    }
}

if ( ! function_exists( 'victim_blog_single_sections_elements' ) ) {

    function victim_blog_single_sections_elements() {
        // Default elements
        $elements = apply_filters( 'victim_blog_single_sections_positions', array(
            'blog_content' => esc_html__( 'Blog Content', 'victim' ),
            'related_posts'   => esc_html__( 'Related Posts', 'victim' ),
            'comments'    => esc_html__( 'Comments', 'victim' ),
            'post_pagination'  => esc_html__( 'Post Navigation', 'victim' ),
        ) );

        // Return elements
        return $elements;
    }
}


/**
 * Returns blog entry elements positioning
 *
 * @since 1.0.0
 */
if ( ! function_exists( 'victim_blog_entries_positioning' ) ) {

    function victim_blog_entries_positioning() {
        
        $sections = array( 'featured_image', 'category', 'title', 'content', 'footer_meta'  );

        // Get sections from Customizer
        $sections = Victim_Utility::theme_options( array('blog_enries_content', $sections) );

        // Turn into array if string
        if ( $sections && ! is_array( $sections ) ) {
            $sections = explode( ',', $sections );
        }

        // Apply filters for easy modification
        $sections = apply_filters( 'victim_blog_entries_positions', $sections );

        // Return sections
        return $sections;

    }
}

/**
 * Returns blog single elements positioning
 *
 * @since 1.0.0
 */
if ( ! function_exists( 'victim_single_blog_positioning' ) ) {

    function victim_single_blog_positioning() {
        // Default sections
        $sections = array( 'featured_image', 'category', 'title', 'meta', 'content', 'tag'  );

        // Get sections from Customizer
        $sections = Victim_Utility::theme_options( array('blog_single_enries_content', $sections) );

        // Turn into array if string
        if ( $sections && ! is_array( $sections ) ) {
            $sections = explode( ',', $sections );
        }

        // Apply filters for easy modification
        $sections = apply_filters( 'victim_blog_single_elements_positions', $sections );

        // Return sections
        return $sections;

    }

}
if ( ! function_exists( 'victim_single_blog_sections_positioning' ) ) {

    function victim_single_blog_sections_positioning() {
        // Default sections
        $sections = array( 'blog_content', 'related_posts', 'comments', 'post_pagination'  );

        // Get sections from Customizer
        $sections = Victim_Utility::theme_options( array('blog_single_sections_content', $sections) );

        // Turn into array if string
        if ( $sections && ! is_array( $sections ) ) {
            $sections = explode( ',', $sections );
        }

        // Apply filters for easy modification
        $sections = apply_filters( 'victim_blog_single_sections_elements', $sections );

        // Return sections
        return $sections;

    }

}

if ( ! function_exists( 'victim_theme_load_more_post' ) ) {
    function victim_theme_load_more_post() {
        ob_start(); ?>
            <div class="text-center posts-loadmore">
                <?php echo get_next_posts_link(esc_html__('Load More', 'victim')); ?>
            </div>
        <?php return ob_get_clean();                               
    } // end victim_theme_load_more_post
}

function victim_theme_counter_inside_function() {
    static $counter = 0;
    ++$counter;
    return $counter;
}

/**
 * Preloader
 * @package Victim
 */
if ( ! function_exists( 'victim_preloader' ) ) :
    function victim_preloader() {
        if( Victim_Utility::theme_options('preloader') == true ) { ?>
            <?php if( Victim_Utility::theme_options('preloader_type') == 'custom_preloader' && Victim_Utility::theme_options('preloader_templates') !== 'default' ) { ?>
            <div class="preloader">
                <div class="preloader-inner">
                <?php
                    $get_custom_headers = Victim_Utility::theme_options('preloader_templates');
                    $args = array( 'post_type' => 'victim_templates', 'p' => $get_custom_headers );
                    $loop = new WP_Query( $args );
                        while ( $loop->have_posts() ) : $loop->the_post();
                            the_content();
                        endwhile;
                    wp_reset_postdata();
                ?>
                </div>
            </div><!--  /.victim-custom-header -->
            <?php } else { ?>
            <div class="preloader">
                <div class="preloader-inner">
                    <div class="preloader-icon">
                        <span></span>
                        <span></span>
                    </div><!-- /preloader-icon -->
                </div><!-- /preloader-inner -->
            </div><!-- /preloader -->
            <?php } ?>
        <?php }
    }
endif;

/**
 *  Victim Menu Type
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_menu_type' ) ) :
    function victim_menu_type() {
        $meta = Victim_Utility::meta_options('menu_type');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }
        if ( Victim_Utility::theme_options(array('header_menu_types', 'normal_menu')) == 'normal_menu' ) {
            $menu = 'normal';
        } else {
            $menu = 'hamburger';
        }

        return apply_filters( 'victim_header_menu_type', $menu );
    }
endif;

/**
 *  Victim Header Search Switch
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_header_search' ) ) :
    function victim_header_search() {
        $meta = Victim_Utility::meta_options('enable_search');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }
        if ( Victim_Utility::theme_options('enable_search') == true ) {
            $search_visibility = 'yes';
        } else {
            $search_visibility = 'no';
        }

        return apply_filters( 'victim_header_search', $search_visibility );
    }
endif;

/**
 *  Victim Header Off Canvas widget
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_header_off_canvus_widget' ) ) :
    function victim_header_off_canvus_widget() {
        $meta = Victim_Utility::meta_options('enable_offcanvus_widget');
        if( $meta && 'default' !== $meta && Victim_Utility::meta_options('menu_type') !== 'hamburger' ) {
            return $meta;
        }
        if (  Victim_Utility::theme_options('header_menu_types') !== 'hamburger_menus' && Victim_Utility::theme_options('enable_hamburger') == true ) {
            $widget_visivility = 'yes';
        } else {
            $widget_visivility = 'no';
        }

        return apply_filters( 'victim_header_off_canvus_widget', $widget_visivility );
    }
endif;

/**
 *  Victim Header Cart Widget
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_header_shop_cart' ) ) :
    function victim_header_shop_cart() {
        $meta = Victim_Utility::meta_options('enable_shoping_cart');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }
        if ( Victim_Utility::theme_options('enable_shop_cart') == true ) {
            $cart_display = 'yes';
        } else {
            $cart_display = 'no';
        }

        return apply_filters( 'victim_header_shop_cart', $cart_display );
    }
endif;

/**
 *  Victim Header Transparent
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_header_transparent' ) ) :
    function victim_header_transparent() {
        $meta = Victim_Utility::meta_options('transparent_header');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }
        if ( Victim_Utility::theme_options('transparent_header') == true ) {
            $header_transparent = 'yes';
        } else {
            $header_transparent = 'no';
        }
        return apply_filters( 'victim_header_transparent', $header_transparent );
    }
endif;

/**
 *  Victim Header Transparent
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_header_width' ) ) :
    function victim_header_width() {
        $meta = Victim_Utility::meta_options('full_width_header');
        if( $meta && 'yes' == $meta ) {
            return $meta;
        }

        $theme_header = Victim_Utility::theme_options('header_full_width');
        if ( !class_exists('Victim_Core') || ( $theme_header && $theme_header == true ) ) {
            $header_width = 'yes';
        } else {
            $header_width = 'no';
        }

        return apply_filters( 'victim_header_width', $header_width );
    }
endif;

/**
 *  Victim Header Sticky
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_header_sticky' ) ) :
    function victim_header_sticky() {
        $meta = Victim_Utility::meta_options('enable_sticky_header');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }

        if ( Victim_Utility::theme_options('enable_sticky_headers') == true ) {
            $header_transparent = 'yes';
        } else {
            $header_transparent = 'no';
        }

        return apply_filters( 'victim_header_sticky', $header_transparent );
    }
endif;

/**
 *  Victim Fixed footer Switch
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_fixed_footer' ) ) :
    function victim_fixed_footer() {
        $meta = Victim_Utility::meta_options('fixed_footer');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }
        if ( Victim_Utility::theme_options('fixed_footer') == true ) {
            $search_visibility = 'yes';
        } else {
            $search_visibility = 'no';
        }

        return apply_filters( 'victim_fixed_footer', $search_visibility );
    }
endif;

/**
 *  Victim Header Template
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_header_template_id' ) ) :
    function victim_header_template_id() {

        $meta = Victim_Utility::meta_options('header_template');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }

        if ( Victim_Utility::theme_options('header_templates') !== '' ) {
            $get_custom_headers = Victim_Utility::theme_options('header_templates');
        } 

        return apply_filters( 'victim_header_template_id', $get_custom_headers );
    }
endif;

/**
 *  Victim Footer Template
 *
 * @package Victim
 * @since 1.0
 */
if ( ! function_exists( 'victim_footer_template_id' ) ) :
    function victim_footer_template_id() {

        $meta = Victim_Utility::meta_options('footer_template');
        if( $meta && 'default' !== $meta ) {
            return $meta;
        }

        if ( Victim_Utility::theme_options('footer_templates') !== '' ) {
            $get_custom_footers = Victim_Utility::theme_options('footer_templates');
        } 

        return apply_filters( 'victim_footer_template_id', $get_custom_footers );
    }
endif;

/**
 *  Victim Header Template
 *
 * @package Victim
 * @since 1.0.6
 */
function victim_header_locations() {
    Victim_Utility::template_part('header');
}

add_action('victim_header_template', 'victim_header_locations');

/**
 *  Victim Footer Template
 *
 * @package Victim
 * @since 1.0.6
 */
function victim_footer_locations() {
    Victim_Utility::template_part('footer');
}
add_action('victim_footer_template_locator', 'victim_footer_locations');

/**
 *  Victim Single Post Template
 *
 * @package Victim
 * @since 1.0.6
 */
function victim_single_post_locations() {
    Victim_Utility::template_part('single');
}
add_action('victim_single_posts_template', 'victim_single_post_locations');

/**
 *  Victim Archive Template
 *
 * @package Victim
 * @since 1.0.6
 */
function victim_archive_post_locations() {
    get_template_part( 'template-parts/blog-parts/blog-home' );
}
add_action('victim_archive_template', 'victim_archive_post_locations');

/**
 *  Register Theme Location
 *
 * @package Victim
 * @since 1.0.6
 */
if( class_exists( 'ElementorPro\Plugin' ) ) {
    function victim_elementor_locations( $elementor_theme_manager ) {
        $elementor_theme_manager->register_location(
            'header',
            [
                'hook' => 'victim_header_template',
                'remove_hooks' => [ 'victim_header_locations' ],
            ]
        );
        $elementor_theme_manager->register_location(
            'footer',
            [
                'hook' => 'victim_footer_template_locator',
                'remove_hooks' => [ 'victim_footer_locations' ],
            ]
        );       
        $elementor_theme_manager->register_location(
            'single',
            [
                'hook' => 'victim_single_posts_template',
                'remove_hooks' => [ 'victim_single_post_locations' ],
            ]
        );        
        $elementor_theme_manager->register_location(
            'archive',
            [
                'hook' => 'victim_archive_template',
                'remove_hooks' => [ 'victim_archive_post_locations' ],
            ]
        );
    }

    add_action( 'elementor/theme/register_locations', 'victim_elementor_locations' );
}