<?php
/**
 * One Click Demo Importer
 *
 * @package Victim
 */

function victim_theme_ocdi_import_files() {
    return array(
        array(
            'import_file_name'           =>     esc_html__('Demo Content','victim'),
            'import_file_url'            =>     esc_url('https://demo.softhopper.studio/theme-demo-contents/victim-demo/content.xml'),
            'import_widget_file_url'     =>     esc_url('https://demo.softhopper.studio/theme-demo-contents/victim-demo/widgets.wie'),
            'import_customizer_file_url' =>     esc_url('https://demo.softhopper.studio/theme-demo-contents/victim-demo/export.dat'),
            'import_preview_image_url'   =>     esc_url( get_theme_file_uri('screenshot.jpg') ),
            'import_notice'              =>     esc_html__( 'Before importing demo data you must have to install required plugins, Also ensure you are enable elementor svg upload Options form ( Elementor > Settings > Advance Tab ) Then Enable Unfiltered File Uploads.', 'victim' ),
            'preview_url'                =>     esc_url('https://demo.softhopper.studio/victim'),
        ), 
    );
}
add_filter( 'pt-ocdi/import_files', 'victim_theme_ocdi_import_files' );


function victim_theme_ocdi_after_import_setup( $selected_import ) {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'main-menu' => $main_menu->term_id,
        )
    );

    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'victim_theme_ocdi_after_import_setup' );


function victim_theme_ocdi_plugin_page_setup( $default_settings ) {
    $default_settings['parent_slug'] = 'themes.php';
    $default_settings['page_title']  = esc_html__( 'Victim Demo Import' , 'victim' );
    $default_settings['menu_title']  = esc_html__( 'Demo Importer' , 'victim' );
    $default_settings['capability']  = 'import';
    $default_settings['menu_slug']   = 'victim-one-click-demo-import';

    return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'victim_theme_ocdi_plugin_page_setup' );

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

add_filter( 'pt-ocdi/importer_options', 'victim_theme_ocdi_importer_options' );
function victim_theme_ocdi_importer_options( $options ) {
    $options['aggressive_url_search'] = true;
    return $options;
}