<?php
/**
 * Victim CSS Helpers
 *
 * @package Victim
 * @since 1.0
 */
if ( ! defined( 'ABSPATH' ) ) exit;

if(! class_exists( 'Victim_CSS_Helpers' ) ) {
    /**
     * The Victim Helpers
     */
    class Victim_CSS_Helpers {
        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }
        
        public function __construct() {
            add_action( 'wp_enqueue_scripts', array( $this, 'victim_spaing_elements' ), 300 );
        }

        /**
         * Hexa to RGBA Convector
         *
         * @package Victim
         * @since 1.0
         */
        private function victim_hex_2_rgba($color, $opacity = false) {
            $default = 'rgb(0,0,0)';
            //Return default if no color provided
            if(empty($color))
                return $default; 
         
            //Sanitize $color if "#" is provided 
            if ($color[0] == '#' ) {
                $color = substr( $color, 1 );
            }
         
            //Check if color has 6 or 3 characters and get values
            if (strlen($color) == 6) {
                $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
            } elseif ( strlen( $color ) == 3 ) {
                $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
            } else {
                return $default;
            }
         
            //Convert hexadec to rgb
            $rgb =  array_map('hexdec', $hex);
         
            //Check if opacity is set(rgba or rgb)
            if($opacity){
                if(abs($opacity) > 1)
                    $opacity = 1.0;
                $output = 'rgba('.implode(",",$rgb).','.$opacity.')';
            } else {
                $output = 'rgb('.implode(",",$rgb).')';
            }
         
            //Return rgb(a) color string
            return $output;
        }

        /**
         * Theme Dynamic CSS
         *
         * @package Victim
         * @since 1.0
         */
        public function victim_spaing_elements( $css ) {
            //Typography
            $body_font = Victim_Utility::theme_options( array('body_font', 'Roboto Slab' ) );
            $body_font_color = Victim_Utility::theme_options( array('body_font_color', '#434343' ) );

            $site_title_font = Victim_Utility::theme_options( array('site_title_font', 'Poppins' ) );
            $site_form_fields = Victim_Utility::theme_options( array('input_form', 'Roboto Slab' ) );
            $site_button = Victim_Utility::theme_options( array('button_typo', 'Poppins' ) );

            $site_title_font_color = Victim_Utility::theme_options( array('site_branding_color', '#000000' ) );
            $site_description_font_color = Victim_Utility::theme_options( array('site_description_color', '#858585' ) );

            $headings_font = Victim_Utility::theme_options( array('headings_font', 'Poppins' ) );

            $victim_color = Victim_Utility::theme_options(array('theme_color', '#f7f7f7'));
            $victim_text_color = Victim_Utility::theme_options(array('theme_text_color', '#202020'));

            //rgba color
            $victim_rgba_color = $this->victim_hex_2_rgba($victim_color, 0.90);

            $victim_secondary_color = Victim_Utility::theme_options(array('theme_secondary_color', '#000000'));

            //Blog Wrapper Padding
            $blog_wrap_desktop_top = Victim_Utility::theme_options( array('top_padding', 90) );
            $blog_wrap_desktop_bottom = Victim_Utility::theme_options( array('bottom_padding', 60) );            
            $blog_wrap_tablet_top = Victim_Utility::theme_options( array('tablet_top_padding', 90) );
            $blog_wrap_tablet_bottom = Victim_Utility::theme_options( array('tablet_bottom_padding', 60) );
            $blog_wrap_mobile_top = Victim_Utility::theme_options( array('mobile_top_padding', 90) );
            $blog_wrap_mobile_bottom = Victim_Utility::theme_options( array('mobile_bottom_padding', 60) );            

            //Blog Wrapper Padding
            $blog_single_wrap_desktop_top = Victim_Utility::theme_options( array('blog_single_top_padding', 105) );
            $blog_single_wrap_desktop_bottom = Victim_Utility::theme_options( array('blog_single_bottom_padding', 30) );            
            $blog_single_wrap_tablet_top = Victim_Utility::theme_options( array('blog_single_tablet_top_padding', 105) );
            $blog_single_wrap_tablet_bottom = Victim_Utility::theme_options( array('blog_single_tablet_bottom_padding', 30) );
            $blog_single_wrap_mobile_top = Victim_Utility::theme_options( array('blog_single_mobile_top_padding', 105) );
            $blog_single_wrap_mobile_bottom = Victim_Utility::theme_options( array('blog_single_mobile_bottom_padding', 30) );            

            //Blog Content Margin
            $blog_single_content_mr_desktop_top = Victim_Utility::theme_options( array('blog_single_top_margin', 0) );
            $blog_single_content_mr_desktop_bottom = Victim_Utility::theme_options( array('blog_single_bottom_margin', 0) );            
            $blog_single_content_mr_tablet_top = Victim_Utility::theme_options( array('blog_single_tablet_top_margin', 0) );
            $blog_single_content_mr_tablet_bottom = Victim_Utility::theme_options( array('blog_single_tablet_bottom_margin', 0) );
            $blog_single_content_mr_mobile_top = Victim_Utility::theme_options( array('blog_single_mobile_top_margin', 0) );
            $blog_single_content_mr_mobile_bottom = Victim_Utility::theme_options( array('blog_single_mobile_bottom_margin', 0) );

            //Page Wrapper Padding
            $page_wrap_desktop_top = Victim_Utility::theme_options( array('page_content_top_padding', 110) );
            $page_wrap_desktop_bottom = Victim_Utility::theme_options( array('page_content_bottom_padding', 75) );            
            $page_wrap_tablet_top = Victim_Utility::theme_options( array('page_content_tablet_top_padding', 110) );
            $page_wrap_tablet_bottom = Victim_Utility::theme_options( array('page_content_tablet_bottom_padding', 75) );
            $page_wrap_mobile_top = Victim_Utility::theme_options( array('page_content_mobile_top_padding', 90) );
            $page_wrap_mobile_bottom = Victim_Utility::theme_options( array('page_content_mobile_bottom_padding', 60) );

            //Logo Padding
            $logo_desktop_top = Victim_Utility::theme_options( 'logo_top_padding' );
            $logo_desktop_bottom = Victim_Utility::theme_options( 'logo_bottom_padding');
            $logo_tablet_top = Victim_Utility::theme_options( 'logo_tablet_top_padding');
            $logo_tablet_bottom = Victim_Utility::theme_options( 'logo_tablet_bottom_padding');
            $logo_mobile_top = Victim_Utility::theme_options( 'logo_mobile_top_padding');
            $logo_mobile_bottom = Victim_Utility::theme_options( 'logo_mobile_bottom_padding');  

            //Footer Padding
            $footer_desktop_top = Victim_Utility::theme_options( array('footer_top_padding', 0) );
            $footer_desktop_bottom = Victim_Utility::theme_options( array('footer_bottom_padding', 0) );
            $footer_tablet_top = Victim_Utility::theme_options( array('footer_tablet_top_padding', 0) );
            $footer_tablet_bottom = Victim_Utility::theme_options( array('footer_tablet_bottom_padding', 0) );
            $footer_mobile_top = Victim_Utility::theme_options( array('footer_mobile_top_padding', 0) );
            $footer_mobile_bottom = Victim_Utility::theme_options( array('footer_mobile_bottom_padding', 0) );

            $css = '';

            $content_padding_css = '';
            $tablet_content_padding_css = '';
            $mobile_content_padding_css = '';    

            $single_content_padding_css = '';
            $single_tablet_content_padding_css = '';
            $single_mobile_content_padding_css = '';                

            $single_content_margin_css = '';
            $single_tablet_content_margin_css = '';
            $single_mobile_content_margin_css = '';            

            $page_content_padding_css = '';
            $page_tablet_content_padding_css = '';
            $page_mobile_content_padding_css = '';

            $logo_desktop_padding_css = '';
            $logo_tablet_padding_css = '';
            $logo_mobile_padding_css = '';            

            $footer_desktop_padding_css = '';
            $footer_tablet_padding_css = '';
            $footer_mobile_padding_css = '';

            $menu_font = Victim_Utility::meta_options('menu_font');
            $menu_font_size = Victim_Utility::meta_options('menu_font_size');
            $menu_font_weight = Victim_Utility::meta_options('menu_font_weight');
            $menu_font_style = Victim_Utility::meta_options('menu_font_style');
            $menu_font_transform = Victim_Utility::meta_options('menu_font_transform');
            $menu_font_line_height = Victim_Utility::meta_options('menu_font_line_height');
            $menu_font_letter_spacing = Victim_Utility::meta_options('menu_font_latter_spacing');

            /**
             * Font Family
             */ 
            if ( ! empty( $body_font ) ) {
                victim_enqueue_google_font( $body_font );
                $css .= 'body {font-family: ' . $body_font . '; color: '.$body_font_color.'; }';
            }
            if( isset( $menu_font ) && '' != $menu_font  ) {
                victim_enqueue_google_font( Victim_Utility::meta_options('menu_font') );
                $css .= '.navigation .mainmenu > li > a { font-family: ' . $menu_font . ';}';
            } else {
                $css .= '.navigation .mainmenu > li > a { font-family: ' . Victim_Utility::theme_options( array('headings_font','Poppins') ) . ';}';
            }            

            if( isset( $menu_font_size ) && '' != $menu_font_size  ) {
                $css .= '.navigation .mainmenu > li > a { font-size: ' . $menu_font_size . ' !important;}';
            } else {
                $css .= '.navigation .mainmenu > li > a { font-size: ' . esc_attr( Victim_Utility::theme_options( array('menu_font_size', 18 ) ) ) . 'px !important;}';
            }

            if( isset( $menu_font_weight ) && '' != $menu_font_weight  ) {
                $css .= '.navigation .mainmenu > li > a { font-weight: ' . Victim_Utility::meta_options('menu_font_weight') . ' !important;}';
            }             

            if( isset( $menu_font_style ) && '' != $menu_font_style  ) {
                $css .= '.navigation .mainmenu > li > a { font-style: ' . $menu_font_style . ' !important;}';
            }             

            if( isset( $menu_font_transform ) && '' != $menu_font_transform ) {
                $css .= '.navigation .mainmenu > li > a { text-transform: ' . $menu_font_transform . ' !important;}';
            }             

            if( isset( $menu_font_line_height ) && '' != $menu_font_line_height   ) {
                $css .= '.navigation .mainmenu > li > a { line-height: ' . $menu_font_line_height . ' !important;}';
            } 

            if( isset( $menu_font_letter_spacing ) && '' != $menu_font_letter_spacing  ) {
                $css .= '.navigation .mainmenu > li > a { letter-spacing: ' . $menu_font_letter_spacing . ' !important;}';
            } 

            // Heading Fonts
            $css .= 'h1, h2, h3, h4, h5, h6 { color: '. Victim_Utility::theme_options( array('heading_font_color', '#101010' ) ) .';}';

            $css .= 'body { font-size: ' . esc_attr( Victim_Utility::theme_options( array('body_font_size', 16 ) ) ) .'px;}';
            if ( ! empty( $headings_font ) ) {
                victim_enqueue_google_font( $headings_font );
                $css .= 'h1, h2, h3, h4, h5, h6 { font-family: ' . $headings_font . '; }';
                $css .= '.hamburger-wrapper .mainmenu > li > a, .woocommerce div.product .woocommerce-tabs ul.tabs li { font-family: ' . $headings_font . ';} ';
                $css .= '.blog-block .grid-layout .entry-title, .blog-latest-items article.page .entry-title { font-size: ' . esc_attr( Victim_Utility::theme_options( array('post_title_content', 30 ) ) ) . 'px !important;}';
                $css .= '.blog-single-page>article .entry-title { font-size: ' . esc_attr( Victim_Utility::theme_options( array('post_single_title_content', 50 ) ) ) . 'px !important;}';
                $css .= '.more-link { font-family: ' . $headings_font . ';}';
                $css .= 'h1 { font-size: ' . esc_attr( Victim_Utility::theme_options( array('heading_one_content', 2.441 ) ) ) . 'em;}';
                $css .= 'h2 { font-size: ' . esc_attr( Victim_Utility::theme_options( array('heading_two_content', 1.953 ) ) ) . 'em;}';
                $css .= 'h3 { font-size: ' . esc_attr( Victim_Utility::theme_options( array('heading_three_content', 1.563 ) ) ) . 'em;}';
                $css .= 'h4 { font-size: ' . esc_attr( Victim_Utility::theme_options( array('heading_four_content', 1.25 ) ) ) . 'em;}';
                $css .= 'h5 { font-size: ' . esc_attr( Victim_Utility::theme_options( array('heading_five_content', 1 ) ) ) . 'em;}';
                $css .= 'h6 { font-size: ' . esc_attr( Victim_Utility::theme_options( array('heading_six_content', 0.8 ) ) ) . 'em;}';
                $css .= '.site-footer .footer-top-block>.container .widget .widget-title, .site-footer .footer-top-block>.container-fluid .widget .widget-title { font-size: ' . esc_attr( Victim_Utility::theme_options( array('footer_widget_title_font_size', 22 ) ) ) . 'px;}';
                $css .= '.site-footer .footer-top-block>.container .widget, .site-footer .footer-top-block>.container-fluid .widget { font-size: ' . esc_attr( Victim_Utility::theme_options( array('footer_widget_content_font_size', 16 ) ) ) . 'px;}';
                $css .= '.site-footer .footer-top-block>.container .widget, .site-footer .footer-top-block>.container-fluid .widget { line-height: ' . esc_attr( Victim_Utility::theme_options( array('footer_widget_content_font_line_height', 1.65 ) ) ) . 'em;}';
                $css .= '.sidebar-block .widget-title { font-size: ' . esc_attr( Victim_Utility::theme_options( array('widget_title_font_size', 14 ) ) ) . 'px;}';
            }

            if(!empty($site_title_font)) {
                victim_enqueue_google_font( $site_title_font );

                $site_logo_font = Victim_Utility::theme_options( array('site_title_font_size', 1.25 ) );
                $css .= '.site-branding-text .site-title { font-family: ' . $site_title_font . '; font-size: '. esc_attr( $site_logo_font ) .'em; color: '. $site_title_font_color .';}';
                $css .= '.form-controller, .form-control { font-family: ' . $site_form_fields . ';}';
                $css .= '.posts-loadmore a, .btn, .button, .added_to_cart.wc-forward { font-family: ' . $site_button . ';}';
            }

            /**
             * End Typography
             */ 

            // Header Text Color
            $header_text_color = get_theme_mod('header_textcolor');
            if(!empty( $header_text_color) && $header_text_color !== 'blank' ) {
                $css .= '.hero-block .victim-title, .hero-block .woocommerce-products-header__title.page-title { color: '. $header_text_color .';  }';
            } else {
                $head_text_color = 'ffffff';
                $css .= '.hero-block .victim-title, .hero-block .woocommerce-products-header__title.page-title { color: #ffffff;  }';
            }

            // Header Background color 
            $header_background = Victim_Utility::meta_options('dark_bg_header');
            if( isset( $header_background ) && '' != $header_background  ) { 
                $css .= 'header.site-header { background: '. $header_background .';  }';
                $css .= 'header.sticky-show { background-color: '. $header_background .' !important; }';
            } else {
                $css .= 'header.site-header { background-color: '. Victim_Utility::theme_options( array('theme_header_background_colors','#ffffff') ) .'; }';
                $css .= 'header.sticky-show { background-color: '. Victim_Utility::theme_options( array('theme_header_background_colors','#ffffff') ) .' !important; }';
            }                

            // Header Border Bottom color
            $header_border = Victim_Utility::meta_options('dark_bg_border_color');
            if( isset( $header_border ) && '' != $header_border  ) { 
                $css .= 'header.site-header { border-bottom-color: '. $header_border .';  }';
            } else {
                $css .= 'header.site-header { border-bottom-color: '. Victim_Utility::theme_options( array('theme_header_border_colors', '#e4e0d8') ) .'; }';
            }  

            // Menu Main color
            $menu_color = Victim_Utility::meta_options('menu_colors');
            if( isset( $menu_color ) && '' != $menu_color ) { 
                $css .= '@media only screen and (min-width: 992px) { .navigation .mainmenu > li > a { color: '. $menu_color .' !important;  } }';
            } else {
                $css .= '@media only screen and (min-width: 992px) { .navigation .mainmenu > li > a { color: '. Victim_Utility::theme_options( array( 'menu_color', '#252424' )) .'!important;  } }';
            }

            // Header Height
            if( Victim_Utility::theme_options( array( 'header_heights', '130'  ) ) ) { 
                $css .= '.site-branding, header.site-header .menu-content { height: '. Victim_Utility::theme_options( array('header_heights', '130') ) .'px }';
                $css .= '.hero-block.header-transparent { padding-top: '. Victim_Utility::theme_options( array('header_heights', '130') ) .'px }';
                $css .= '.blog-block-single.blog-single-spacing.header-transparent { padding-top: '. Victim_Utility::theme_options( array('header_heights', '130') ) .'px }';
                $css .= '.shop-single-contents.header-transparent { padding-top: '. Victim_Utility::theme_options( array('header_heights', '130') ) .'px }';
            }           

            // Dropdown Menu background colors
            if( Victim_Utility::theme_options( array( 'main_menu_hover_color', '#313131' ) ) ) { 
                $css .= '@media only screen and (min-width: 992px) { .navigation .mainmenu > li > a:hover { color: '. Victim_Utility::theme_options( array('main_menu_hover_color', '#313131') ) .'; }}';
            }              

            // Menu indicator color
            if( Victim_Utility::theme_options( array( 'main_menu_separator_color', '#313131' ) ) ) { 
                $css .= '@media only screen and (min-width: 992px) { .navigation .mainmenu > li:after { background: '. Victim_Utility::theme_options( array('main_menu_separator_color', '#f44e2b') ) .'; }}';
            }              

            // Sub Menu Background
            if( Victim_Utility::theme_options( array( 'main_menu_separator_color', '#313131' ) ) ) { 
                $css .= '@media only screen and (min-width: 992px) { .mainmenu .sub-menu, .mainmenu .sub-menu .sub-menu, .mainmenu .sub-menu .sub-menu .sub-menu, .shoping-cart .header-cart-dropdown { background: '. Victim_Utility::theme_options(array('dropdown_menu_bg', '#1d2023')) .'; }}';
            }             

            // Sub Menu Background
            if( Victim_Utility::theme_options( array( 'main_menu_separator_color', '#f7f7f7' ) ) ) { 
                $css .= '@media only screen and (min-width: 992px) { .mainmenu .sub-menu li a { color: '. Victim_Utility::theme_options(array('dropdown_menu_color', '#f7f7f7')) .'; }}';
            }              

            if( Victim_Utility::theme_options( array( 'mobile_menu_hamburger_color', '#12141c' ) ) ) { 
                $css .= '@media only screen and (max-width: 992px) { .hamburger-menu .hamburger-content, .hamburger-menu .hamburger-content:before, .hamburger-menu .hamburger-content:after { background: '. Victim_Utility::theme_options(array('mobile_menu_hamburger_color', '#12141c')) .'; }}';
            }              

            if( Victim_Utility::theme_options( array( 'mobile_menu_bg', '#12141c' ) ) ) { 
                $css .= '@media only screen and (max-width: 992px) { header .mainmenu { background: '. Victim_Utility::theme_options(array('mobile_menu_bg', '#12141c')) .'; }}';
            }  

            if( Victim_Utility::theme_options( array( 'mobile_menu_color', '#ffffff' ) ) ) { 
                $css .= '@media only screen and (max-width: 992px) { header .mainmenu li a { color: '. Victim_Utility::theme_options(array('mobile_menu_color', '#ffffff')) .' !important; }}';
            }  

            // Theme Input Border Color
            if( Victim_Utility::theme_options( array( 'theme_input_border', '#e4e0d8' ) ) ) { 
                $css .= '.widget_links ul li, .widget_meta ul li, .widget_nav_menu ul li, .widget_pages ul li, .widget_recent_comments ul li, .widget_recent_entries ul li, .widget_product_categories ul li, .widget_categories ul li, .widget_archive ul li, .widget_layered_nav ul li { border-top-color: '. Victim_Utility::theme_options(array('theme_input_border', '#e4e0d8')) .'; } .widget_search .form-control, .widget_product_search .form-control, .widget select { border-color:  '. Victim_Utility::theme_options(array('theme_input_border', '#e4e0d8')) .'; }';

                $css .= '.woocommerce-form-coupon input { border-color: '. Victim_Utility::theme_options(array('theme_input_border', '#e4e0d8')) .' }';
                $css .= '#review_form_wrapper .comment-respond .comment-form>p>textarea[name="comment"], #review_form_wrapper .comment-respond .comment-form>.comment-form-rating>textarea[name="comment"], #review_form_wrapper .comment-respond .comment-form>p>input[type="text"], #review_form_wrapper .comment-respond .comment-form>p>input[type="email"], #review_form_wrapper .comment-respond .comment-form>.comment-form-rating>input[type="text"], #review_form_wrapper .comment-respond .comment-form>.comment-form-rating>input[type="email"], .form-controller, .form-control, .woocommerce #reviews #comments ol.commentlist li .comment-text { border-color: '. Victim_Utility::theme_options(array('theme_input_border', '#e4e0d8')) .' }';
            }  

            // Light version Body Background
            $theme_light_bg = Victim_Utility::meta_options('body_bg_colors');
            if( Victim_Utility::theme_options( array( 'theme_background_light_color', '#ffffff' ) ) ) { 
                $css .= 'body:not(.custom-background) .light-version { background: '. Victim_Utility::theme_options(array('theme_background_light_color', '#ffffff')) .'; }';
            }            

            if( isset( $theme_light_bg ) && '' != $theme_light_bg ) {
                $css .= '.victim-body { background: '. $theme_light_bg .'; }';          
            }

            if( Victim_Utility::meta_options('fixed_footer') == 'yes' ) {
                $css .= 'body:not(.custom-background) .light-version .portfolio-main, body:not(.custom-background) .light-version .shop-main-content, body:not(.custom-background) .light-version .blog-block, .error-page-block, .blog-block-single { background: '. Victim_Utility::theme_options(array('theme_background_light_color', '#ffffff')) .'; }';
            } elseif(Victim_Utility::theme_options('fixed_footer') == true ) {
                $css .= 'body:not(.custom-background) .light-version .portfolio-main, body:not(.custom-background) .light-version .shop-main-content, body:not(.custom-background) .light-version .blog-block, .error-page-block, .blog-block-single { background: '. Victim_Utility::theme_options(array('theme_background_light_color', '#ffffff')) .'; }';
            }

            // Dark version Body Background
            if(  Victim_Utility::theme_options( array( 'theme_background_dark_color', '#333333' ) ) ) { 
                $css .= 'body:not(.custom-background) .dark-version { background: '. Victim_Utility::theme_options(array('theme_background_dark_color', '#333333')) .'; }';
            }            
            if( Victim_Utility::theme_options( array( 'theme_text_dark_color', '#3c3c3c' ) ) ) { 
                $css .= '.theme-dark { color: '. Victim_Utility::theme_options(array('theme_text_dark_color', '#3c3c3c')) .'; }';
            }

            // Preloader
            if( Victim_Utility::theme_options( array( 'theme_preloader_bg', '#12141c' ) ) ) { 
                $css .= '.preloader { background-color: '. Victim_Utility::theme_options(array('theme_preloader_bg', '#12141c')) .'; }';
            }            

            if( Victim_Utility::theme_options( array( 'theme_preloader_buble_color', '#e51681' ) ) ) { 
                $css .= '.preloader-icon span { background-color: '. Victim_Utility::theme_options(array('theme_preloader_buble_color', '#e51681')) .'; }';
            }   

            // Site Branding Heading
            if(  Victim_Utility::theme_options( array( 'site_branding_color', '#000000' ) ) ) { 
                $css .= '.site-branding-text .site-title { color: '. Victim_Utility::theme_options(array('site_branding_color', '#000000')) .'; }';
            }            

            if( Victim_Utility::theme_options( array( 'site_description_color', '#858585' ) ) ) { 
                $css .= '.site-branding-text .site-description { color: '. Victim_Utility::theme_options(array('site_description_color', '#858585')) .'; }';
            }

            // Footer Color
            $footer_link_color = Victim_Utility::meta_options('footer_link_color');   
            $footer_text_color = Victim_Utility::meta_options('footer_text');   
            $footer_bg_color = Victim_Utility::meta_options('footer_background');   
            if( isset( $footer_link_color ) && '' != $footer_link_color ) { 
                $css .= 'footer.site-footer { color: '. $footer_link_color .'; }';
            } else {
                $css .= 'footer.site-footer { color: '. Victim_Utility::theme_options(array('footer_color', '#505050')) .'; }';
            }     

            if( isset( $footer_bg_color ) && '' != $footer_bg_color ) { 
                $css .= 'footer.site-footer { background: '. $footer_bg_color .'; }';
            } else {
                $css .= 'footer.site-footer { background: '. Victim_Utility::theme_options(array('footer_bg_colors', '#ffffff')) .'; }';
            }       

            $css .= 'footer.site-footer h3.widget-title { color: '. Victim_Utility::theme_options(array('footer_widget_title', '#000000')) .' !important; }';   

            $css .= 'footer.site-footer h1, footer.site-footer h2,footer.site-footer h3,footer.site-footer h4,footer.site-footer h5,footer.site-footer h6 { color: '. Victim_Utility::theme_options(array('footer_widget_title', '#505050')) .' !important; }';   

            $css .= 'footer .widget_links ul li, footer .widget_meta ul li, footer  .widget_nav_menu ul li, footer .widget_pages ul li, footer .widget_recent_comments ul li, footer .widget_recent_entries ul li, footer .widget_product_categories ul li, footer .widget_categories ul li, footer .widget_archive ul li, footer .widget_layered_nav ul li { border-top-color: '. Victim_Utility::theme_options(array('footer_color', '#e4e0d8')) .'73; } .widget_search .form-control, .widget_product_search .form-control, .widget select { border-color:  '. Victim_Utility::theme_options(array('footer_color', '#e4e0d8')) .'73; }';

            if( isset( $footer_link_color ) && '' != $footer_link_color ) { 
                $css .= 'footer.site-footer a, .site-footer .footer-social li a  { color: '. $footer_link_color .'; }';
            } else {
                $css .= 'footer.site-footer a, .site-footer .footer-social li a  { color: '. Victim_Utility::theme_options(array('footer_link_color', '#000000')) .'; }';
            }           

            if(  Victim_Utility::meta_options( 'footer_link_hover_color' )  ) { 
                $css .= 'footer .copyright-text i, footer a:hover, .site-footer .footer-social li a:hover { color: '. Victim_Utility::meta_options( 'footer_link_hover_color' ) .'; }';
            } else {
                $css .= 'footer .copyright-text i, footer a:hover, .site-footer .footer-social li a:hover { color: '. Victim_Utility::theme_options(array('footer_link_hover_color', '#f68872')) .'; }';
            }            
            $css .= 'footer .copyright-text { color: '. Victim_Utility::theme_options(array('footer_copy_color', '#5e5e5e')) .' !important; }';
            $css .= 'footer .copyright-text { color: '. Victim_Utility::theme_options(array('footer_copy_border_top', '#5e5e5e')) .'; border-top: 1px solid '. Victim_Utility::theme_options(array('footer_copy_border_top', '#ebebeb')) .'; }';

            // Content top padding
            if ( isset( $blog_wrap_desktop_top ) && '' != $blog_wrap_desktop_top ) {
                $content_padding_css .= 'padding-top:'. $blog_wrap_desktop_top .'px;';
            }

            // Content bottom padding
            if ( isset( $blog_wrap_desktop_bottom ) && '' != $blog_wrap_desktop_bottom ) {
                $content_padding_css .= 'padding-bottom:'. $blog_wrap_desktop_bottom .'px;';
            }

            // Content padding css
            if ( isset( $blog_wrap_desktop_top ) && '' != $blog_wrap_desktop_top
                || isset( $blog_wrap_desktop_bottom ) && '' != $blog_wrap_desktop_bottom ) {
                $css .= '.blog-block {'. $content_padding_css .'}';
            }

            // Tablet content top padding
            if ( isset( $blog_wrap_tablet_top ) && '' != $blog_wrap_tablet_top ) {
                $tablet_content_padding_css .= 'padding-top:'. $blog_wrap_tablet_top .'px;';
            }

            // Tablet content bottom padding
            if ( isset( $blog_wrap_tablet_bottom ) && '' != $blog_wrap_tablet_bottom ) {
                $tablet_content_padding_css .= 'padding-bottom:'. $blog_wrap_tablet_bottom .'px;';
            }

            // Tablet content padding css
            if ( isset( $blog_wrap_tablet_top ) && '' != $blog_wrap_tablet_top
                || isset( $blog_wrap_tablet_bottom ) && '' != $blog_wrap_tablet_bottom ) {
                $css .= '@media (max-width: 768px){.blog-block {'. $tablet_content_padding_css .'}}';
            }

            // Mobile content top padding
            if ( isset( $blog_wrap_mobile_top ) && '' != $blog_wrap_mobile_top ) {
                $mobile_content_padding_css .= 'padding-top:'. $blog_wrap_mobile_top .'px;';
            }

            // Mobile content bottom padding
            if ( isset( $blog_wrap_mobile_bottom ) && '' != $blog_wrap_mobile_bottom ) {
                $mobile_content_padding_css .= 'padding-bottom:'. $blog_wrap_mobile_bottom .'px;';
            }

            // Mobile content padding css
            if ( isset( $blog_wrap_mobile_bottom ) && '' != $blog_wrap_mobile_bottom
                || isset( $blog_wrap_mobile_top ) && '' != $blog_wrap_mobile_top ) {
                $css .= '@media (max-width: 480px){.blog-block {'. $mobile_content_padding_css .'}}';
            } 

            // Page Content top padding
            if ( isset( $page_wrap_desktop_top ) && '' != $page_wrap_desktop_top ) {
                $page_content_padding_css .= 'padding-top:'. $page_wrap_desktop_top .'px;';
            }

            // Page Content bottom padding
            if ( isset( $page_wrap_desktop_bottom ) && '' != $page_wrap_desktop_bottom ) {
                $page_content_padding_css .= 'padding-bottom:'. $page_wrap_desktop_bottom .'px;';
            }

            // Page Content padding css
            if ( isset( $page_wrap_desktop_top ) && '' != $page_wrap_desktop_top
                || isset( $page_wrap_desktop_bottom ) && '' != $page_wrap_desktop_bottom ) {
                $css .= '.page-content-main {'. $page_content_padding_css .'}';
            }

            // Tablet Page content top padding
            if ( isset( $page_wrap_tablet_top ) && '' != $page_wrap_tablet_top ) {
                $page_tablet_content_padding_css .= 'padding-top:'. $page_wrap_tablet_top .'px;';
            }

            // Tablet Page content bottom padding
            if ( isset( $page_wrap_tablet_bottom ) && '' != $page_wrap_tablet_bottom ) {
                $page_tablet_content_padding_css .= 'padding-bottom:'. $page_wrap_tablet_bottom .'px;';
            }

            // Tablet Page content padding css
            if ( isset( $page_wrap_tablet_top ) && '' != $page_wrap_tablet_top
                || isset( $page_wrap_tablet_bottom ) && '' != $page_wrap_tablet_bottom ) {
                $css .= '@media (max-width: 768px){ .page-content-main {'. $page_tablet_content_padding_css .'}}';
            }         

            // Mobile Page content top padding
            if ( isset( $page_wrap_mobile_top ) && '' != $page_wrap_mobile_top ) {
                $page_mobile_content_padding_css .= 'padding-top:'. $page_wrap_mobile_top .'px;';
            }

            // Mobile Page content bottom padding
            if ( isset( $page_wrap_mobile_bottom ) && '' != $page_wrap_mobile_bottom ) {
                $page_mobile_content_padding_css .= 'padding-bottom:'. $page_wrap_mobile_bottom .'px;';
            }

            // Mobile Page content padding css
            if ( isset( $page_wrap_mobile_bottom ) && '' != $page_wrap_mobile_bottom
                || isset( $page_wrap_mobile_top ) && '' != $page_wrap_mobile_top ) {
                $css .= '@media (max-width: 480px){.page-content-main {'. $page_mobile_content_padding_css .'}}';
            }

            //logo top padding
            if ( isset( $logo_desktop_top ) && '' != $logo_desktop_top ) {
                $logo_desktop_padding_css .= 'padding-top:'. $logo_desktop_top .'px;';
            }            

            //logo bottom padding
            if ( isset( $logo_desktop_bottom ) && '' != $logo_desktop_bottom ) {
                $logo_desktop_padding_css .= 'padding-bottom:'. $logo_desktop_bottom .'px;';
            }

            // logo padding css
            if ( isset( $logo_desktop_top ) && '' != $logo_desktop_top
                || isset( $logo_desktop_bottom ) && '' != $logo_desktop_bottom ) {
                $css .= '@media (min-width: 992px) {.site-branding {'. $logo_desktop_padding_css .'}}';
            }

            //logo tablet top padding
            if ( isset( $logo_tablet_top ) && '' != $logo_tablet_top ) {
                $logo_tablet_padding_css .= 'padding-top:'. $logo_tablet_top .'px;';
            }            

            //logo tablet bottom padding
            if ( isset( $logo_tablet_bottom ) && '' != $logo_tablet_bottom ) {
                $logo_tablet_padding_css .= 'padding-bottom:'. $logo_tablet_bottom .'px;';
            }

            // logo tablet padding css
            if ( isset( $logo_tablet_top ) && '' != $logo_tablet_top
                || isset( $logo_tablet_bottom ) && '' != $logo_tablet_bottom ) {
                $css .= '@media (max-width: 991px){ .site-branding {'. $logo_tablet_padding_css .'}}';
            }

            //logo mobile top padding
            if ( isset( $logo_mobile_top ) && '' != $logo_mobile_top ) {
                $logo_mobile_padding_css .= 'padding-top:'. $logo_mobile_top .'px;';
            }            

            //logo mobile bottom padding
            if ( isset( $logo_mobile_bottom ) && '' != $logo_mobile_bottom ) {
                $logo_mobile_padding_css .= 'padding-bottom:'. $logo_mobile_bottom .'px;';
            }

            // logo mobile padding css
            if ( isset( $logo_mobile_top ) && '' != $logo_mobile_top
                || isset( $logo_mobile_bottom ) && '' != $logo_mobile_bottom ) {
                $css .= '@media (max-width: 480px){ .site-branding {'. $logo_mobile_padding_css .'}}';
            }

            //Single Blog top padding
            if ( isset( $blog_single_wrap_desktop_top ) && '' != $blog_single_wrap_desktop_top ) {
                $single_content_padding_css .= 'padding-top:'. $blog_single_wrap_desktop_top .'px;';
            }            

            //Single Blog bottom padding
            if ( isset( $blog_single_wrap_desktop_bottom ) && '' != $blog_single_wrap_desktop_bottom ) {
                $single_content_padding_css .= 'padding-bottom:'. $blog_single_wrap_desktop_bottom .'px;';
            }

            // Single Blog padding css
            if ( isset( $blog_single_wrap_desktop_top ) && '' != $blog_single_wrap_desktop_top
                || isset( $blog_single_wrap_desktop_bottom ) && '' != $blog_single_wrap_desktop_bottom ) {
                $css .= '.blog-single-spacing {'. $single_content_padding_css .'}';
            }

            //Single Blog tablet top padding
            if ( isset( $blog_single_wrap_tablet_top ) && '' != $blog_single_wrap_tablet_top ) {
                $single_tablet_content_padding_css .= 'padding-top:'. $blog_single_wrap_tablet_top .'px;';
            }            

            //Single Blog tablet bottom padding
            if ( isset( $blog_single_wrap_tablet_bottom ) && '' != $blog_single_wrap_tablet_bottom ) {
                $single_tablet_content_padding_css .= 'padding-bottom:'. $blog_single_wrap_tablet_bottom .'px;';
            }

            // Single Blog tablet padding css
            if ( isset( $blog_single_wrap_tablet_top ) && '' != $blog_single_wrap_tablet_top
                || isset( $blog_single_wrap_tablet_bottom ) && '' != $blog_single_wrap_tablet_bottom ) {
                $css .= '@media (max-width: 768px){ .blog-single-spacing {'. $single_tablet_content_padding_css .'}}';
            }

            //Single Blog mobile top padding
            if ( isset( $blog_single_wrap_mobile_top ) && '' != $blog_single_wrap_mobile_top ) {
                $single_mobile_content_padding_css .= 'padding-top:'. $blog_single_wrap_mobile_top .'px;';
            }            

            //Single Blog mobile bottom padding
            if ( isset( $blog_single_wrap_mobile_bottom ) && '' != $blog_single_wrap_mobile_bottom ) {
                $single_mobile_content_padding_css .= 'padding-bottom:'. $blog_single_wrap_mobile_bottom .'px;';
            }

            // Single Blog mobile padding css
            if ( isset( $blog_single_wrap_mobile_top ) && '' != $blog_single_wrap_mobile_top
                || isset( $blog_single_wrap_mobile_bottom ) && '' != $blog_single_wrap_mobile_bottom ) {
                $css .= '@media (max-width: 480px){ .blog-single-spacing {'. $single_mobile_content_padding_css .'}}';
            }

            //Single Blog top padding
            if ( isset( $blog_single_content_mr_desktop_top ) && '' != $blog_single_content_mr_desktop_top ) {
                $single_content_margin_css .= 'margin-top:'. $blog_single_content_mr_desktop_top .'px;';
            }            

            //Single Blog bottom margin
            if ( isset( $blog_single_content_mr_desktop_bottom ) && '' != $blog_single_content_mr_desktop_bottom ) {
                $single_content_margin_css .= 'margin-bottom:'. $blog_single_content_mr_desktop_bottom .'px;';
            }

            // Single Blog margin css
            if ( isset( $blog_single_content_mr_desktop_top ) && '' != $blog_single_content_mr_desktop_top
                || isset( $blog_single_content_mr_desktop_bottom ) && '' != $blog_single_content_mr_desktop_bottom ) {
                $css .= 'body.single-post .blog-block-single .blog-single-page > article {'. $single_content_margin_css .'}';
            } else {
                $css .= 'body.single:not(.woocommerce) .hero-block.bg-soft-black {display: none}';
            }

            //Single Blog tablet top margin
            if ( isset( $blog_single_content_mr_tablet_top ) && '' != $blog_single_content_mr_tablet_top ) {
                $single_tablet_content_margin_css .= 'margin-top:'. $blog_single_content_mr_tablet_top .'px;';
            }            

            //Single Blog tablet bottom margin
            if ( isset( $blog_single_content_mr_tablet_bottom ) && '' != $blog_single_content_mr_tablet_bottom ) {
                $single_tablet_content_margin_css .= 'margin-bottom:'. $blog_single_content_mr_tablet_bottom .'px;';
            }

            // Single Blog tablet margin css
            if ( isset( $blog_single_content_mr_tablet_top ) && '' != $blog_single_content_mr_tablet_top
                || isset( $blog_single_content_mr_tablet_bottom ) && '' != $blog_single_content_mr_tablet_bottom ) {
                $css .= '@media (max-width: 768px){ body.single-post .blog-block-single .blog-single-page > article {'. $single_tablet_content_margin_css .'}}';
            }

            //Single Blog mobile top margin
            if ( isset( $blog_single_content_mr_mobile_top ) && '' != $blog_single_content_mr_mobile_top ) {
                $single_mobile_content_margin_css .= 'margin-top:'. $blog_single_content_mr_mobile_top .'px;';
            }            

            //Single Blog mobile bottom margin
            if ( isset( $blog_single_content_mr_mobile_bottom ) && '' != $blog_single_content_mr_mobile_bottom ) {
                $single_mobile_content_margin_css .= 'margin-bottom:'. $blog_single_content_mr_mobile_bottom .'px;';
            }

            // Single Blog mobile margin css
            if ( isset( $blog_single_content_mr_mobile_top ) && '' != $blog_single_content_mr_mobile_top
                || isset( $blog_single_content_mr_mobile_bottom ) && '' != $blog_single_content_mr_mobile_bottom ) {
                $css .= '@media (max-width: 480px){ body.single-post .blog-block-single .blog-single-page > article {'. $single_mobile_content_margin_css .'}}';
            }

            //Footer padding
            if ( isset( $footer_desktop_top ) && '' != $footer_desktop_top ) {
                $footer_desktop_padding_css .= 'padding-top:'. $footer_desktop_top .'px;';
            }            

            //Footer bottom padding
            if ( isset( $footer_desktop_bottom ) && '' != $footer_desktop_bottom ) {
                $footer_desktop_padding_css .= 'padding-bottom:'. $footer_desktop_bottom .'px;';
            }

            // Footer padding css
            if ( isset( $footer_desktop_top ) && '' != $footer_desktop_top
                || isset( $footer_desktop_bottom ) && '' != $footer_desktop_bottom ) {
                $css .= '.site-footer {'. $footer_desktop_padding_css .'}';
            }

            //Footer tablet top padding
            if ( isset( $footer_tablet_top ) && '' != $footer_tablet_top ) {
                $footer_tablet_padding_css .= 'padding-top:'. $footer_tablet_top .'px;';
            }            

            //Footer tablet bottom padding
            if ( isset( $footer_tablet_bottom ) && '' != $footer_tablet_bottom ) {
                $footer_tablet_padding_css .= 'padding-bottom:'. $footer_tablet_bottom .'px;';
            }

            // Footer tablet padding css
            if ( isset( $footer_tablet_top ) && '' != $footer_tablet_top
                || isset( $footer_tablet_bottom ) && '' != $footer_tablet_bottom ) {
                $css .= '@media (max-width: 768px){ .site-footer {'. $footer_tablet_padding_css .'}}';
            }

            //Footer mobile top padding
            if ( isset( $footer_mobile_top ) && '' != $footer_mobile_top ) {
                $footer_mobile_padding_css .= 'padding-top:'. $footer_mobile_top .'px;';
            }            

            //Footer mobile bottom padding
            if ( isset( $footer_mobile_bottom ) && '' != $footer_mobile_bottom ) {
                $footer_mobile_padding_css .= 'padding-bottom:'. $footer_mobile_bottom .'px;';
            }

            //Footer mobile padding css
            if ( isset( $footer_mobile_top ) && '' != $footer_mobile_top
                || isset( $footer_mobile_bottom ) && '' != $footer_mobile_bottom ) {
                $css .= '@media (max-width: 480px){ .site-footer {'. $footer_mobile_padding_css .'}}';
            }

            //Logo Width Width
            if( Victim_Utility::theme_options('logo_max_width') ) { 
                $css .= '.site-branding .custom-logo { max-width: '. Victim_Utility::theme_options(array('logo_max_width', 215)) .'px; }';
            }               

            //Dropdown Menu Width
            if( Victim_Utility::theme_options('dropdown_menu_width') ) { 
                $css .= '@media only screen and (min-width: 1199px) { .mainmenu .sub-menu { min-width: '. Victim_Utility::theme_options(array('dropdown_menu_width', '220px')) .'; } }';
            }    

            // CSS From Post Meta
            $page_top_pd = Victim_Utility::meta_options('content_padding_top');
            $page_bottom_pd = Victim_Utility::meta_options('content_padding_bottom');
            $article_top_pd = Victim_Utility::meta_options('article_spacing_top');
            $article_bottom_pd = Victim_Utility::meta_options('article_spacing_bottom');
            $menu_active_color = Victim_Utility::meta_options('menu_active_colors');
            if( isset( $page_top_pd ) && '' != $page_top_pd  ) { 
                $css .= '.page-content-main { padding-top: '. $page_top_pd .' !important;  }';
            }          

            if( isset( $page_bottom_pd ) && '' != $page_bottom_pd  ) { 
                $css .= '.page-content-main { padding-bottom: '. $page_bottom_pd .' !important;  }';
            }            

            if( isset( $article_top_pd ) && '' != $article_top_pd ) { 
                $css .= '.blog-single-page .post { margin-top: '. $article_top_pd .' !important;  }';
            }            

            if( isset( $article_bottom_pd ) && '' != $article_bottom_pd ) { 
                $css .= '.blog-single-page .post { margin-bottom: '. $article_bottom_pd .' !important;  }';
            } 

            // Link Hover color
            if(  Victim_Utility::theme_options( array( 'theme_link_hover', '#FF0066' ) ) ) { 
                $css .= 'main a:not(.btn):hover, main a:not(.button):hover, article .grid-layout .post-meta .entry-author a, .blog-block-single .entry-content a:hover, .post .entry-title a:hover, .post .grid-layout .entry-title:hover a, .blog-latest-items article.page .entry-title:hover a { color: '. Victim_Utility::theme_options( array( 'theme_link_hover', '#FF0066' ) ) .'  }';
                $css .= 'article .grid-layout .post-thumb a:after { background: '. Victim_Utility::theme_options( array( 'theme_link_hover', '#FF0066' ) ) .'cc;  }';
            } 

            if( isset( $menu_active_color ) && '' != $menu_active_color ) {
                $css .= '@media only screen and (min-width: 993px) { header.site-header .navigation .mainmenu>li>a:after{ background: '. $menu_active_color .'; } }';
            } else {
                $css .= '@media only screen and (min-width: 993px) { header.site-header .navigation .mainmenu>li>a:after{ background: '. Victim_Utility::theme_options( array( 'theme_link_hover', '#FF0066' ) ) .'; } }';
            }         

            // Main theme color
            if(  $victim_color ) { 
                $css .= 'pre, blockquote { background: '. $victim_color .'80; }';
                $css .= '.shop-single-contents div.product form.cart .button:hover,#review_form_wrapper .comment-respond .comment-form .form-submit input#submit:hover, .posts-loadmore a:hover { background: '. $victim_color .'; }';
                $css .= '.woocommerce div.product .woocommerce-tabs ul.tabs li { background: '. $victim_color .'; }';
                $css .= '.wc-proceed-to-checkout .checkout-button.button:hover { background: '. $victim_color .'!important; }';
                $css .= '.woocommerce-checkout span.woocommerce-input-wrapper input, .woocommerce-checkout span.woocommerce-input-wrapper textarea, .select2-container--default .select2-selection--single { border-color: '. $victim_color .' }';
                $css .= '.select2-container--default .select2-selection--single, .select2-dropdown { background: '. $victim_color .' }';
                $css .= '.woocommerce #payment #place_order:hover, .woocommerce-page #payment #place_order:hover { background: '. $victim_color .' !important; }';
                $css .= '.post .list-layout .post-category a, .blog-latest-items article.page .list-layout .post-category a, article .grid-featurs-layout .post-category a { background: '. $victim_color .'99; }';
                $css .= '.pagination-link>li a { background: '. $victim_color .'99; }';
                $css .= '.heading-border { background: '. $victim_color .'; }';
                $css .= '.sidebar-block .widget-title:before { background: '. $victim_color .'; }';
                $css .= '.comment-respond #submit:hover, .comment-respond .submit:hover { border-color: '. $victim_color .'; color: '. $victim_color .'; }';
                $css .= '.woocommerce-form-login input[type="text"], .woocommerce-form-login input[type="password"] { border-color: '. $victim_color .'; }';
                $css .= '.woocommerce-form-coupon button[name="apply_coupon"]:hover, .woocommerce-form-coupon input[name="apply_coupon"][type="button"]:hover, .woocommerce-form-coupon input[name="apply_coupon"][type="reset"]:hover, .woocommerce-form-coupon input[name="apply_coupon"][type="submit"]:hover, .added_to_cart.wc-forward:hover { background: '. $victim_color .' !important; }';
                $css .= '.return-to-shop a:hover, .woocommerce-form-login .woocommerce-button.button.woocommerce-form-login__submit:hover, .woocommerce-MyAccount-content .woocommerce-Button.button:hover  { background: '. $victim_color .' !important; }';
                $css .= '.tagcloud a:hover,.single-post-pagination a:hover { border-color: '. $victim_color .'; color: '. $victim_color .'; }';
                $css .= '#add_payment_method #payment, .woocommerce-cart #payment, .woocommerce-checkout #payment { background: '. $victim_color .'; }';
                $css .= '.woocommerce-error, .woocommerce-info, .woocommerce-message { background-color: '. $victim_color .'; }';
            } 

            if( $victim_text_color ) {
                $css .= '.post .list-layout .post-category a, .blog-latest-items article.page .list-layout .post-category a, article .grid-featurs-layout .post-category a, .post .grid-featurs-layout .more-link, .blog-latest-items article.page .grid-featurs-layout .more-link, .post .list-layout .more-link, .blog-latest-items article.page .list-layout .more-link, .woocommerce div.product .woocommerce-tabs ul.tabs li a { color: '. $victim_text_color .' !important; }';
            }

            // Secondary Color Elements
            if( $victim_secondary_color ) { 
                $css .= 'article .post-category>a  { background: '.$victim_secondary_color .'  }';
                $css .= '.post .list-layout .more-link:hover, .blog-latest-items article.page .list-layout .more-link:hover, .post .grid-featurs-layout .more-link:hover, .blog-latest-items article.page .grid-featurs-layout .more-link:hover, .sidebar-block .widget-title { background: '.$victim_secondary_color .'  }';
                $css .= '.sidebar-block .widget_search .btn, .sidebar-block .widget_search .btn:focus, .no-results.not-found .btn-default, .no-results.not-found .btn-default:hover, .no-results.not-found .btn-default:focus, .sidebar-block .btn:hover { background: '. $victim_secondary_color .'; }';
                $css .= '.sidebar-block .widget_search .btn, .no-results.not-found .btn-default { border-color: '. $victim_secondary_color .'; }';
                $css .= '.post .list-layout .more-link:hover, .blog-latest-items article.page .list-layout .more-link:hover, .post .grid-featurs-layout .more-link:hover, .blog-latest-items article.page .grid-featurs-layout .more-link:hover { background: '.$victim_secondary_color .'  }';
                $css .= '.posts-loadmore a:hover { color: '.$victim_secondary_color .' !important; }';
                 $css .= '.comment-reply-link { background: '. $victim_secondary_color .'; border-color: '. $victim_secondary_color .'; }';
                $css .= '.post .grid-featurs-layout .post-category a:hover, .blog-latest-items article.page .grid-featurs-layout .post-category a:hover, .post .list-layout .post-category a:hover, .blog-latest-items article.page .list-layout .post-category a:hover { background: '.$victim_secondary_color .'  }';
                $css .= '.pagination-link>li.active a { background: '.$victim_secondary_color .'  }';
                $css .= '.related-post-content .post-section-title:after, .comment-respond .comment-reply-title:after, .btn, .comment-respond #submit, .comment-respond .submit, .comments-area .comments-title:after { background: '.$victim_secondary_color .'  }';
                $css .= '.blog-single-page .blog-tag .tagcloud a:hover { background: '.$victim_secondary_color .'  }';
                $css .= '.comment-reply-link:hover { border:  1px solid '.$victim_secondary_color .' !important; background: '.$victim_secondary_color .'}';
                $css .= '.shop-single-contents div.product form.cart .button, .posts-loadmore a { background: '.$victim_secondary_color .' } ';
                $css .= '.wc-proceed-to-checkout .checkout-button.button{ background: '.$victim_secondary_color .' !important; } ';
                $css .= '.woocommerce #payment #place_order, .woocommerce-page #payment #place_order{ background: '.$victim_secondary_color .' !important; } ';
                $css .= '.woocommerce-form-coupon button[name="apply_coupon"], .woocommerce-form-coupon input[name="apply_coupon"][type="button"], .woocommerce-form-coupon input[name="apply_coupon"][type="reset"], .woocommerce-form-coupon input[name="apply_coupon"][type="submit"] { background: '.$victim_secondary_color .' !important; } ';
                $css .= '.return-to-shop a { background: '.$victim_secondary_color .' !important; } ';
                $css .= '.added_to_cart.wc-forward, .woocommerce-form-login .woocommerce-button.button.woocommerce-form-login__submit, .woocommerce-MyAccount-content .woocommerce-Button.button { background: '.$victim_secondary_color .' !important; } ';
                $css .= '.woocommerce-error, .woocommerce-info, .woocommerce-message{ border-top-color: '.$victim_secondary_color .' } ';
                $css .= '.woocommerce-error::before, .woocommerce-info::before, .woocommerce-message::before { color: '.$victim_secondary_color .' } ';
                $css .= '.cart-contents span.count { background: '.$victim_secondary_color .' } ';
                $css .= '.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt { background: '.$victim_secondary_color .' } ';
            }           

            // Return CSS
            if ( ! empty( $css ) ) {
                wp_add_inline_style( 'victim-main-style', Victim_Utility::minify_css( $css ) );
            }
        }
    }
}

Victim_CSS_Helpers::instance();