<?php
/**
 * Typography settings for both Victim
 *
 * @package Victim
 * @since 1.0
 */
/**
 * Include functions file for Font Family controls.
 */
get_template_part('inc/customizer/customizer-font-selector/font-functions');
get_template_part('inc/customizer/customizer-font-selector/class/class-font-selector');

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 *
 * @since 1.0
 */
function victim_customize_preview() {
	wp_enqueue_script( 'victim_-typo-customizer', get_theme_file_uri( '/inc/customizer/typography/js/typo-customizer.js' ), array( 'customize-preview' ), '1.0', true );
}

add_action( 'customize_preview_init', 'victim_customize_preview' );

/**
 * Customizer controls for typography settings.
 *
 * @param WP_Customize_Manager $wp_customize Customize manager.
 *
 * @since 1.0
 */
function victim_typography_settings( $wp_customize ) {
	/**
	 * Main typography panel
	 */
	$wp_customize->add_panel(
		'victim_typography_settings', array(
			'priority' => 25,
			'title'    => esc_html__( 'Typography Settings', 'victim' ),
		)
	);

	$wp_customize->add_section(
		'victim_typography', array(
			'title'    => esc_html__( 'Font Family', 'victim' ),
			'panel'    => 'victim_typography_settings',
			'priority' => 25,
		)
	);	

	/**
	 * Main typography Size
	 */
	$wp_customize->add_section(
		'victim_typography_size', array(
			'title'    => esc_html__( 'Font Size', 'victim' ),
			'panel'    => 'victim_typography_settings',
			'priority' => 25,
		)
	);

	/**
	 * Main typography Colors
	 */
	$wp_customize->add_section(
		'victim_typography_color', array(
			'title'    => esc_html__( 'Font Color', 'victim' ),
			'panel'    => 'victim_typography_settings',
			'priority' => 25,
		)
	);	

	$wp_customize->add_setting(
	    'victim_options[body_font_color]', array(
	        'capability' => 'edit_theme_options',
	        'sanitize_callback' => 'sanitize_hex_color',
	        'type'      =>  'theme_mod',
	        'transport'   => 'postMessage',
	        'default' => '#434343',
	    )
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control( $wp_customize, 'victim_options[body_font_color]', array(
	        	'label' => esc_html__('Body Font Color','victim'), 
	            'section' => 'victim_typography_color',
	        )
	    )
	);	
	$wp_customize->add_setting(
	    'victim_options[heading_font_color]', array(
	        'capability' => 'edit_theme_options',
	        'sanitize_callback' => 'sanitize_hex_color',
	        'type'      =>  'theme_mod',
	        'transport'   => 'postMessage',
	        'default' => '#101010',
	    )
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control( $wp_customize, 'victim_options[heading_font_color]', array(
	        	'label' => esc_html__('Headings Font Color','victim'), 
	            'section' => 'victim_typography_color',
	        )
	    )
	);

	/**
	 * ------------------
	 * 1. Font Family tab
	 * ------------------
	 */
	if ( class_exists( 'Victim_Font_Selector' ) ) {
		/**
		 * ---------------------------------
		 * 1.a. Headings font family control
		 * This control allows the user to choose a font family for all Headings used in the theme ( h1 - h6 )
		 * --------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[headings_font]', array(
				'type' => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 'Poppins',
			)
		);
		$wp_customize->add_control(
			new Victim_Font_Selector(
				$wp_customize, 'victim_options[headings_font]', array(
					'label'    => esc_html__( 'Headings font family', 'victim' ),
					'section'  => 'victim_typography',
					'priority' => 5,
					'type'     => 'select',
				)
			)
		);

		/**
		 * ---------------------------------
		 * 1.b. Body font family control
		 * This control allows the user to choose a font family for all elements in the body tag
		 * --------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[body_font]', array(
				'type' => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 'Roboto Slab',
			)
		);

		$wp_customize->add_control(
			new Victim_Font_Selector(
				$wp_customize, 'victim_options[body_font]', array(
					'label'    => esc_html__( 'Body font family', 'victim' ),
					'section'  => 'victim_typography',
					'priority' => 10,
					'type'     => 'select',
				)
			)
		);

		/**
		 * ---------------------------------
		 * Form Typography
		 * This control allows the user to choose a font family for all elements in the body tag
		 * --------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[input_form]', array(
				'type' => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 'Roboto Slab',
			)
		);

		$wp_customize->add_control(
			new Victim_Font_Selector(
				$wp_customize, 'victim_options[input_form]', array(
					'label'    => esc_html__( 'Form ( Input )', 'victim' ),
					'section'  => 'victim_typography',
					'priority' => 10,
					'type'     => 'select',
				)
			)
		);

		/**
		 * ---------------------------------
		 * Form Typography
		 * This control allows the user to choose a font family for all elements in the body tag
		 * --------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[button_typo]', array(
				'type' => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 'Poppins',
			)
		);

		$wp_customize->add_control(
			new Victim_Font_Selector(
				$wp_customize, 'victim_options[button_typo]', array(
					'label'    => esc_html__( 'Button', 'victim' ),
					'section'  => 'victim_typography',
					'priority' => 10,
					'type'     => 'select',
				)
			)
		);

		/**
		 * ---------------------------------
		 * 1.b. Body font family control
		 * This control allows the user to choose a font family for all elements in the body tag
		 * --------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[site_title_font]', array(
				'type' => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 'Poppins',
			)
		);

		$wp_customize->add_control(
			new Victim_Font_Selector(
				$wp_customize, 'victim_options[site_title_font]', array(
					'label'    => esc_html__( 'Site Title/Logo Font Family', 'victim' ),
					'section'  => 'victim_typography',
					'priority' => 10,
					'type'     => 'select',
				)
			)
		);
	} // End if().

	if ( class_exists( 'Victim_Select_Multiple' ) ) {
		/**
		 * --------------------
		 * 1.c. Font Subsets control
		 * This control allows the user to choose a subset for the font family ( for e.g. lating, cyrillic etc )
		 * --------------------
		 */
		$wp_customize->add_setting(
			'victim_options[font_subsets]', array(
				'sanitize_callback' => 'victim_sanitize_multiselect',
				'default'           => array( 'latin' ),
			)
		);

		$wp_customize->add_control(
			new Victim_Select_Multiple(
				$wp_customize, 'victim_options[font_subsets]', array(
					'section'  => 'victim_typography',
					'label'    => esc_html__( 'Font Subsets', 'victim' ),
					'choices'  => array(
						'latin'        => 'latin',
						'latin-ext'    => 'latin-ext',
						'cyrillic'     => 'cyrillic',
						'cyrillic-ext' => 'cyrillic-ext',
						'greek'        => 'greek',
						'greek-ext'    => 'greek-ext',
						'vietnamese'   => 'vietnamese',
					),
					'priority' => 45,
				)
			)
		);
	} // End if().

	/**
	 * ------------------
	 * 2. Font Size tab
	 * ------------------
	 */
	if ( class_exists( 'Victim_Customizer_Range_Value_Control' ) ) {
		/**
		 * --------------------------------------------------------------------------
		 * 2.b. Font size controls for Posts & Pages
		 * --------------------------------------------------------------------------
		 *
		 * Title control [Posts & Pages]
		 * This control allows the user to choose a font size for the main titles
		 * that appear in the header for pages and posts.
		 *
		 * The values area between 0 and 60 rem.
		 * --------------------------------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[body_font_size]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 16,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[body_font_size]', array(
					'label'       => esc_html__( 'Body Font Size (px):', 'victim' ),
					'description' => esc_html__('All font size is REM based. So please use slider to increase font size', 'victim'),
					'section'     => 'victim_typography_size',
					'type'        => 'range-value',
					'input_attr'  => array(
						'min'  => 0,
						'max'  => 60,
						'step' => 1,
					),
					'priority'    => 110,
					'sum_type'    => false,
				)
			)
		);

		/**
		 * --------------------------------------------------------------------------
		 * Headings control [Posts & Pages]
		 *
		 * This control allows the user to choose a font size for all headings
		 * ( h1 - h6 ) from pages and posts.
		 *
		 * The values area between 0 and 60 px.
		 * --------------------------------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[site_title_font_size]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 1.25,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[site_title_font_size]', array(
					'label'      => esc_html__( 'Site Logo/Title:', 'victim' ),
					'description' => esc_html__('All font size is em based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 60,
						'step' => 0.1,
					),
					'priority'   => 112,
					'sum_type'    => false,
				)
			)
		);		

		/**
		 * --------------------------------------------------------------------------
		 * Headings control [Posts & Pages]
		 *
		 * This control allows the user to choose a font size for all headings
		 * ( h1 - h6 ) from pages and posts.
		 *
		 * The values area between 0 and 60 px.
		 * --------------------------------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[menu_font_size]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 18,
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[menu_font_size]', array(
					'label'      => esc_html__( 'Menu Font Size(px):', 'victim' ),
					'section'    => 'victim_typography_size',
					'description' => esc_html__('This font size is px based. So please use slider to increase font size', 'victim'),
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 60,
						'step' => 1,
					),
					'priority'   => 115,
					'sum_type'    => false,
				)
			)
		);

		/**
		 * --------------------------------------------------------------------------
		 * Content control [Posts & Pages]
		 *
		 * This control allows the user to choose a font size for the main content
		 * area in pages and posts.
		 *
		 * The values area between -25 and +25 px.
		 * --------------------------------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[post_title_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 30,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[post_title_content]', array(
					'label'      => esc_html__( 'Post Title Font Size(px):', 'victim' ),
					'description' => esc_html__('All font size is PX based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 90,
						'step' => 1,
					),
					'priority'   => 120,
					'sum_type'    => false,
				)
			)
		);

		$wp_customize->add_setting(
			'victim_options[post_single_title_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 50,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[post_single_title_content]', array(
					'label'      => esc_html__( 'Post Single Title Font Size(px):', 'victim' ),
					'description' => esc_html__('This font size is PX based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 90,
						'step' => 1,
					),
					'priority'   => 120,
					'sum_type'    => false,
				)
			)
		);

		$wp_customize->add_setting(
			'victim_options[widget_title_font_size]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 14,
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[widget_title_font_size]', array(
					'label'      => esc_html__( 'Sidebar Widget Title Font Size(px):', 'victim' ),
					'description' => esc_html__('This font size is PX based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 90,
						'step' => 1,
					),
					'priority'   => 120,
					'sum_type'    => false,
				)
			)
		);

		/**
		 * --------------------------------------------------------------------------
		 * 2.c. Font size controls for Frontpage
		 * --------------------------------------------------------------------------
		 * Big Title Section / Header Slider font size control. [Frontpage Sections]
		 *
		 * This is changing the big title/slider titles, the
		 * subtitle and the button in the big title section.
		 *
		 * The values are between 0 and 120 px.
		 * --------------------------------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[heading_one_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 2.441,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[heading_one_content]', array(
					'label'      =>  esc_html__( 'H1:', 'victim' ),
					'description' => esc_html__('All Heading font size is EM based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 120,
						'step' => 0.1,
					),
					'priority'   => 210,
					'sum_type'    => false,
				)
			)
		);

		/**
		 * --------------------------------------------------------------------------
		 * Section Title [Frontpage Sections]
		 *
		 * This control is changing sections titles and card titles
		 * The values are between 0 and 120 px.
		 * --------------------------------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[heading_two_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 1.953,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[heading_two_content]', array(
					'label'      => esc_html__( 'H2:', 'victim' ),
					'description' => esc_html__('All Heading font size is EM based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 120,
						'step' => 0.1,
					),
					'priority'   => 215,
					'sum_type'    => false,
				)
			)
		);

		/**
		 * -----------------------------------------------------
		 * Subtitles control [Frontpage Sections]
		 * This control allows the user to choose a font size
		 * for all Subtitles on Frontpage sections.
		 * The values area between 0 and 105 px.
		 * -----------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[heading_three_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 1.563,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[heading_three_content]', array(
					'label'      => esc_html__( 'H3:', 'victim' ),
					'description' => esc_html__('All Heading font size is EM based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 105,
						'step' => 0.1,
					),
					'priority'   => 220,
					'sum_type'    => false,
				)
			)
		);

		/**
		 * -----------------------------------------------------
		 * Content control [Frontpage Sections]
		 * This control allows the user to choose a font size
		 * for the Main content for Frontpage Sections
		 * The values area between 0 and 90 px.
		 * -----------------------------------------------------
		 */
		$wp_customize->add_setting(
			'victim_options[heading_four_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 1.25,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[heading_four_content]', array(
					'label'      => esc_html__( 'H4:', 'victim' ),
					'description' => esc_html__('All Heading font size is EM based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 90,
						'step' => 0.1,
					),
					'priority'   => 225,
					'sum_type'    => false,
				)
			)
		);

		$wp_customize->add_setting(
			'victim_options[heading_five_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 1,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[heading_five_content]', array(
					'label'      => esc_html__( 'H5:', 'victim' ),
					'description' => esc_html__('All Heading font size is EM based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 75,
						'step' => 0.1,
					),
					'priority'   => 226,
					'sum_type'    => false,
				)
			)
		);

		$wp_customize->add_setting(
			'victim_options[heading_six_content]', array(
				'sanitize_callback' => 'victim_sanitize_number_range',
				'default'           => 0.8,
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			new Victim_Customizer_Range_Value_Control(
				$wp_customize, 'victim_options[heading_six_content]', array(
					'label'      => esc_html__( 'H6:', 'victim' ),
					'description' => esc_html__('All Heading font size is EM based. So please use slider to increase font size', 'victim'),
					'section'    => 'victim_typography_size',
					'type'       => 'range-value',
					'input_attr' => array(
						'min'  => 0,
						'max'  => 60,
						'step' => 0.1,
					),
					'priority'   => 227,
					'sum_type'    => false,
				)
			)
		);
	} // End if().
}

add_action( 'customize_register', 'victim_typography_settings', 20 );