<?php
/**
 * Customizer functionality for the theme.
 *
 * @package Victim
 * @since 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if(! class_exists( 'Victim_Customizer' ) ) {
	/**
	 * The Victim Customizer Settings
	 */
	class Victim_Customizer  {

		private static $_instance = null;

		public static function instance() {
		    if ( is_null( self::$_instance ) ) {
		        self::$_instance = new self();
		    }
		    return self::$_instance;
		}

		/**
		 * Setup class.
		 *
		 * @since 1.0
		 */
		public function __construct() {
			//add customizer settings control
			add_filter( 'victim_filter_features', array( $this, 'victim_filter_features') );

			//includes all files of controls
			add_action( 'after_setup_theme', array($this, 'victim_include_features'), 0 );

			//Include JS Controls Types
			add_action( 'customize_register', array($this, 'victim_register_control_types'), 0 );

			//Include Preview Unit JS
			add_action( 'customize_preview_init', array($this, 'victim_customize_preview_js') );

			//Include Controls Scripts
			add_action( 'customize_controls_enqueue_scripts', array($this, 'victim_panels_js') );
		}

		/**
		 * Filter The customizer Panel.
		 * @since 1.0
		 */
		public function victim_filter_features( $array ) {
			$files_to_load = array(
				'typography/typography-settings',
				'customizer-toggle-control/class-customizer-toggle-control',
				'customizer-radio-image/class/class-customize-control-radio-image',
				'customizer-alpha-color-picker/class-customize-alpha-color-control',
				'customizer-repeater/class/class-customizer-repeater-control',
				'customizer-column-range/class-columns-customize-control-range',
			);
			
			return array_merge(
				$array, $files_to_load
			);
		}

		/**
		 * Include All files.
		 *
		 * @since Victim 1.0
		 */
		public function victim_include_features() {
			$victim_allowed_phps = array();
			$victim_allowed_phps = apply_filters( 'victim_filter_features', $victim_allowed_phps );
			foreach ( $victim_allowed_phps as $file ) {
				$victim_file_to_include = get_template_part('/inc/customizer/'. $file );
			}
		}

		/**
		 * Register JS control types.
		 *
		 * @since  1.0
		 * @access public
		 * @return void
		 */
		public function victim_register_control_types( $wp_customize ) {
			get_template_part('inc/customizer/customizer-range-value/class/class-customizer-range-value-control');
			get_template_part('inc/customizer/customizer-select-multiple/class/class-select-multiple');
			get_template_part('inc/customizer/customizer-dimensions/class-control-dimensions');
			get_template_part('inc/customizer/heading/class-control-heading');
			get_template_part('inc/customizer/customizer-sortable/class-control-sortable');

			// Register JS control types.
			$wp_customize->register_control_type( 'Victim_Select_Multiple' );
			$wp_customize->register_control_type( 'Victim_Customizer_Dimensions_Control' );
			$wp_customize->register_control_type( 'Victim_Customizer_Range_Value_Control' );
			$wp_customize->register_control_type( 'Victim_Customizer_Sortable_Control' );
			$wp_customize->register_control_type( 'Victim_Customizer_Heading_Control' );
		}

		/**
		 * Customizer Preview Unit JS.
		 *
		 * @since  1.0
		 * @access public
		 * @return void
		 */
		public function victim_customize_preview_js() {
		    wp_enqueue_script('victim-customize-preview', get_theme_file_uri( '/assets/custom/customize-preview.js' ), array("jquery"), '1.0', true);
		}

		/**
		 * Customizer Controls JS.
		 *
		 * @since  1.0
		 * @access public
		 * @return void
		 */
		public function victim_panels_js() {
		    wp_enqueue_script('victim-customize-controls', get_theme_file_uri( '/assets/custom/customize-controls.js' ), array("jquery"), '1.0', true);
		    wp_enqueue_style('victim-customize-controls', get_theme_file_uri( '/assets/custom/customize-control.css' ), null );
		}
	}
}

Victim_Customizer::instance();