<?php
/**
 *  Victim Besic Theme Settings
 *
 * @since Victim 1.0
 *
 * @return array victim_customize_register
 *
*/
function victim_customize_register( $wp_customize ) {
    //Basic Post Message Settings
    $wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
    $wp_customize->get_section( 'title_tagline' )->title         = esc_html__( 'Logo & Site Identity', 'victim' );

    // Changing for site Identity
    $wp_customize->selective_refresh->add_partial( 'blogname', array(
        'selector' => '.site-title a',
        'render_callback' => 'victim_customize_partial_blogname',
    ));
    $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
        'selector' => '.site-description',
        'render_callback' => 'victim_customize_partial_blogdescription',
    ));

    /* 2X Header Logo ---------------- */
    $wp_customize->add_setting(
        'retina_logo',
        array(
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'transport'         => 'postMessage',
        )
    );

    $wp_customize->add_control(
        'retina_logo',
        array(
            'type'        => 'checkbox',
            'section'     => 'title_tagline',
            'priority'    => 8,
            'label'       => esc_html__( 'Retina logo', 'victim' ),
        )
    );

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {

        $wp_customize->add_setting( 'victim_options[theme_header_background_colors]' , array(
            'default'     => '#ffffff',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_header_background_colors]',
                array(
                    'label'     => esc_html__( 'Header Background Color', 'victim' ),
                    'description' => esc_html__( 'Change the header background Color.', 'victim' ),
                    'section'   => 'colors',
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[theme_header_border_colors]' , array(
            'default'     => '#e4e0d8',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_header_border_colors]',
                array(
                    'label'     => esc_html__( 'Header Border Color', 'victim' ),
                    'description' => esc_html__( 'Change the border colors of header bottom.', 'victim' ),
                    'section'   => 'colors',
                )
            )
        );         

        $wp_customize->add_setting( 'victim_options[theme_color]' , array(
            'default'     => '#f7f7f7',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_color]',
                array(
                    'label'     => esc_html__( 'Theme Color', 'victim' ),
                    'description' => esc_html__( 'Theme color option used mainly in button, widget title background, post category background etc.', 'victim' ),
                    'section'   => 'colors',
                )
            )
        );         

        $wp_customize->add_setting( 'victim_options[theme_text_color]' , array(
            'default'     => '#202020',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_text_color]',
                array(
                    'label'     => esc_html__( 'Theme Text Color', 'victim' ),
                    'description' => esc_html__( 'Theme text color option used mainly in button, widget title background, post category text colors etc.', 'victim' ),
                    'section'   => 'colors',
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[theme_secondary_color]' , array(
            'default'     => '#000000',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_secondary_color]',
                array(
                    'label'     => esc_html__( 'Theme Secondary Color', 'victim' ),
                    'description' => esc_html__( 'Theme secondary color mainly option used in button, tag, links hover effects.', 'victim' ),
                    'section'   => 'colors',
                )
            )
        );         

        $wp_customize->add_setting( 'victim_options[theme_link_hover]' , array(
            'default'     => '#FF0066',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_link_hover]',
                array(
                    'label'     => esc_html__( 'Theme Links Hover Color', 'victim' ),
                    'description' => esc_html__( 'Theme secondary color mainly option used in button, tag, links hover effects.', 'victim' ),
                    'section'   => 'colors',
                )
            )
        );         

        $wp_customize->add_setting( 'victim_options[theme_input_border]' , array(
            'default'     => '#e4e0d8',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_input_border]',
                array(
                    'label'     => esc_html__( 'Input Border Color', 'victim' ),
                    'description' => esc_html__( 'Input Border color is for all form input field, textarea, widget list item border colors.', 'victim' ),
                    'section'   => 'colors',
                )
            )
        ); 
    }
 
    /**
     * Victim WordPress Theme General Settings
     */  
    $wp_customize->add_panel(
        'victim_general_options', array(
            'priority' => 25,
            'title'    => esc_html__( 'General Settings', 'victim' ),
        )
    );

    $wp_customize->add_section( 'victim_general_settings' , array(
        'title'      => esc_html__( 'General', 'victim' ),
        'priority'   => 10,
        'panel'    => 'victim_general_options',
    ) );

    if ( class_exists( 'Victim_Toggle_Control' ) ) {

        $wp_customize->add_setting( 'victim_options[combine_resource]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[combine_resource]', 
            array(
                'label'  => esc_html__( 'Combine Resource:', 'victim' ),
                'type'   => 'ios',
                'description' => esc_html__('Combine All Theme CSS/JS into one', 'victim'),
                'section'  => 'victim_general_settings',
                'priority' => 10, 
                
            ) 
        ));           

        $wp_customize->add_setting( 'victim_options[schema_markup]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[schema_markup]', 
            array(
                'label'  => esc_html__( 'Schema Markup:', 'victim' ),
                'type'   => 'ios',
                'description' => esc_html__('Enable Schema Markup', 'victim'),
                'section'  => 'victim_general_settings',
                'priority' => 10, 
                
            ) 
        ));         

        $wp_customize->add_setting( 'victim_options[custom_scrollbar]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[custom_scrollbar]', 
            array(
                'label'  => esc_html__( 'Custom Scrollbar:', 'victim' ),
                'type'   => 'ios',
                'description' => esc_html__('Enable Custom Scrollbar at full sites', 'victim'),
                'section'  => 'victim_general_settings',
                'priority' => 10, 
                
            ) 
        ));    
    }


    if ( class_exists( 'Victim_Toggle_Control' ) ) {
        $wp_customize->add_setting( 'victim_options[preloader]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[preloader]', 
            array(
                'label'  => esc_html__( 'Preloader:', 'victim' ),
                'type'   => 'ios',
                'section'  => 'victim_general_settings',
                'priority' => 10, 
                
            ) 
        ));                     
    }

    $wp_customize->add_setting( 'victim_options[preloader_type]' , array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'victim_sanitize_select',
        'default' => 'predefine_preloader',
    ));

    $wp_customize->add_control( 'victim_options[preloader_type]', array(
        'label' => esc_html__( 'Preloader Type ', 'victim' ),
        'section' => 'victim_general_settings',
        'type' => 'select',
        'active_callback' => 'victim_preloader_type_callback',
        'priority' => 10,
        'choices' => array(
            'predefine_preloader'  => esc_html__( 'Predefine Preloader', 'victim' ),
            'custom_preloader'   => esc_html__( 'Custom Preloader', 'victim' ),
        ),
    ));

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {
        $wp_customize->add_setting( 'victim_options[theme_preloader_bg]' , array(
            'default'     => '#12141c',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_preloader_bg]',
                array(
                    'label'     => esc_html__( 'Preloader background', 'victim' ),
                    'section'   => 'victim_general_settings',
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[theme_preloader_buble_color]' , array(
            'default'     => '#e51681',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',            
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_preloader_buble_color]',
                array(
                    'label'     => esc_html__( 'Preloader Color', 'victim' ),
                    'section'   => 'victim_general_settings',
                    'active_callback' => 'victim_preloader_predefine_type_callback',
                )
            )
        );        
    }  

    if( class_exists('Victim_Elementor_Widget') ) {
        // Header Template
        $preloader_args = array( 
            'post_type' => 'victim_templates', 
            'posts_per_page' => -1,
            'meta_key' => 'victim_template_types',
            'meta_value'  => 'preloader',
            'meta_compare' => '>=',
            'orderby'      => 'meta_value',
            'order'        => 'ASC',
            'meta_query'   => array(
                'relation' => 'OR',
                array(
                    'key'     => 'victim_template_types',
                    'value'   => 'preloader',
                    'compare' => '==',
                    'type'    => 'page',
                ),
            ),
        );
        
        $get_preloader = get_posts($preloader_args);
        $preloader_template = array();
        if( $get_preloader ) {
            foreach ($get_preloader as $value) {
                $preloader_template['default'] = esc_html__('Default', 'victim');
                $preloader_template[$value->ID] = $value->post_title;
            }
        } else {
            $preloader_template['default'] = esc_html__('Default', 'victim');
        }

        $wp_customize->add_setting( 'victim_options[preloader_templates]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'victim_sanitize_select',
            'default' => 'default',
        ));

        $wp_customize->add_control( 'victim_options[preloader_templates]', array(
            'label' => esc_html__( 'Custom Preloader Content', 'victim' ),
            'section' => 'victim_general_settings',
            'type' => 'select',
            'priority' => 10,
            'choices' => $preloader_template,
            'active_callback' => 'victim_preloader_customs_type_callback',
        ));
    }


    //Container Settings
    $wp_customize->add_section( 'victim_container_settings' , array(
        'title'      => esc_html__( 'Page Layout', 'victim' ),
        'priority'   => 10,
        'panel'    => 'victim_general_options',
    ) );

    // Page Layout

    if ( class_exists( 'Victim_Customize_Control_Radio_Image' ) ) { 
        $page_sidebar_choices = array(
            'full'    => array(
                'url'   =>  get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/full-width.png' ),
                'label' => esc_html__( 'Full Width', 'victim' ),
            ),
            'left'  => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-left.png' ),
                'label' => esc_html__( 'Left Sidebar', 'victim' ),
            ),
            'right' => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-right.png' ),
                'label' => esc_html__( 'Right Sidebar', 'victim' ),
            ),
        );

        $wp_customize->add_setting( 'victim_options[page_sidebar_dispay]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_key',
            'type'      =>  'theme_mod',
            'default' => 'full',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Control_Radio_Image(
                $wp_customize, 'victim_options[page_sidebar_dispay]', array(
                    'label'    => esc_html__( 'Sidebar Layout', 'victim' ),
                    'section'  => 'victim_container_settings',
                    'priority' => 20,
                    'choices'  => $page_sidebar_choices,
                )
            )
        );
    }

    if( class_exists('Victim_Customizer_Dimensions_Control') ) {
        /**
         * Page Padding
         */
        $wp_customize->add_setting( 'victim_options[page_content_top_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 110,
        ) );
        $wp_customize->add_setting( 'victim_options[page_content_bottom_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 75,
        ) );

        $wp_customize->add_setting( 'victim_options[page_content_tablet_top_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 110,
        ) );
        $wp_customize->add_setting( 'victim_options[page_content_tablet_bottom_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 75,
        ) );

        $wp_customize->add_setting( 'victim_options[page_content_mobile_top_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 90,
        ) );
        $wp_customize->add_setting( 'victim_options[page_content_mobile_bottom_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 60,
        ) );

        $wp_customize->add_control( new Victim_Customizer_Dimensions_Control( $wp_customize, 'victim_options[page_content_padding]', array(
            'label'                 => esc_html__( 'Content Padding (px)', 'victim' ),
            'section'               => 'victim_container_settings',             
            'settings'   => array(
                'desktop_top'       => 'victim_options[page_content_top_padding]',
                'desktop_bottom'    => 'victim_options[page_content_bottom_padding]',
                'tablet_top'        => 'victim_options[page_content_tablet_top_padding]',
                'tablet_bottom'     => 'victim_options[page_content_tablet_bottom_padding]',
                'mobile_top'        => 'victim_options[page_content_mobile_top_padding]',
                'mobile_bottom'     => 'victim_options[page_content_mobile_bottom_padding]',
            ),
            'priority'              => 20,
            'input_attrs'           => array(
                'min'   => 0,
                'max'   => 100,
                'step'  => 1,
            ),
        ) ) );
    }


    //Theme Color
    $wp_customize->add_section( 'victim_themecolor_settings' , array(
        'title'      => esc_html__( 'Theme Color Mode', 'victim' ),
        'priority'   => 10,
        'panel'    => 'victim_general_options',
    ) );

    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_theme_chooser_heading', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_theme_chooser_heading', array(
            'label'     => esc_html__( 'Theme Mode', 'victim' ),
            'section'   => 'victim_themecolor_settings',
            'priority'  => 10,
        ) ) );
    } 

    if ( class_exists( 'Victim_Customize_Control_Radio_Image' ) ) { 
        $theme_version = array(
            'light'    => array(
                'url'   =>  get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/theme-light.png' ),
                'label' => esc_html__( 'Light', 'victim' ),
            ),
            'dark'  => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/theme-dark.png' ),
                'label' => esc_html__( 'Dark', 'victim' ),
            ),
        );

        $wp_customize->add_setting( 'victim_options[theme_background_status]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_key',
            'type'      =>  'theme_mod',
            'default' => 'light',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Control_Radio_Image(
                $wp_customize, 'victim_options[theme_background_status]', array(
                    'label'    => esc_html__( 'Theme Status', 'victim' ),
                    'section'  => 'victim_themecolor_settings',
                    'priority' => 10,
                    'choices'  => $theme_version,
                )
            )
        );
    }  

    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_theme_chooser_light_heading', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_theme_chooser_light_heading', array(
            'label'     => esc_html__( 'Light Version', 'victim' ),
            'section'   => 'victim_themecolor_settings',
            'priority'  => 10,
        ) ) );
    } 

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {

        $wp_customize->add_setting( 'victim_options[theme_background_light_color]' , array(
            'default'     => '#ffffff',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_background_light_color]',
                array(
                    'label'     => esc_html__( 'Theme Background Color', 'victim' ),
                    'section'   => 'victim_themecolor_settings',
                )
            )
        );        
    } 

    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_theme_chooser_dark_heading', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_theme_chooser_dark_heading', array(
            'label'     => esc_html__( 'Dark Version', 'victim' ),
            'section'   => 'victim_themecolor_settings',
            'priority'  => 10,
        ) ) );
    } 

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {

        $wp_customize->add_setting( 'victim_options[theme_background_dark_color]' , array(
            'default'     => '#333333',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[theme_background_dark_color]',
                array(
                    'label'     => esc_html__( 'Theme Background Color', 'victim' ),
                    'section'   => 'victim_themecolor_settings',
                )
            )
        );        
    } 

    /**
     * Header panel
     */
    $wp_customize->add_panel(
        'victim_header_settings', array(
            'priority' => 25,
            'title'    => esc_html__( 'Header Settings', 'victim' ),
        )
    );

    // Logo Section
    $wp_customize->add_section(
        'victim_logo_section', array(
            'title'    => esc_html__( 'Logo Settings', 'victim' ),
            'panel'    => 'victim_header_settings',
            'priority' => 10,
        )
    );

    if( class_exists('Victim_Customizer_Dimensions_Control') ) {
        /**
         * Blog Padding
         */
        $wp_customize->add_setting( 'victim_options[logo_top_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[logo_bottom_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 0,
        ) );

        $wp_customize->add_setting( 'victim_options[logo_tablet_top_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[logo_tablet_bottom_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );

        $wp_customize->add_setting( 'victim_options[logo_mobile_top_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[logo_mobile_bottom_padding]', array(
            'transport'             => 'postMessage',
            'capability'            => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );

        $wp_customize->add_control( new Victim_Customizer_Dimensions_Control( $wp_customize, 'victim_options[logo_padding]', array(
            'label'                 => esc_html__( 'Logo Padding (px)', 'victim' ),
            'section'               => 'victim_logo_section',             
            'settings'   => array(
                'desktop_top'       => 'victim_options[logo_top_padding]',
                'desktop_bottom'    => 'victim_options[logo_bottom_padding]',
                'tablet_top'        => 'victim_options[logo_tablet_top_padding]',
                'tablet_bottom'     => 'victim_options[logo_tablet_bottom_padding]',
                'mobile_top'        => 'victim_options[logo_mobile_top_padding]',
                'mobile_bottom'     => 'victim_options[logo_mobile_bottom_padding]',
            ),
            'priority'              => 10,
            'input_attrs'           => array(
                'min'   => 0,
                'max'   => 100,
                'step'  => 1,
            ),
        ) ) );
    }

    if ( class_exists( 'Victim_Customizer_Range_Value_Control' ) ) {
        $wp_customize->add_setting(
            'victim_options[logo_max_width]', array(
                'sanitize_callback' => 'victim_sanitize_number_range',
                'default'           => 156,
            )
        );

        $wp_customize->add_control(
            new Victim_Customizer_Range_Value_Control(
                $wp_customize, 'victim_options[logo_max_width]', array(
                    'label'       => esc_html__( 'Set Logo Max Width:', 'victim' ),
                    'description' => esc_html__('Select your logo max width from here.', 'victim'),
                    'section'     => 'victim_logo_section',
                    'type'        => 'range-value',
                    'input_attr'  => array(
                        'min'  => 0,
                        'max'  => 550,
                        'step' => 1,
                    ),
                    'priority'    => 10,
                    'sum_type'    => false,
                )
            )
        );        

        $wp_customize->add_setting(
            'victim_options[header_heights]', array(
                'sanitize_callback' => 'victim_sanitize_number_range',
                'default'           => 130,
            )
        );

        $wp_customize->add_control(
            new Victim_Customizer_Range_Value_Control(
                $wp_customize, 'victim_options[header_heights]', array(
                    'label'       => esc_html__( 'Set Header Hight:', 'victim' ),
                    'description' => esc_html__('Select your header hight from here from here.', 'victim'),
                    'section'     => 'victim_logo_section',
                    'type'        => 'range-value',
                    'input_attr'  => array(
                        'min'  => 0,
                        'max'  => 550,
                        'step' => 1,
                    ),
                    'priority'    => 10,
                    'sum_type'    => false,
                )
            )
        );
    } 

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {
        $wp_customize->add_setting( 'victim_options[site_branding_color]' , array(
            'default'     => '#000000',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[site_branding_color]',
                array(
                    'label'     => esc_html__( 'Site Title Color', 'victim' ),
                    'section'   => 'victim_logo_section',
                    'priority'  => 20,
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[site_description_color]' , array(
            'default'     => '#858585',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[site_description_color]',
                array(
                    'label'     => esc_html__( 'Site Description Color', 'victim' ),
                    'section'   => 'victim_logo_section',
                    'priority'  => 20,
                )
            )
        );
    } 

    $wp_customize->add_section(
        'victim_menu_section', array(
            'title'    => esc_html__( 'Menu Settings', 'victim' ),
            'panel'    => 'victim_header_settings',
            'priority' => 15,
        )
    );

    // Main Menu 
    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {
        $wp_customize->add_setting( 'victim_options[menu_color]' , array(
            'default'     => '#252424',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[menu_color]',
                array(
                    'label'     => esc_html__( 'Main Menu Color', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[main_menu_hover_color]' , array(
            'default'     => '#313131',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[main_menu_hover_color]',
                array(
                    'label'     => esc_html__( 'Main Menu Hover Color', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[main_menu_separator_color]' , array(
            'default'     => '#ff0066',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[main_menu_separator_color]',
                array(
                    'label'     => esc_html__( 'Menu Active Dot Color', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        );
    } 

    // Sub dropdown Heading 
    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_menu_main_styling_heading', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_menu_main_styling_heading', array(
            'label'                 => esc_html__( 'Dropdown Styling', 'victim' ),
            'section'               => 'victim_menu_section',
            'priority'              => 20,
        ) ) );
    }

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {
        $wp_customize->add_setting( 'victim_options[dropdown_menu_bg]' , array(
            'default'     => '#080d18',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[dropdown_menu_bg]',
                array(
                    'label'     => esc_html__( 'Sub Menu Background', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[dropdown_menu_color]' , array(
            'default'     => '#f7f7f7',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[dropdown_menu_color]',
                array(
                    'label'     => esc_html__( 'Sub Menu Text Color', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        ); 
    }

    if ( class_exists( 'Victim_Customizer_Range_Value_Control' ) ) {
        $wp_customize->add_setting(
            'victim_options[dropdown_menu_width]', array(
                'sanitize_callback' => 'victim_sanitize_number_range',
                'default'           => 240,
            )
        );

        $wp_customize->add_control(
            new Victim_Customizer_Range_Value_Control(
                $wp_customize, 'victim_options[dropdown_menu_width]', array(
                    'label'       => esc_html__( 'Dropdown Menu Width:', 'victim' ),
                    'description' => esc_html__('Select your dropdown menu width', 'victim'),
                    'section'     => 'victim_menu_section',
                    'type'        => 'range-value',
                    'input_attr'  => array(
                        'min'  => 0,
                        'max'  => 550,
                        'step' => 0.1,
                    ),
                    'priority'    => 20,
                    'sum_type'    => false,
                )
            )
        );
    } 

    // Sub dropdown Heading 
    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_mobile_main_styling_heading', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_mobile_main_styling_heading', array(
            'label'                 => esc_html__( 'Mobile Menu Styling', 'victim' ),
            'section'               => 'victim_menu_section',
            'priority'              => 20,
        ) ) );
    }

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {
        $wp_customize->add_setting( 'victim_options[mobile_menu_color]' , array(
            'default'     => '#ffffff',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[mobile_menu_color]',
                array(
                    'label'     => esc_html__( 'Menu Color', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        );        

        $wp_customize->add_setting( 'victim_options[mobile_menu_bg]' , array(
            'default'     => '#12141c',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[mobile_menu_bg]',
                array(
                    'label'     => esc_html__( 'Menu Background', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        );         

        $wp_customize->add_setting( 'victim_options[mobile_menu_hamburger_color]' , array(
            'default'     => '#12141c',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Alpha_Color_Control(
                $wp_customize,
                'victim_options[mobile_menu_hamburger_color]',
                array(
                    'label'     => esc_html__( 'Hamburger Indicator Color', 'victim' ),
                    'section'   => 'victim_menu_section',
                    'priority'  => 20,
                )
            )
        ); 
    }

    $wp_customize->add_section(
        'victim_header_content_section', array(
            'title'    => esc_html__( 'Content Settings', 'victim' ),
            'panel'    => 'victim_header_settings',
            'priority' => 15,
        )
    );

    if ( class_exists( 'Victim_Toggle_Control' ) ) {      
        $wp_customize->add_setting( 'victim_options[header_full_width]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[header_full_width]', 
            array(
                'label'  => esc_html__( 'Header Full Width:', 'victim' ),
                'description' => esc_html__( 'If you want to make your header full width then enable this options.', 'victim' ),
                'type'   => 'ios',
                'section'  => 'victim_header_content_section',
                'priority' => 10, 
                
            ) 
        ));   
    }

    if ( class_exists( 'Victim_Toggle_Control' ) ) {    

        $wp_customize->add_setting( 'victim_options[enable_sticky_headers]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[enable_sticky_headers]', 
            array(
                'label'  => esc_html__( 'Sticky Header:', 'victim' ),
                'type'   => 'ios',
                'section'  => 'victim_header_content_section',
                'priority' => 10, 
                
            ) 
        )); 

        $wp_customize->add_setting( 'victim_options[transparent_header]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[transparent_header]', 
            array(
                'label'  => esc_html__( 'Transparent Header:', 'victim' ),
                'description' => esc_html__( 'If you want to make your header transparent then enable this options.', 'victim' ),
                'type'   => 'ios',
                'section'  => 'victim_header_content_section',
                'priority' => 10, 
                
            ) 
        ));  
    }

    $wp_customize->add_setting( 'victim_options[header_type]' , array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'victim_sanitize_select',
        'default' => 'predefine_header',
    ));

    $wp_customize->add_control( 'victim_options[header_type]', array(
        'label' => esc_html__( 'Header Type ', 'victim' ),
        'description' => esc_html__( 'We had predefine header and header builder as well. if you don\'t like our header then you can build your header from switching Custom Header.', 'victim' ),
        'section' => 'victim_header_content_section',
        'type' => 'select',
        'priority' => 10,
        'choices' => array(
            'predefine_header'  => esc_html__( 'Predefine Header', 'victim' ),
            'custom_header'   => esc_html__( 'Custom Header', 'victim' ),
        ),
    ));


    if( class_exists('Victim_Elementor_Widget') ) {
        // Header Template
        $header_args = array( 
            'post_type' => 'victim_templates', 
            'posts_per_page' => -1,
            'meta_key' => 'victim_template_types',
            'meta_value'  => 'header',
            'meta_compare' => '>=',
            'orderby'      => 'meta_value',
            'order'        => 'ASC',
            'meta_query'   => array(
                'relation' => 'OR',
                array(
                    'key'     => 'victim_template_types',
                    'value'   => 'header',
                    'compare' => '==',
                    'type'    => 'page',
                ),
            ),
        );
        
        $get_header = get_posts($header_args);
        $header_template = array();
        if( $get_header ) {
            foreach ($get_header as $value) {
                $header_template['default'] = esc_html__('Default', 'victim');
                $header_template[$value->ID] = $value->post_title;
            }
        } else {
            $header_template['default'] = esc_html__('Default', 'victim');
        }

        $wp_customize->add_setting( 'victim_options[header_templates]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'victim_sanitize_select',
            'default' => 'default',
        ));

        $wp_customize->add_control( 'victim_options[header_templates]', array(
            'label' => esc_html__( 'Custom Template', 'victim' ),
            'section' => 'victim_header_content_section',
            'type' => 'select',
            'priority' => 10,
            'choices' => $header_template,
            'active_callback' => 'victim_header_type_callback',
        ));
    }
    //End Header 

    /**
     * Victim WordPress Theme Blog Settings
     */ 
    $wp_customize->add_panel(
        'victim_blog_options', array(
            'priority' => 50,
            'title'    => esc_html__( 'Blog Settings', 'victim' ),
        )
    );

    $wp_customize->add_section( 'victim_blog_entries_settings' , array(
        'title'      => esc_html__( 'Blog Entries', 'victim' ),
        'priority'   => 10,
        'panel'    => 'victim_blog_options',
    ) );

    $wp_customize->add_section( 'victim_blog_single_settings' , array(
        'title'      => esc_html__( 'Blog Single', 'victim' ),
        'priority'   => 10,  
        'panel'    => 'victim_blog_options', 
    ));    

    $wp_customize->add_setting(
        'victim_options[blog_title_info]', array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'victim_sanitize_advictim_html',
            'type'      =>  'theme_mod',
            'default'   => esc_html__( 'Latest Articles.', 'victim' ),
        )
    );

    $wp_customize->add_control(
        'victim_options[blog_title_info]', array(
            'label' => esc_html__( 'Blog Title:', 'victim' ),
            'type' => 'text',
            'priority' => 10,
            'section' => 'victim_blog_entries_settings',
        )
    );    

    if ( class_exists( 'Victim_Customize_Control_Radio_Image' ) ) { 
        $sidebar_choices = array(
            'full'    => array(
                'url'   =>  get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/full-width.png' ),
                'label' => esc_html__( 'Full Width', 'victim' ),
            ),
            'left'  => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-left.png' ),
                'label' => esc_html__( 'Left Sidebar', 'victim' ),
            ),
            'right' => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-right.png' ),
                'label' => esc_html__( 'Right Sidebar', 'victim' ),
            ),
        );

        $wp_customize->add_setting( 'victim_options[blog_sidebar_dispay]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_key',
            'type'      =>  'theme_mod',
            'default' => 'right',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Control_Radio_Image(
                $wp_customize, 'victim_options[blog_sidebar_dispay]', array(
                    'label'    => esc_html__( 'Sidebar Layout', 'victim' ),
                    'section'  => 'victim_blog_entries_settings',
                    'priority' => 10,
                    'choices'  => $sidebar_choices,
                )
            )
        );        
    }

    $wp_customize->add_setting( 'victim_options[blog_sidebar_status]', array(
        'capability' => 'edit_theme_options',
        'default' => 'normal',
        'sanitize_callback' => 'victim_sanitize_select',
    ) );

    $wp_customize->add_control( 'victim_options[blog_sidebar_status]', array(
        'type' => 'radio',
        'section' => 'victim_blog_entries_settings', // Add a default or your own section
        'label' => esc_html__( 'Sidebar Status', 'victim' ),
        'priority' => 10,
        'choices' => array(
            'normal' => esc_html__( 'Normal', 'victim' ),
            'sticky' => esc_html__( 'Sticky', 'victim' ),
        ),
        'active_callback' => 'victim_blog_layout_sidebar_callback',
    ) );

    if( class_exists('Victim_Customizer_Sortable_Control') ) {  
        $wp_customize->add_setting( 'victim_options[blog_enries_content]', array(
            'default' => array( 'featured_image', 'category', 'title', 'content', 'footer_meta' ),
            'capability' => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_multi_choices',
        ) );

        $wp_customize->add_control( 
            new Victim_Customizer_Sortable_Control( $wp_customize, 'victim_options[blog_enries_content]', array(
            'label'                 => esc_html__( 'Elements Positioning', 'victim' ),
            'description'           => esc_html__( 'Some elements are not works at some layout. Please reload interface after change the blog layout', 'victim' ),
            'section'               => 'victim_blog_entries_settings',
            'settings'              => 'victim_options[blog_enries_content]',
            'priority'              => 20,
            'choices'               => victim_blog_entries_elements(),
        ) ) );
    }

    $wp_customize->add_setting( 'victim_options[pagination_types]' , array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'victim_sanitize_select',
        'default' => 'page_number',
    ));

    $wp_customize->add_control( 'victim_options[pagination_types]', array(
        'label' => esc_html__( 'Pagination Type ', 'victim' ),
        'section' => 'victim_blog_entries_settings',
        'type' => 'select',
        'priority' => 20,
        'choices' => array(
            'load_more'  => esc_html__( 'Load More', 'victim' ),
            'page_number'   => esc_html__( 'Page Number', 'victim' ),
        ),
    ));

    if( class_exists('Victim_Customizer_Dimensions_Control') ) {
        /**
         * Blog Padding
         */
        $wp_customize->add_setting( 'victim_options[top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 90,
        ) );
        $wp_customize->add_setting( 'victim_options[bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 60,
        ) );

        $wp_customize->add_setting( 'victim_options[tablet_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 90,
        ) );
        $wp_customize->add_setting( 'victim_options[tablet_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 60,
        ) );

        $wp_customize->add_setting( 'victim_options[mobile_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 90,
        ) );
        $wp_customize->add_setting( 'victim_options[mobile_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 60,
        ) );

        $wp_customize->add_control( new Victim_Customizer_Dimensions_Control( $wp_customize, 'victim_options[blog_padding]', array(
            'label'                 => esc_html__( 'Spacing (px)', 'victim' ),
            'section'               => 'victim_blog_entries_settings',             
            'settings'   => array(
                'desktop_top'       => 'victim_options[top_padding]',
                'desktop_bottom'    => 'victim_options[bottom_padding]',
                'tablet_top'        => 'victim_options[tablet_top_padding]',
                'tablet_bottom'     => 'victim_options[tablet_bottom_padding]',
                'mobile_top'        => 'victim_options[mobile_top_padding]',
                'mobile_bottom'     => 'victim_options[mobile_bottom_padding]',
            ),
            'priority'              => 20,
            'input_attrs'           => array(
                'min'   => 0,
                'max'   => 400,
                'step'  => 1,
            ),
        ) ) );
    }

    $wp_customize->add_setting( 'victim_options[excerpt_length]' , array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        'type'      =>  'theme_mod',
        'default' => 25,
    ));

    $wp_customize->add_control( 'victim_options[excerpt_length]', array(
        'label' => esc_html__( 'Excerpt Length: ', 'victim' ),
        'description' => esc_html__( 'How many words want to show per page?', 'victim' ),
        'section' => 'victim_blog_entries_settings',
        'type'        => 'number',
        'priority' => 20,
        'input_attrs' => array(
            'min'  => 1,
            'max'   => 100,
            'step' => 1,
        ),
    ));


    if( class_exists('Victim_Customizer_Dimensions_Control') ) {
        /**
         * Blog Padding
         */
        $wp_customize->add_setting( 'victim_options[blog_single_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 105,
        ) );
        $wp_customize->add_setting( 'victim_options[blog_single_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 30,
        ) );

        $wp_customize->add_setting( 'victim_options[blog_single_tablet_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 105,
        ) );
        $wp_customize->add_setting( 'victim_options[blog_single_tablet_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 30,
        ) );

        $wp_customize->add_setting( 'victim_options[blog_single_mobile_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 105,
        ) );
        $wp_customize->add_setting( 'victim_options[blog_single_mobile_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 30,
        ) );

        $wp_customize->add_control( new Victim_Customizer_Dimensions_Control( $wp_customize, 'victim_options[blog_single_padding]', array(
            'label'                 => esc_html__( 'Spacing (px)', 'victim' ),
            'section'               => 'victim_blog_single_settings',             
            'settings'   => array(
                'desktop_top'       => 'victim_options[blog_single_top_padding]',
                'desktop_bottom'    => 'victim_options[blog_single_bottom_padding]',
                'tablet_top'        => 'victim_options[blog_single_tablet_top_padding]',
                'tablet_bottom'     => 'victim_options[blog_single_tablet_bottom_padding]',
                'mobile_top'        => 'victim_options[blog_single_mobile_top_padding]',
                'mobile_bottom'     => 'victim_options[blog_single_mobile_bottom_padding]',
            ),
            'priority'              => 35,
            'input_attrs'           => array(
                'min'   => 0,
                'max'   => 400,
                'step'  => 1,
            ),
        ) ) );
    }
    if( class_exists('Victim_Customizer_Dimensions_Control') ) {
        /**
         * Blog Padding
         */
        $wp_customize->add_setting( 'victim_options[blog_single_top_margin]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[blog_single_bottom_margin]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 0,
        ) );

        $wp_customize->add_setting( 'victim_options[blog_single_tablet_top_margin]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[blog_single_tablet_bottom_margin]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );

        $wp_customize->add_setting( 'victim_options[blog_single_mobile_top_margin]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[blog_single_mobile_bottom_margin]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );

        $wp_customize->add_control( new Victim_Customizer_Dimensions_Control( $wp_customize, 'victim_options[blog_single_margin]', array(
            'label'                 => esc_html__( 'Blog Content Margin (px)', 'victim' ),
            'section'               => 'victim_blog_single_settings',             
            'settings'   => array(
                'desktop_top'       => 'victim_options[blog_single_top_margin]',
                'desktop_bottom'    => 'victim_options[blog_single_bottom_margin]',
                'tablet_top'        => 'victim_options[blog_single_tablet_top_margin]',
                'tablet_bottom'     => 'victim_options[blog_single_tablet_bottom_margin]',
                'mobile_top'        => 'victim_options[blog_single_mobile_top_margin]',
                'mobile_bottom'     => 'victim_options[blog_single_mobile_bottom_margin]',
            ),
            'priority'              => 35,
            'input_attrs'           => array(
                'min'   => -400,
                'max'   => 400,
                'step'  => 1,
            ),
        ) ) );
    }

    if ( class_exists( 'Victim_Customize_Control_Radio_Image' ) ) { 
        $sidebar_single_choices = array(
            'full'    => array(
                'url'   =>  get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/full-width.png' ),
                'label' => esc_html__( 'Full Width', 'victim' ),
            ),
            'left'  => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-left.png' ),
                'label' => esc_html__( 'Left Sidebar', 'victim' ),
            ),
            'right' => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-right.png' ),
                'label' => esc_html__( 'Right Sidebar', 'victim' ),
            ),
        );

        $wp_customize->add_setting( 'victim_options[blog_single_sidebar_dispay]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_key',
            'type'      =>  'theme_mod',
            'default' => 'right',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Control_Radio_Image(
                $wp_customize, 'victim_options[blog_single_sidebar_dispay]', array(
                    'label'    => esc_html__( 'Sidebar Layout', 'victim' ),
                    'section'  => 'victim_blog_single_settings',
                    'priority' => 35,
                    'choices'  => $sidebar_single_choices,
                )
            )
        );
    }

    $wp_customize->add_setting( 'victim_options[sidebar_status]', array(
        'capability' => 'edit_theme_options',
        'default' => 'normal',
        'sanitize_callback' => 'victim_sanitize_select',
    ) );

    $wp_customize->add_control( 'victim_options[sidebar_status]', array(
        'type' => 'radio',
        'section' => 'victim_blog_single_settings', // Add a default or your own section
        'label' => esc_html__( 'Sidebar Status', 'victim' ),
        'priority' => 35,
        'choices' => array(
            'normal' => esc_html__( 'Normal', 'victim' ),
            'sticky' => esc_html__( 'Sticky', 'victim' ),
        ),
        'active_callback' => 'victim_blog_single_sidebar_stauts_callback',
    ) );

    $wp_customize->add_setting( 'victim_options[feature_images_status]', array(
        'capability' => 'edit_theme_options',
        'default' => 'normal',
        'sanitize_callback' => 'victim_sanitize_select',
    ) );

    $wp_customize->add_control( 'victim_options[feature_images_status]', array(
        'type' => 'radio',
        'section' => 'victim_blog_single_settings', // Add a default or your own section
        'label' => esc_html__( 'Featured Image Wide', 'victim' ),
        'priority' => 35,
        'choices' => array(
            'normal' => esc_html__( 'Normal', 'victim' ),
            'wide' => esc_html__( 'Wide', 'victim' ),
            'full' => esc_html__( 'Full', 'victim' ),
        ),
        'active_callback' => 'victim_blog_single_featured_image_callback',
    ) );

    if( class_exists('Victim_Customizer_Sortable_Control') ) {  
        $wp_customize->add_setting( 'victim_options[blog_single_enries_content]', array(
            'default' => array( 'featured_image', 'category', 'title', 'meta', 'content', 'tag' ),
            'capability' => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_multi_choices',
        ) );

        $wp_customize->add_control( 
            new Victim_Customizer_Sortable_Control( $wp_customize, 'victim_options[blog_single_enries_content]', array(
            'label'                 => esc_html__( 'Content Elements Positioning', 'victim' ),
            'description'           => esc_html__( 'Enable or disable content if you don\'t want it. Or move content position by drag and drop.', 'victim' ),
            'section'               => 'victim_blog_single_settings',
            'settings'              => 'victim_options[blog_single_enries_content]',
            'priority'              => 40,
            'choices'               => victim_blog_single_entries_elements(),
        ) ) );       

        $wp_customize->add_setting( 'victim_options[blog_single_sections_content]', array(
            'default' => array( 'blog_content', 'related_posts', 'comments', 'post_pagination' ),
            'capability' => 'edit_theme_options',
            'sanitize_callback'     => 'victim_sanitize_multi_choices',
        ) );

        $wp_customize->add_control( 
            new Victim_Customizer_Sortable_Control( $wp_customize, 'victim_options[blog_single_sections_content]', array(
            'label'                 => esc_html__( 'Section Positioning', 'victim' ),
            'description'           => esc_html__( 'Enable or disable content if you don\'t want it. Or move content position by drag and drop.', 'victim' ),
            'section'               => 'victim_blog_single_settings',
            'settings'              => 'victim_options[blog_single_sections_content]',
            'priority'              => 40,
            'choices'               => victim_blog_single_sections_elements(),
        ) ) );
    }

    $wp_customize->add_setting( 'victim_options[related_posts_query_type]', array(
        'capability' => 'edit_theme_options',
        'default' => 'category',
        'sanitize_callback' => 'victim_sanitize_select',
    ) );

    $wp_customize->add_control( 'victim_options[related_posts_query_type]', array(
        'type' => 'radio',
        'section' => 'victim_blog_single_settings', // Add a default or your own section
        'label' => esc_html__( 'Related Post Query', 'victim' ),
        'priority' => 40,
        'choices' => array(
            'category' => esc_html__( 'Categories', 'victim' ),
            'tag' => esc_html__( 'Tags', 'victim' ),
        ),
    ) );

    $wp_customize->add_setting( 'victim_options[related_posts_number]' , array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        'type'      =>  'theme_mod',
        'default' => 2,
    ));

    $wp_customize->add_control( 'victim_options[related_posts_number]', array(
        'label' => esc_html__( 'Show Related Posts Items: ', 'victim' ),
        'description' => esc_html__( 'How many related post want to show per page?', 'victim' ),
        'section' => 'victim_blog_single_settings',
        'type'        => 'number',
        'priority' => 40,
        'input_attrs' => array(
            'min'  => 1,
            'max'   => 100,
            'step' => 1,
        ),
    ));

    $wp_customize->add_section(
        'victim_woocommerce_setting', array(
            'priority' => 100,
            'title'    => esc_html__( 'Victim WooCommerce', 'victim' ),
            'panel'    => 'woocommerce',
        )
    );

    if ( class_exists( 'Victim_Customize_Control_Radio_Image' ) ) { 
        $woo_sidebar_choices = array(
            'full'    => array(
                'url'   =>  get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/full-width.png' ),
                'label' => esc_html__( 'Full Width', 'victim' ),
            ),
            'left'  => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-left.png' ),
                'label' => esc_html__( 'Left Sidebar', 'victim' ),
            ),
            'right' => array(
                'url'   => get_theme_file_uri( '/inc/customizer/customizer-radio-image/img/sidebar-right.png' ),
                'label' => esc_html__( 'Right Sidebar', 'victim' ),
            ),
        );

        $wp_customize->add_setting( 'victim_options[woo_sidebar_dispay]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_key',
            'type'      =>  'theme_mod',
            'default' => 'full',
        ));

        $wp_customize->add_control(
            new Victim_Customize_Control_Radio_Image(
                $wp_customize, 'victim_options[woo_sidebar_dispay]', array(
                    'label'    => esc_html__( 'Archive Sidebar Layout', 'victim' ),
                    'section'  => 'victim_woocommerce_setting',
                    'priority' => 10,
                    'choices'  => $woo_sidebar_choices,
                )
            )
        );
    }


    /**
     * End Victim WordPress Theme Footer Control Panel
     */
    $wp_customize->add_panel(
        'victim_footer', array(
            'priority' => 100,
            'title'    => esc_html__( 'Footer Settings', 'victim' ),
        )
    );

    $wp_customize->add_section( 'victim_footer_general' , array(
        'title'      => esc_html__( 'General', 'victim' ),
        'priority'   => 10,
        'panel'    => 'victim_footer',
    ) );

    if( class_exists('Victim_Customizer_Dimensions_Control') ) {
        /**
         * Footer Padding
         */
        $wp_customize->add_setting( 'victim_options[footer_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[footer_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number',
            'default'               => 0,
        ) );

        $wp_customize->add_setting( 'victim_options[footer_tablet_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[footer_tablet_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );

        $wp_customize->add_setting( 'victim_options[footer_mobile_top_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );
        $wp_customize->add_setting( 'victim_options[footer_mobile_bottom_padding]', array(
            'transport'             => 'postMessage',
            'sanitize_callback'     => 'victim_sanitize_number_blank',
            'default'               => 0,
        ) );

        $wp_customize->add_control( new Victim_Customizer_Dimensions_Control( $wp_customize, 'victim_options[footer_padding]', array(
            'label'                 => esc_html__( 'Footer Spacing (px)', 'victim' ),
            'section'               => 'victim_footer_general',             
            'settings'   => array(
                'desktop_top'       => 'victim_options[footer_top_padding]',
                'desktop_bottom'    => 'victim_options[footer_bottom_padding]',
                'tablet_top'        => 'victim_options[footer_tablet_top_padding]',
                'tablet_bottom'     => 'victim_options[footer_tablet_bottom_padding]',
                'mobile_top'        => 'victim_options[footer_mobile_top_padding]',
                'mobile_bottom'     => 'victim_options[footer_mobile_bottom_padding]',
            ),
            'priority'              => 5,
            'input_attrs'           => array(
                'min'   => 0,
                'max'   => 400,
                'step'  => 1,
            ),
        ) ) );
    }

    if ( class_exists( 'Victim_Toggle_Control' ) ) {
        $wp_customize->add_setting( 'victim_options[full_footer_content]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[full_footer_content]', 
            array(
                'label'  => esc_html__( 'Full Width Footer:', 'victim' ),
                'description' => esc_html__( 'If you want to make your footer full width then enable this options.', 'victim' ),
                'type'   => 'ios',
                'section'  => 'victim_footer_general',                
            ) 
        ));          

        $wp_customize->add_setting( 'victim_options[fixed_footer]', array(
            'default'     => false,
            'sanitize_callback' => 'victim_sanitize_checkbox',
            'capability' => 'edit_theme_options',
        ));

        $wp_customize->add_control( new Victim_Toggle_Control( $wp_customize, 
            'victim_options[fixed_footer]', 
            array(
                'label'  => esc_html__( 'Fixed Footer:', 'victim' ),
                'description' => esc_html__( 'If you want to make your footer fixed then enable this options.', 'victim' ),
                'type'   => 'ios',
                'section'  => 'victim_footer_general',                
            ) 
        ));  
    }

    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_theme_footer_colors', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_theme_footer_colors', array(
            'label'     => esc_html__( 'Footer Color Settings', 'victim' ),
            'section'   => 'victim_footer_general',
            'priority'  => 10,
        ) ) );
    } 

    if( class_exists('Victim_Customize_Alpha_Color_Control') ) {
        $wp_customize->add_setting( 'victim_options[footer_bg_colors]' , array(
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_bg_colors]', array(
               'label'    => esc_html__( 'Footer Background Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));         

        $wp_customize->add_setting( 'victim_options[footer_top_border_color]' , array(
            'default'     => '#333333',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_top_border_color]', array(
               'label'    => esc_html__( 'Footer Top Border Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        )); 

        $wp_customize->add_setting( 'victim_options[footer_color]' , array(
            'default'     => '#505050',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_color]', array(
               'label'    => esc_html__( 'Footer Text Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));          

        $wp_customize->add_setting( 'victim_options[footer_widget_title]' , array(
            'default'     => '#505050',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_widget_title]', array(
               'label'    => esc_html__( 'Footer Widget Title Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));            

        $wp_customize->add_setting( 'victim_options[footer_widget_heading]' , array(
            'default'     => '#505050',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_widget_heading]', array(
               'label'    => esc_html__( 'Footer Widget Heading Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));    

        $wp_customize->add_setting( 'victim_options[footer_link_color]' , array(
            'default'     => '#505050',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_link_color]', array(
               'label'    => esc_html__( 'Footer Link Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));        

        $wp_customize->add_setting( 'victim_options[footer_link_hover_color]' , array(
            'default'     => '#f68872',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_link_hover_color]', array(
               'label'    => esc_html__( 'Footer Link Hover Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));        

        $wp_customize->add_setting( 'victim_options[footer_copy_color]' , array(
            'default'     => '#5e5e5e',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_copy_color]', array(
               'label'    => esc_html__( 'Footer Copyright Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));

        $wp_customize->add_setting( 'victim_options[footer_copy_border_top]' , array(
            'default'     => '#ebebeb',
            'sanitize_callback' => 'victim_sanitize_rgba',
            'capability' => 'edit_theme_options',
            'type'      =>  'theme_mod',
        ));

        $wp_customize->add_control( 
            new Victim_Customize_Alpha_Color_Control( $wp_customize, 'victim_options[footer_copy_border_top]', array(
               'label'    => esc_html__( 'Footer Copyright Border Top Color: ', 'victim' ),
               'section'  => 'victim_footer_general',
            ) 
        ));
    }

    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_theme_footer_template', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_theme_footer_template', array(
            'label'     => esc_html__( 'Footer Template', 'victim' ),
            'section'   => 'victim_footer_general',
            'priority'  => 10,
        ) ) );
    } 

    $wp_customize->add_setting( 'victim_options[footer_type]' , array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'victim_sanitize_select',
        'default' => 'predefine_footer',
    ));

    $wp_customize->add_control( 'victim_options[footer_type]', array(
        'label' => esc_html__( 'Footer Type ', 'victim' ),
        'description' => esc_html__( 'We had predefine footer and footer builder as well. if you don\'t like our footer then you can build your footer from switching Custom Header.', 'victim' ),
        'section' => 'victim_footer_general',
        'type' => 'select',
        'priority' => 20,
        'choices' => array(
            'predefine_footer'  => esc_html__( 'Predefine Footer', 'victim' ),
            'custom_footer'   => esc_html__( 'Custom Footer', 'victim' ),
        ),
    ));

    if( class_exists('Victim_Elementor_Widget') ) {
        // Footer Templates Query
        $footer_args = array( 
            'post_type' => 'victim_templates', 
            'posts_per_page' => -1,
            'meta_key' => 'victim_template_types',
            'meta_value'  => 'footer',
            'meta_compare' => '>=',
            'orderby'      => 'meta_value',
            'order'        => 'ASC',
            'meta_query'   => array(
                'relation' => 'OR',
                array(
                    'key'     => 'victim_template_types',
                    'value'   => 'footer',
                    'compare' => '==',
                    'type'    => 'page',
                ),
            ),
        );

        $get_footer = get_posts($footer_args);
        $footer_template = array();
        if( $get_footer ) {
            foreach ($get_footer as $value) {
                $footer_template['default'] = esc_html__('Default', 'victim');
                $footer_template[$value->ID] = $value->post_title;
            }
        } else {
            $footer_template['default'] = esc_html__('Default', 'victim');
        }

        $wp_customize->add_setting( 'victim_options[footer_templates]' , array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'victim_sanitize_select',
            'default' => 'default',
        ));

        $args = array( 'post_type' => 'victim_templates');

        $wp_customize->add_control( 'victim_options[footer_templates]', array(
            'label' => esc_html__( 'Custom Template', 'victim' ),
            'section' => 'victim_footer_general',
            'type' => 'select',
            'priority' => 20,
            'choices' => $footer_template,
            'active_callback' => 'victim_footer_type_callback',
        ));
    }


    $wp_customize->add_section( 'victim_footer_widgets' , array(
        'title'      => esc_html__( 'Widget Settings', 'victim' ),
        'priority'   => 10,
        'panel'    => 'victim_footer',
    ) );


    if ( class_exists( 'Victim_Columns_Customize_Range_Control' ) ) {
        $wp_customize->add_setting( 'victim_options[footer_widgets_layout]', array( 
            'default' => '[3,6,9]',
            'sanitize_callback' => 'victim_sanitize_text_or_array_field',
        ) );

        // Section: section_footer
        $wp_customize->add_control( new Victim_Columns_Customize_Range_Control(
            $wp_customize,
            'victim_options[footer_widgets_layout]',
            array(
                'priority'    => 10,
                'label'       => esc_html_x( 'Footer widgets layout', 'backend', 'victim' ),
                'description' => esc_html_x( 'Select number of widget you want in the footer and then with the slider rearrange the layout', 'backend', 'victim' ),
            'section'   => 'victim_footer_widgets',
                'section'     => 'victim_footer_widgets',
                'input_attrs' => array(
                    'min'     => 0,
                    'max'     => 12,
                    'step'    => 1,
                    'maxCols' => 6,
                )
            )
        ) );
    }

    if( class_exists('Victim_Customizer_Heading_Control') ) {    
        $wp_customize->add_setting( 'victim_theme_footer_widget_typo', array(
            'sanitize_callback'     => 'wp_kses',
        ) );

        $wp_customize->add_control( new Victim_Customizer_Heading_Control( $wp_customize, 'victim_theme_footer_widget_typo', array(
            'label'     => esc_html__( 'Footer Widget Typography', 'victim' ),
            'section'   => 'victim_footer_widgets',
            'priority'  => 10,
        ) ) );
    } 

    if ( class_exists( 'Victim_Customizer_Range_Value_Control' ) ) {
        $wp_customize->add_setting(
            'victim_options[footer_widget_title_font_size]', array(
                'sanitize_callback' => 'victim_sanitize_number_range',
                'default'           => 24,
            )
        );

        $wp_customize->add_control(
            new Victim_Customizer_Range_Value_Control(
                $wp_customize, 'victim_options[footer_widget_title_font_size]', array(
                    'label'       => esc_html__( 'Widget Title Font Size (px):', 'victim' ),
                    'description' => esc_html__('All font size is px based. So please use slider to increase font size', 'victim'),
                    'section'     => 'victim_footer_widgets',
                    'type'        => 'range-value',
                    'input_attr'  => array(
                        'min'  => 0,
                        'max'  => 150,
                        'step' => 1,
                    ),
                    'priority'    => 10,
                    'sum_type'    => false,
                )
            )
        );        

        $wp_customize->add_setting(
            'victim_options[footer_widget_content_font_size]', array(
                'sanitize_callback' => 'victim_sanitize_number_range',
                'default'           => 16,
            )
        );

        $wp_customize->add_control(
            new Victim_Customizer_Range_Value_Control(
                $wp_customize, 'victim_options[footer_widget_content_font_size]', array(
                    'label'       => esc_html__( 'Widget Content Font Size (px):', 'victim' ),
                    'description' => esc_html__('All font size is px based. So please use slider to increase font size', 'victim'),
                    'section'     => 'victim_footer_widgets',
                    'type'        => 'range-value',
                    'input_attr'  => array(
                        'min'  => 0,
                        'max'  => 150,
                        'step' => 1,
                    ),
                    'priority'    => 10,
                    'sum_type'    => false,
                )
            )
        );        

        $wp_customize->add_setting(
            'victim_options[footer_widget_content_font_line_height]', array(
                'sanitize_callback' => 'victim_sanitize_number_range',
                'default'           => 1.65,
            )
        );

        $wp_customize->add_control(
            new Victim_Customizer_Range_Value_Control(
                $wp_customize, 'victim_options[footer_widget_content_font_line_height]', array(
                    'label'       => esc_html__( 'Widget Content line height:', 'victim' ),
                    'section'     => 'victim_footer_widgets',
                    'type'        => 'range-value',
                    'input_attr'  => array(
                        'min'  => 0,
                        'max'  => 150,
                        'step' => 0.1,
                    ),
                    'priority'    => 10,
                    'sum_type'    => false,
                )
            )
        );
    }


    $wp_customize->add_section( 'victim_footer_copyright' , array(
        'title'      => esc_html__( 'Copyright', 'victim' ),
        'priority'   => 10,
        'panel'    => 'victim_footer',
    ) );


    $wp_customize->add_setting(
        'victim_options[footer_copyright_info]', array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'victim_sanitize_advictim_html',
            'type'      =>  'theme_mod',
            'transport' => 'postMessage',
            'default'   => 'Created With By <a href="#">SoftHopper</a>',
        )
    );

    $wp_customize->add_control(
        'victim_options[footer_copyright_info]', array(
            'label' => esc_html__( 'Footer Copyright Text:', 'victim' ),
            'type' => 'text',
            'priority' => 20,
            'section' => 'victim_footer_copyright',
        )
    );

    $wp_customize->selective_refresh->add_partial( 'victim_options[footer_copyright_info]', array(
        'selector' => '.copyright-text', 
    ) );

    /**
     * End Victim WordPress Theme Footer Control Panel
     */    
}
add_action( 'customize_register', 'victim_customize_register' );