<?php 
if ( ! defined( 'ABSPATH' ) ) die( esc_html__( 'Direct access forbidden.', 'victim' ) );

if( ! class_exists( 'Victim_Static' ) ) :
class Victim_Static {

    /**
     * Allow HTML tag from escaping HTML 
     * 
     * @return void
     * @since v1.0
     */
    public static function html_allow() {
        return array(
            'a' => array(
                'href' => array(),
                'title' => array()
            ),
            'br' => array(),
            'del' => array(),
            'span' => array(),
            'em' => array(),
            'strong' => array(),
            'h1' => array(
                'class' => array(),
                'id' => array(),
            ),            
            'h2' => array(
                'class' => array(),
                'id' => array(),
            ),            
            'h3' => array(
                'class' => array(),
                'id' => array(),
            ),            
            'h4' => array(
                'class' => array(),
                'id' => array(),
            ),            
            'h5' => array(
                'class' => array(),
                'id' => array(),
            ),            
            'h6' => array(
                'class' => array(),
                'id' => array(),
            ),            
            'div' => array(
                'class' => array(),
                'id' => array(),
            ),
            'p' => array(
                'class' => array(),
                'id' => array(),
            ),          
            'i' => array(
                'class' => array(),
                'id' => array(),
            ),
        );
    }

    /**
     * @since v1.0
     */
    public static function total_grid() {
        return array(
            '1' => esc_html__( '1 Grid', 'victim' ),
            '2' => esc_html__( '2 Grid', 'victim' ),
            '3' => esc_html__( '3 Grid', 'victim' ),
            '4' => esc_html__( '4 Grid', 'victim' ),
            '5' => esc_html__( '5 Grid', 'victim' ),
            '6' => esc_html__( '6 Grid', 'victim' ),
            '7' => esc_html__( '7 Grid', 'victim' ),
            '8' => esc_html__( '8 Grid', 'victim' ),
            '9' => esc_html__( '9 Grid', 'victim' ),
            '10' => esc_html__( '10 Grid', 'victim' ),
            '11' => esc_html__( '11 Grid', 'victim' ),
            '12' => esc_html__( '12 Grid', 'victim' ),
        );
    }

    /**
     * @since v1.0
     */
    public static function total_items() {
        return array(
            '2' => esc_html__( 'Two', 'victim' ),
            '3' => esc_html__( 'Three', 'victim' ),
            '4' => esc_html__( 'Four', 'victim' ),
            '5' => esc_html__( 'Five', 'victim' ),
            '6' => esc_html__( 'Six', 'victim' ),
            '7' => esc_html__( 'Seven', 'victim' ),
        );
    }

}

// Removing this line is like not having a functions.php file
new Victim_Static;

endif;