<?php
/**
 * Front-End CSS and Scripts Files
 * @package Victim
 * @since 1.0
 */ 
if ( ! defined( 'ABSPATH' ) ) die( esc_html__( 'Direct access forbidden.', 'victim' ) );

$resource_minification = Victim_Utility::theme_options('combine_resource' );

$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

// enqueue styles
if( $resource_minification == true ) {
	wp_enqueue_style( 'victim-all-style', get_theme_file_uri( '/assets/css/all-plugin-css.min.css' ) );
} else {
	wp_enqueue_style( 'bootstrap', get_theme_file_uri( '/assets/css/bootstrap'. $suffix .'.css' ) );
	wp_enqueue_style( 'font-awesome-5-all', get_theme_file_uri( '/assets/css/fontawesome'. $suffix .'.css' ) );
	wp_enqueue_style( 'magnific-popup', get_theme_file_uri( '/assets/css/magnific-popup'. $suffix .'.css' ) );
	wp_enqueue_style( 'odometer-theme', get_theme_file_uri( '/assets/css/odometer-theme-default'. $suffix .'.css' ) ); 
	wp_enqueue_style( 'owl-carousel', get_theme_file_uri( '/assets/css/owl.carousel'. $suffix .'.css' ) );
}
wp_enqueue_style( 'victim-style', get_theme_file_uri( '/assets/css/style'. $suffix .'.css' ) ); 
wp_enqueue_style( 'victim-main-style', get_stylesheet_uri() ); 

// enqueue scripts
if( $resource_minification == true ) {
	wp_enqueue_script( 'victim-all-plugin', get_theme_file_uri( '/assets/js/all-plugin.min.js' ), array('jquery'), false, true);
} else {
	wp_enqueue_script( 'popper', get_theme_file_uri( '/assets/js/popper'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'bootstrap', get_theme_file_uri( '/assets/js/bootstrap'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'isInViewport', get_theme_file_uri( '/assets/js/isInViewport.jquery'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'isotope', get_theme_file_uri( '/assets/js/isotope.pkgd'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'packery-mode', get_theme_file_uri( '/assets/js/packery-mode.pkgd'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'fitvids', get_theme_file_uri( '/assets/js/jquery.fitvids'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'magnific-popup', get_theme_file_uri( '/assets/js/jquery.magnific-popup'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'odometer', get_theme_file_uri( '/assets/js/odometer'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'owl-carousel', get_theme_file_uri( '/assets/js/owl.carousel'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'nicescroll', get_theme_file_uri( '/assets/js/jquery.nicescroll'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'scrolla', get_theme_file_uri( '/assets/js/scrolla.jquery'. $suffix .'.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'theia-sticky-sidebar', get_theme_file_uri( '/assets/js/theia-sticky-sidebar.min.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'syoTimer', get_theme_file_uri( '/assets/js/syoTimer.js' ), array('jquery'), false, true);
	wp_enqueue_script( 'tweenmax', get_theme_file_uri( '/assets/js/TweenMax.min.js' ), array('jquery'), false, true);
}
wp_enqueue_script( 'victim-main', get_theme_file_uri( '/assets/js/main'. $suffix .'.js' ), array('jquery', 'masonry'), false, true);

// localize scripts
wp_localize_script('victim-main', 'victim', array (
        'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
        "please_wait_text" => esc_html__('Please wait...', 'victim' ),
        "no_more_post_text" => esc_html__('No More Posts', 'victim' ),
        "no_more_post_to_load_text" => esc_html__('No More Posts To Load', 'victim' ),
        "load_more_post_text" => esc_html__('Load More Posts', 'victim' ),
        'blog_layout' => Victim_Utility::theme_options(array('blog_layout_dispay', 'list')),
        'enable_custom_scroll' => Victim_Utility::theme_options('custom_scrollbar'),
    )
);

// Comment Reply Scripts
if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
    wp_enqueue_script( 'comment-reply' );
}
