<?php 
if ( ! defined( 'ABSPATH' ) ) die( esc_html__( 'Direct access forbidden.', 'victim' ) );

register_sidebar(  array(
    'name'          => esc_html__( 'Sidebar Blog', 'victim' ),
    'description'   => esc_html__( 'This sidebar will show in blog page', 'victim' ),
    'id'            => 'sidebar-blog',
    'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
) );

register_sidebar(  array(
    'name'          => esc_html__( 'Sidebar Single', 'victim' ),
    'description'   => esc_html__( 'This sidebar will show in blog single page', 'victim' ),
    'id'            => 'sidebar-single',
    'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s ">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
) );

register_sidebar(  array(
    'name'          => esc_html__( 'Sidebar Page', 'victim' ),
    'description'   => esc_html__( 'This sidebar will show in page', 'victim' ),
    'id'            => 'sidebar-page',
    'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s ">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h4 class="widget-title">',
    'after_title'   => '</h4>',
) );

$sidebar_woo = Victim_Utility::theme_options('woo_sidebar_dispay');
if ( class_exists( 'WooCommerce' ) && (isset($sidebar_woo) && $sidebar_woo !== 'full') ) {
    // Register new woo_sidebar widget area
    register_sidebar( array (
        'name'          => esc_html__( 'WooCommerce Sidebar', 'victim' ),
        'id'            => 'woo_sidebar',
        'before_widget' => '<aside id="%1$s" class="widget sidebar-woocommerce %2$s clr">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
} 


$footer_widgets_num = count( victim_footer_widgets_layout_array() );
// only register if not 0
if ( $footer_widgets_num > 0 ) {
    register_sidebar(
        array(
            'name'          => esc_html_x( 'Footer', 'backend', 'victim' ),
            'id'            => 'footer-widgets',
            'description'   => sprintf( esc_html_x( 'Footer area works best with %d widgets. This number can be changed in the Appearance &rarr; Customize &rarr; Theme Options &rarr; Footer.', 'backend', 'victim' ), $footer_widgets_num ),
            'before_widget' => '<div class="col-sm-12 col-lg-%%d"><div id="%1$s" class="widget clearfix %2$s">', // %%d is replaced dynamically in filter 'dynamic_sidebar_params'
            'after_widget'  => '</div></div>',
            'before_title'  => '<h3 class="widget-title">',
            'after_title'   => '</h3>'
        )
    );
} 